/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.items.corrupted;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruptionHelper;
import tombenpotter.sanguimancy.util.ConfigHandler;
import tombenpotter.sanguimancy.util.RandomUtils;

public class ItemCorruptedPickaxe
extends ItemPickaxe
implements IBindable {
    public int minimumCorruption = ConfigHandler.minimumToolCorruption;
    public IIcon silkTouch;
    public IIcon fortuneI;
    public IIcon fortuneII;
    public IIcon fortuneIII;
    public IIcon autosmelt;

    public ItemCorruptedPickaxe(Item.ToolMaterial material) {
        super(material);
        this.func_77637_a(Sanguimancy.tabSanguimancy);
        this.func_77655_b("Sanguimancy.corruptedPickaxe");
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("sanguimancy:CorruptedPickaxe");
        this.silkTouch = ir.func_94245_a("sanguimancy:CorruptedPickaxe_SilkTouch");
        this.fortuneI = ir.func_94245_a("sanguimancy:CorruptedPickaxe_FortuneI");
        this.fortuneII = ir.func_94245_a("sanguimancy:CorruptedPickaxe_FortuneII");
        this.fortuneIII = ir.func_94245_a("sanguimancy:CorruptedPickaxe_FortuneIII");
        this.autosmelt = ir.func_94245_a("sanguimancy:CorruptedPickaxe_AutoSmelt");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        RandomUtils.checkAndSetCompound(stack);
        if (this.getToolMode(stack) == 1) {
            return this.silkTouch;
        }
        if (this.getToolMode(stack) == 2) {
            return this.fortuneI;
        }
        if (this.getToolMode(stack) == 3) {
            return this.fortuneII;
        }
        if (this.getToolMode(stack) == 4) {
            return this.fortuneIII;
        }
        if (this.getToolMode(stack) == 5) {
            return this.autosmelt;
        }
        return this.field_77791_bV;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entityLivingBase) {
        if (block.func_149712_f(world, x, y, z) >= 0.0f) {
            RandomUtils.checkAndSetCompound(stack);
            int toolMode = this.getToolMode(stack);
            int metadata = world.func_72805_g(x, y, z);
            int lpConsumption = 10;
            if (toolMode == 0) {
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 1) {
                lpConsumption *= 5;
                RandomUtils.dropSilkDrops(world, block, x, y, z, metadata);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 2) {
                lpConsumption *= 5;
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 1);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 3) {
                lpConsumption *= 10;
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 2);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 4) {
                lpConsumption *= 20;
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 3);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 5) {
                lpConsumption *= 15;
                RandomUtils.dropSmeltDrops(world, block, x, y, z, metadata);
                world.func_147468_f(x, y, z);
            }
            if (entityLivingBase instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLivingBase;
                EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)player, (int)lpConsumption);
                if (this.getToolMode(stack) != 0 && world.field_73012_v.nextInt(20) == 0) {
                    SoulCorruptionHelper.incrementCorruption(world.func_72924_a(RandomUtils.getItemOwner(stack)));
                }
            }
        }
        return this.getToolMode(stack) <= 5;
    }

    public int getToolMode(ItemStack stack) {
        if (stack != null) {
            RandomUtils.checkAndSetCompound(stack);
            return stack.field_77990_d.func_74762_e("ToolMode");
        }
        return 0;
    }

    public void setToolMode(ItemStack stack, int mode) {
        RandomUtils.checkAndSetCompound(stack);
        stack.field_77990_d.func_74768_a("ToolMode", mode);
    }

    public void nextToolMode(ItemStack stack) {
        RandomUtils.checkAndSetCompound(stack);
        if (stack.field_77990_d.func_74762_e("ToolMode") + 1 <= 5) {
            this.setToolMode(stack, stack.field_77990_d.func_74762_e("ToolMode") + 1);
        } else {
            stack.field_77990_d.func_74768_a("ToolMode", 0);
            this.setToolMode(stack, 0);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        RandomUtils.checkAndSetCompound(stack);
        this.setToolMode(stack, 0);
        super.func_77622_d(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!GuiScreen.func_146272_n()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shift.info"));
        } else if (stack.func_77942_o()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.mode") + ": " + this.tooltipForMode(stack.field_77990_d.func_74762_e("ToolMode")));
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.minimum.corruption.1"));
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.minimum.corruption.2") + ": " + String.valueOf(this.minimumCorruption));
        }
    }

    public String tooltipForMode(int modeID) {
        String mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.mode.regular");
        if (modeID == 1) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.pickaxe.mode.silk.touch");
        } else if (modeID == 2) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.pickaxe.mode.fortune.1");
        } else if (modeID == 3) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.pickaxe.mode.fortune.2");
        } else if (modeID == 4) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.pickaxe.mode.fortune.3");
        } else if (modeID == 5) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.pickaxe.mode.smelt");
        }
        return mode;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        EnergyItems.checkAndSetItemOwner((ItemStack)stack, (EntityPlayer)player);
        if (player.func_70093_af()) {
            this.nextToolMode(stack);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        RandomUtils.checkAndSetCompound(stack);
        stack.func_77964_b(0);
        super.func_77663_a(stack, world, entity, par4, par5);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)((EntityPlayer)attacker), (int)15);
        }
        return true;
    }
}

