/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.client.render;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import tombenpotter.sanguimancy.client.model.ModelAltarDiviner;
import tombenpotter.sanguimancy.registry.BlocksRegistry;
import tombenpotter.sanguimancy.tile.TileAltarDiviner;

public class RenderAltarDiviner
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final RenderItem customRenderItem;
    public ModelAltarDiviner model = new ModelAltarDiviner();
    public ResourceLocation texture = new ResourceLocation("sanguimancy:textures/blocks/AltarDiviner.png");

    public RenderAltarDiviner() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float scale) {
        this.renderModel((TileAltarDiviner)tileEntity, x, y, z);
        if (tileEntity instanceof TileAltarDiviner) {
            TileAltarDiviner tile = (TileAltarDiviner)tileEntity;
            GL11.glPushMatrix();
            if (tile.func_70301_a(0) != null) {
                float scaleFactor = this.getGhostItemScaleFactor(tile.func_70301_a(0));
                float rotationAngle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
                EntityItem ghostEntityItem = new EntityItem(tile.func_145831_w());
                ghostEntityItem.field_70290_d = 0.0f;
                ghostEntityItem.func_92058_a(tile.func_70301_a(0));
                if (ghostEntityItem.func_92059_d().func_77973_b() instanceof ItemBlock) {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
                } else {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
                }
                GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
                this.customRenderItem.func_76986_a(ghostEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            GL11.glPopMatrix();
        }
    }

    public void renderModel(TileAltarDiviner tile, double x, double y, double z) {
        float scale = 1.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.texture);
        GL11.glRotatef((float)180.0f, (float)90.0f, (float)0.0f, (float)90.0f);
        this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    private float getGhostItemScaleFactor(ItemStack itemStack) {
        float scaleFactor = 1.0f;
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                switch (this.customRenderItem.getMiniBlockCount(itemStack, (byte)1)) {
                    case 1: {
                        return 0.9f;
                    }
                    case 2: {
                        return 0.9f;
                    }
                    case 3: {
                        return 0.9f;
                    }
                    case 4: {
                        return 0.9f;
                    }
                    case 5: {
                        return 0.8f;
                    }
                }
                return 0.9f;
            }
            switch (this.customRenderItem.getMiniItemCount(itemStack, (byte)1)) {
                case 1: {
                    return 0.65f;
                }
                case 2: {
                    return 0.65f;
                }
                case 3: {
                    return 0.65f;
                }
                case 4: {
                    return 0.65f;
                }
            }
            return 0.65f;
        }
        return scaleFactor;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                if (item.func_77973_b() == new ItemStack(BlocksRegistry.altarDiviner).func_77973_b()) {
                    this.render(0.5f, 15.0f, -0.5f, 0.1f);
                }
                return;
            }
            case EQUIPPED: {
                if (item.func_77973_b() == new ItemStack(BlocksRegistry.altarDiviner).func_77973_b()) {
                    this.render(2.0f, 15.0f, 5.0f, 0.1f);
                }
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                if (item.func_77973_b() == new ItemStack(BlocksRegistry.altarDiviner).func_77973_b()) {
                    this.render(1.0f, 19.0f, 7.0f, 0.1f);
                }
                return;
            }
            case INVENTORY: {
                if (item.func_77973_b() == new ItemStack(BlocksRegistry.altarDiviner).func_77973_b()) {
                    this.render(-0.01f, 10.0f, 0.0f, 0.1f);
                }
                return;
            }
        }
    }

    private void render(float x, float y, float z, float size) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.texture);
        GL11.glPushMatrix();
        GL11.glScalef((float)size, (float)size, (float)size);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.renderAll();
        GL11.glPopMatrix();
    }
}

