/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.blocks.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import tombenpotter.sanguimancy.blocks.BlockBloodTank;
import tombenpotter.sanguimancy.util.RandomUtils;

public class ItemBlockBloodTank
extends ItemBlock
implements IFluidContainerItem {
    public ItemBlockBloodTank(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        list.add(String.format(StatCollector.func_74838_a((String)"text.recipe.altar.tier"), stack.func_77960_j() + 1));
        if (!GuiScreen.func_146272_n()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shift.info"));
        } else {
            NBTTagCompound tag;
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.capacity") + ": " + String.valueOf(this.getCapacity(stack)) + "mB");
            if (stack.func_77942_o() && (tag = stack.field_77990_d.func_74775_l("tank")).func_74779_i("FluidName") != "") {
                list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.fluid") + ": " + RandomUtils.capitalizeFirstLetter(tag.func_74779_i("FluidName")));
                list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.amount") + ": " + tag.func_74762_e("Amount") + "/" + this.getCapacity(stack) + "mB");
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("tank") && stack.field_77990_d.func_74775_l("tank").func_74779_i("FluidName") != "") {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l("tank");
            return super.func_77653_i(stack) + " (" + RandomUtils.capitalizeFirstLetter(RandomUtils.capitalizeFirstLetter(tag.func_74779_i("FluidName")) + ")");
        }
        return super.func_77653_i(stack);
    }

    public FluidStack getFluid(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("tank") && stack.field_77990_d.func_74775_l("tank").func_74779_i("FluidName") != "") {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l("tank");
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        return BlockBloodTank.capacities[container.func_77960_j()] * 1000;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (resource == null || stack.field_77994_a != 1) {
            return 0;
        }
        int fillAmount = 0;
        int capacity = this.getCapacity(stack);
        NBTTagCompound tag = stack.field_77990_d;
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            fillAmount = Math.min(capacity, resource.amount);
        }
        if (fluid == null) {
            if (doFill) {
                fluid = resource.copy();
                fluid.amount = 0;
            }
        } else {
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            fillAmount = Math.min(capacity - fluid.amount, resource.amount);
        }
        fillAmount = Math.max(fillAmount, 0);
        if (doFill) {
            if (tag == null) {
                tag = stack.field_77990_d = new NBTTagCompound();
            }
            fluid.amount += fillAmount;
            tag.func_74782_a("tank", (NBTBase)fluid.writeToNBT(fluidTag == null ? new NBTTagCompound() : fluidTag));
        }
        return fillAmount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        NBTTagCompound tag = stack.field_77990_d;
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            if (fluidTag != null) {
                tag.func_82580_o("tank");
            }
            return null;
        }
        int drainAmount = Math.min(maxDrain, fluid.amount);
        if (doDrain) {
            tag.func_82580_o("tank");
            fluid.amount -= drainAmount;
            if (fluid.amount > 0) {
                this.fill(stack, fluid, true);
            }
        }
        fluid.amount = drainAmount;
        return fluid;
    }

    public int func_77647_b(int meta) {
        return meta;
    }
}

