/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.pages;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IRecipeRenderer;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.base.PageBase;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.pages.reciperenderers.ShapedOreRecipeRenderer;
import amerifrance.guideapi.pages.reciperenderers.ShapedRecipesRenderer;
import amerifrance.guideapi.pages.reciperenderers.ShapelessOreRecipeRenderer;
import amerifrance.guideapi.pages.reciperenderers.ShapelessRecipesRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PageIRecipe
extends PageBase {
    public IRecipe recipe;
    public IRecipeRenderer iRecipeRenderer;

    public PageIRecipe(IRecipe recipe) {
        this(recipe, PageIRecipe.getRenderer(recipe));
    }

    private static IRecipeRenderer getRenderer(IRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        if (recipe.getClass() == ShapedRecipes.class) {
            return new ShapedRecipesRenderer((ShapedRecipes)recipe);
        }
        if (recipe.getClass() == ShapelessRecipes.class) {
            return new ShapelessRecipesRenderer((ShapelessRecipes)recipe);
        }
        if (recipe.getClass() == ShapedOreRecipe.class) {
            return new ShapedOreRecipeRenderer((ShapedOreRecipe)recipe);
        }
        if (recipe.getClass() == ShapelessOreRecipe.class) {
            return new ShapelessOreRecipeRenderer((ShapelessOreRecipe)recipe);
        }
        return null;
    }

    public PageIRecipe(IRecipe recipe, IRecipeRenderer iRecipeRenderer) {
        this.recipe = recipe;
        this.iRecipeRenderer = iRecipeRenderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        super.draw(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRenderer);
        this.iRecipeRenderer.draw(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRenderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        super.drawExtras(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRenderer);
        this.iRecipeRenderer.drawExtras(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRenderer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iRecipeRenderer == null ? 0 : this.iRecipeRenderer.hashCode());
        result = 31 * result + (this.recipe == null ? 0 : this.recipe.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageIRecipe other = (PageIRecipe)obj;
        if (this.iRecipeRenderer == null ? other.iRecipeRenderer != null : !this.iRecipeRenderer.equals(other.iRecipeRenderer)) {
            return false;
        }
        return !(this.recipe == null ? other.recipe != null : !this.recipe.equals(other.recipe));
    }
}

