/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.items;

import amerifrance.guideapi.GuideAPI;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IGuideLinked;
import amerifrance.guideapi.api.base.Book;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemGuideBook
extends Item {
    public IIcon pagesIcon;
    public TIntObjectMap<IIcon> customIcons = new TIntObjectHashMap();

    public ItemGuideBook() {
        this.func_77637_a(GuideAPI.tabGuide);
        this.func_77655_b("GuideBook");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.func_77960_j()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            player.openGui((Object)GuideAPI.instance, stack.func_77960_j(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return false;
        }
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.func_77960_j() && world.func_147439_a(x, y, z) instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)world.func_147439_a(x, y, z);
            Book book = GuideRegistry.getBook(stack.func_77960_j());
            String entryName = guideLinked.getLinkedEntryUnlocName(world, x, y, z, player, stack);
            for (CategoryAbstract category : book.categoryList) {
                for (EntryAbstract entry : category.entryList) {
                    if (!entry.unlocEntryName.equals(entryName)) continue;
                    GuideAPI.proxy.openEntry(book, category, entry, player, stack);
                    return true;
                }
            }
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.func_77960_j()) {
            String name = String.valueOf(stack.func_77960_j());
            return this.func_77658_a() + "." + name;
        }
        return super.func_77667_c(stack);
    }

    public int getRenderPasses(int metadata) {
        return this.func_77623_v() ? 2 : 1;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        IIcon icon = (IIcon)this.customIcons.get(stack.func_77960_j());
        if (icon == null) {
            icon = pass == 0 ? this.field_77791_bV : this.pagesIcon;
        }
        return icon;
    }

    public String func_77653_i(ItemStack stack) {
        return GuideRegistry.isValidBook(stack) ? GuideRegistry.getBook(stack.func_77960_j()).getLocalizedDisplayName() : super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("guideapi:book_cover");
        this.pagesIcon = ir.func_94245_a("guideapi:book_pages");
        for (int i = 0; i < GuideRegistry.getBookList().size(); ++i) {
            Book book = GuideRegistry.getBook(i);
            if (book.itemTexture == null) continue;
            this.customIcons.put(i, (Object)ir.func_94245_a(book.itemTexture));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (GuideRegistry.isValidBook(stack) && GuideRegistry.getBook((int)stack.func_77960_j()).itemTexture == null) {
            if (pass == 0) {
                return GuideRegistry.getBook((int)stack.func_77960_j()).bookColor.getRGB();
            }
            return super.func_82790_a(stack, pass);
        }
        return super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        if (!GuideRegistry.isEmpty()) {
            for (Book book : GuideRegistry.getBookList()) {
                ItemStack stack = new ItemStack((Item)this, 1, GuideRegistry.getIndexOf(book));
                if (stack.field_77990_d == null) {
                    stack.field_77990_d = new NBTTagCompound();
                }
                stack.field_77990_d.func_74757_a("CreativeBook", book.isLostBook);
                list.add(stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (!GuideRegistry.isValidBook(stack)) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"text.book.warning"));
        }
        if (GuideRegistry.isValidBook(stack) && !Strings.isNullOrEmpty((String)GuideRegistry.getBook((int)stack.func_77960_j()).author)) {
            list.add(StatCollector.func_74838_a((String)GuideRegistry.getBook((int)stack.func_77960_j()).author));
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (stack.field_77990_d.func_74767_n("CreativeBook")) {
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"text.book.creative"));
        }
    }
}

