/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.nei;

import codechicken.nei.api.API;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.nei.NEI")
@ModOnly(value={"NotEnoughItems"})
public class NEI {
    @ZenMethod
    public static void hide(@NotNull IItemStack item) {
        MineTweakerAPI.apply(new NEIHideItemAction(MineTweakerMC.getItemStack(item)));
    }

    @ZenMethod
    public static void addEntry(@NotNull IItemStack stack) {
        MineTweakerAPI.apply(new NEIAddEntryAction(MineTweakerMC.getItemStack(stack)));
    }

    @ZenMethod
    public static void overrideName(@NotNull IItemStack item, @NotNull String name) {
        MineTweakerAPI.apply(new NEIOverrideNameAction(MineTweakerMC.getItemStack(item), name));
    }

    private static class NEIOverrideNameAction
    extends OneWayAction {
        private final ItemStack item;
        private final String name;

        public NEIOverrideNameAction(ItemStack item, String name) {
            this.item = item;
            this.name = name;
        }

        @Override
        public void apply() {
            API.setOverrideName((ItemStack)this.item, (String)this.name);
        }

        @Override
        public String describe() {
            return "Overriding NEI item name of " + this.item.func_77977_a() + " to " + this.name;
        }

        @Override
        public Object getOverrideKey() {
            return this.item;
        }
    }

    private static class NEIHideItemAction
    implements IUndoableAction {
        private final ItemStack stack;

        public NEIHideItemAction(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void apply() {
            API.hideItem((ItemStack)this.stack);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            API.addItemListEntry((ItemStack)this.stack);
        }

        @Override
        public String describe() {
            return "Hiding " + this.stack.func_77977_a() + " in NEI";
        }

        @Override
        public String describeUndo() {
            return "Displaying " + this.stack.func_77977_a() + " in NEI";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class NEIAddEntryAction
    implements IUndoableAction {
        private final ItemStack item;

        public NEIAddEntryAction(ItemStack item) {
            this.item = item;
        }

        @Override
        public void apply() {
            API.addItemListEntry((ItemStack)this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            API.hideItem((ItemStack)this.item);
        }

        @Override
        public String describe() {
            return "Adding " + this.item.func_82833_r() + " as NEI entry";
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.item.func_82833_r() + " as NEI entry";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

