/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.buildcraft;

import buildcraft.api.core.StackKey;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.Fuels")
@ModOnly(value={"BuildCraft|Core"}, version="6.0")
public class Fuels {
    private static final Constructor CONSTRUCT_FUEL;

    @ZenMethod
    public static void addCombustionEngineFuel(ILiquidStack fuel, double powerPerCycle, int totalBurningTime) {
        MineTweakerAPI.apply(new AddFuelAction(fuel, powerPerCycle, totalBurningTime));
    }

    @ZenMethod
    public static void removeCombustionEngineFuel(ILiquidStack fuel) {
        Fluid fluid = MineTweakerMC.getLiquidStack(fuel).getFluid();
        if (IronEngineFuel.fuels.containsKey(fluid.getName())) {
            MineTweakerAPI.apply(new RemoveFuelAction(fluid.getName(), (IronEngineFuel.Fuel)IronEngineFuel.fuels.get(fluid.getName())));
        } else {
            MineTweakerAPI.logWarning("No such iron engine fuel: " + fluid.getName());
        }
    }

    @ZenMethod
    public static void addCombustionEngineCoolant(ILiquidStack coolant, float coolingPerMB) {
        MineTweakerAPI.apply(new AddLiquidCoolantAction(coolant.getName(), new MTCoolant(coolingPerMB)));
    }

    @ZenMethod
    public static void addCoolantItem(IItemStack coolantItem, ILiquidStack coolantLiquid) {
        MineTweakerAPI.apply(new AddCoolantItemAction(new StackKey(MineTweakerMC.getItemStack(coolantItem)), MineTweakerMC.getLiquidStack(coolantLiquid)));
    }

    @ZenMethod
    public static void removeCombustionEngineCoolant(ILiquidStack coolant) {
        FluidStack fluid = MineTweakerMC.getLiquidStack(coolant);
        if (IronEngineCoolant.isCoolant((Fluid)fluid.getFluid())) {
            MineTweakerAPI.apply(new RemoveLiquidCoolantAction(fluid.getFluid().getName(), IronEngineCoolant.getCoolant((FluidStack)fluid)));
        } else {
            MineTweakerAPI.logWarning("No such iron engine coolant: " + fluid.getFluid().getName());
        }
    }

    @ZenMethod
    public static void removeCoolantItem(IIngredient item) {
        int numRemoved = 0;
        for (IItemStack itemStack : item.getItems()) {
            StackKey key = new StackKey(MineTweakerMC.getItemStack(itemStack));
            if (!IronEngineCoolant.solidCoolants.containsKey(key)) continue;
            MineTweakerAPI.apply(new RemoveCoolantItemAction(key, (FluidStack)IronEngineCoolant.solidCoolants.get(key)));
            ++numRemoved;
        }
        if (numRemoved == 0) {
            MineTweakerAPI.logWarning("No such iron engine coolant: " + item);
        }
    }

    static {
        Constructor newFuel = null;
        try {
            newFuel = IronEngineFuel.Fuel.class.getDeclaredConstructor(Fluid.class, Float.TYPE, Integer.TYPE);
            newFuel.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            MineTweakerAPI.logError("Could not load combustion engine fuel constructor", ex);
        }
        catch (SecurityException ex) {
            MineTweakerAPI.logError("Could not load combustion engine fuel constructor", ex);
        }
        CONSTRUCT_FUEL = newFuel;
    }

    private static class MTCoolant
    implements IronEngineCoolant.Coolant {
        private final float coolingPerMB;

        public MTCoolant(float coolingPerMB) {
            this.coolingPerMB = coolingPerMB;
        }

        public float getDegreesCoolingPerMB(float f) {
            return this.coolingPerMB;
        }
    }

    private static class RemoveCoolantItemAction
    implements IUndoableAction {
        private final StackKey item;
        private final FluidStack liquid;

        public RemoveCoolantItemAction(StackKey item, FluidStack liquid) {
            this.item = item;
            this.liquid = liquid;
        }

        @Override
        public void apply() {
            IronEngineCoolant.solidCoolants.remove(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            IronEngineCoolant.solidCoolants.put(this.item, this.liquid);
        }

        @Override
        public String describe() {
            return "Removing iron engine coolant item " + this.item.stack.func_82833_r();
        }

        @Override
        public String describeUndo() {
            return "Restoring iron engine coolant item " + this.item.stack.func_82833_r();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveLiquidCoolantAction
    implements IUndoableAction {
        private final String liquid;
        private final IronEngineCoolant.Coolant coolant;

        public RemoveLiquidCoolantAction(String liquid, IronEngineCoolant.Coolant coolant) {
            this.liquid = liquid;
            this.coolant = coolant;
        }

        @Override
        public void apply() {
            IronEngineCoolant.liquidCoolants.remove(this.liquid);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            IronEngineCoolant.liquidCoolants.put(this.liquid, this.coolant);
        }

        @Override
        public String describe() {
            return "Removing iron engine coolant " + this.liquid;
        }

        @Override
        public String describeUndo() {
            return "Restoring iron engine coolant " + this.liquid;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddCoolantItemAction
    implements IUndoableAction {
        private final StackKey item;
        private final FluidStack liquid;

        public AddCoolantItemAction(StackKey item, FluidStack liquid) {
            this.item = item;
            this.liquid = liquid;
        }

        @Override
        public void apply() {
            IronEngineCoolant.solidCoolants.put(this.item, this.liquid);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            IronEngineCoolant.solidCoolants.remove(this.item);
        }

        @Override
        public String describe() {
            return "Adding iron engine coolant item " + MineTweakerMC.getIItemStack(this.item.stack);
        }

        @Override
        public String describeUndo() {
            return "Removing iron engine coolant item " + MineTweakerMC.getIItemStack(this.item.stack);
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddLiquidCoolantAction
    implements IUndoableAction {
        private final String liquid;
        private final IronEngineCoolant.Coolant coolant;

        public AddLiquidCoolantAction(String liquid, IronEngineCoolant.Coolant coolant) {
            this.liquid = liquid;
            this.coolant = coolant;
        }

        @Override
        public void apply() {
            IronEngineCoolant.liquidCoolants.put(this.liquid, this.coolant);
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void undo() {
            IronEngineCoolant.liquidCoolants.remove(this.liquid);
        }

        @Override
        public String describe() {
            return "Adding iron engine coolant " + this.liquid;
        }

        @Override
        public String describeUndo() {
            return "Removing iron engine coolant " + this.liquid;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveFuelAction
    implements IUndoableAction {
        private final String fuelName;
        private final IronEngineFuel.Fuel fuel;

        public RemoveFuelAction(String fuelName, IronEngineFuel.Fuel fuel) {
            this.fuelName = fuelName;
            this.fuel = fuel;
        }

        @Override
        public void apply() {
            IronEngineFuel.fuels.remove(this.fuelName);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            IronEngineFuel.fuels.put(this.fuelName, this.fuel);
        }

        @Override
        public String describe() {
            return "Removing iron engine fuel " + this.fuelName;
        }

        @Override
        public String describeUndo() {
            return "Restoring iron engine fuel " + this.fuelName;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddFuelAction
    implements IUndoableAction {
        private final String fuelName;
        private final IronEngineFuel.Fuel fuel;

        public AddFuelAction(ILiquidStack fuel, double powerPerCycle, int totalBurningTime) {
            this.fuelName = fuel.getName();
            IronEngineFuel.Fuel ieFuel = null;
            try {
                if (CONSTRUCT_FUEL == null) {
                    System.out.println("No constructor for fuel");
                }
                ieFuel = (IronEngineFuel.Fuel)CONSTRUCT_FUEL.newInstance(MineTweakerMC.getLiquidStack(fuel).getFluid(), Float.valueOf((float)powerPerCycle), totalBurningTime);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Fuels.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Fuels.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Fuels.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(Fuels.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.fuel = ieFuel;
        }

        @Override
        public void apply() {
            IronEngineFuel.fuels.put(this.fuelName, this.fuel);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            IronEngineFuel.fuels.remove(this.fuelName);
        }

        @Override
        public String describe() {
            return "Adding iron engine fuel " + this.fuelName;
        }

        @Override
        public String describeUndo() {
            return "Removing iron engine fuel " + this.fuelName;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

