/*
 * Decompiled with CFR 0.152.
 */
package igwmod.lib;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import igwmod.lib.IGWLog;
import java.net.URI;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class Util {
    private static HashMap<String, ModContainer> entityNames;
    private static boolean reflectionFailed;

    public static Entity getEntityForClass(Class<? extends Entity> entityClass) {
        try {
            return entityClass.getConstructor(World.class).newInstance(FMLClientHandler.instance().getClient().field_71441_e);
        }
        catch (Exception e) {
            IGWLog.error("[LocatedEntity.java] An entity class doesn't have a constructor with a single World parameter! Entity = " + entityClass.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static String getModIdForEntity(Class<? extends Entity> entity) {
        EntityRegistry.EntityRegistration entityReg;
        if (reflectionFailed) {
            return "minecraft";
        }
        if (entityNames == null) {
            try {
                entityNames = (HashMap)ReflectionHelper.findField(EntityRegistry.class, (String[])new String[]{"entityNames"}).get(EntityRegistry.instance());
            }
            catch (Exception e) {
                IGWLog.warning("IGW-Mod failed to perform reflection! A result of this is that wiki pages related to Entities will not be found. Report to MineMaarten please!");
                e.printStackTrace();
                reflectionFailed = true;
                return "minecraft";
            }
        }
        if ((entityReg = EntityRegistry.instance().lookupModSpawn(entity, true)) == null) {
            return "minecraft";
        }
        ModContainer mod = entityNames.get(entityReg.getEntityName());
        if (mod == null) {
            IGWLog.info("Couldn't find the owning mod of the entity " + entityReg.getEntityName() + " even though it's registered through the EntityRegistry!");
            return "minecraft";
        }
        return mod.getModId().toLowerCase();
    }

    public static void openBrowser(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable) {
            IGWLog.error("Couldn't open link");
            throwable.printStackTrace();
        }
    }
}

