/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.version.github;

import appeng.core.AELog;
import appeng.services.version.Channel;
import appeng.services.version.Version;
import appeng.services.version.VersionCheckerConfig;
import appeng.services.version.VersionParser;
import appeng.services.version.github.DefaultFormattedRelease;
import appeng.services.version.github.FormattedRelease;
import appeng.services.version.github.MissingFormattedRelease;
import appeng.services.version.github.Release;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;

public final class ReleaseFetcher {
    private static final String GITHUB_RELEASES_URL = "https://api.github.com/repos/AppliedEnergistics/Applied-Energistics-2/releases";
    private static final FormattedRelease EXCEPTIONAL_RELEASE = new MissingFormattedRelease();
    private final VersionCheckerConfig config;
    private final VersionParser parser;

    public ReleaseFetcher(VersionCheckerConfig config, VersionParser parser) {
        this.config = config;
        this.parser = parser;
    }

    public FormattedRelease get() {
        Gson gson = new Gson();
        Type type = new ReleasesTypeToken().getType();
        try {
            URL releasesURL = new URL(GITHUB_RELEASES_URL);
            String rawReleases = this.getRawReleases(releasesURL);
            this.config.updateLastCheck();
            List releases = (List)gson.fromJson(rawReleases, type);
            FormattedRelease latestFitRelease = this.getLatestFitRelease(releases);
            return latestFitRelease;
        }
        catch (Exception e) {
            AELog.error(e);
            return EXCEPTIONAL_RELEASE;
        }
    }

    private String getRawReleases(URL url) throws IOException {
        return IOUtils.toString((URL)url);
    }

    private FormattedRelease getLatestFitRelease(Iterable<Release> releases) {
        String levelInConfig = this.config.level();
        Channel level = Channel.valueOf(levelInConfig);
        int levelOrdinal = level.ordinal();
        for (Release release : releases) {
            String rawVersion = release.tag_name;
            String changelog = release.body;
            Version version = this.parser.parse(rawVersion);
            if (version.channel().ordinal() < levelOrdinal) continue;
            return new DefaultFormattedRelease(version, changelog);
        }
        return EXCEPTIONAL_RELEASE;
    }

    private static final class ReleasesTypeToken
    extends TypeToken<List<Release>> {
        private ReleasesTypeToken() {
        }
    }
}

