/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.mtrm.gui;

import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiCheckBox;
import cpw.mods.fml.client.config.GuiSlider;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doubledoordev.mtrm.MineTweakerRecipeMaker;
import net.doubledoordev.mtrm.gui.MTRMContainer;
import net.doubledoordev.mtrm.network.MessageSend;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class MTRMGui
extends GuiContainer {
    private static final ResourceLocation craftingTableGuiTextures = new ResourceLocation("mtrm:gui/mtrm.png");
    private static final Pattern MATCH_ALL = Pattern.compile("<\\*>");
    private static final Pattern META_WILDCARD = Pattern.compile(":\\*>");
    private static final Pattern ORE_DICT = Pattern.compile("<ore:.*>");
    private static final Pattern REUSE = Pattern.compile("\\.reuse\\(\\)");
    private static final Pattern NO_RETURN = Pattern.compile("\\.noReturn\\(\\)");
    private static final Pattern ANY_DAMAGE = Pattern.compile("\\.anyDamage\\(\\)");
    private static final Pattern ONLY_DAMAGE = Pattern.compile("\\.onlyDamaged\\(\\)");
    private static final Pattern ONLY_DAMAGE_AT_MOST = Pattern.compile("\\.onlyDamageAtMost\\((\\d+)\\)");
    private static final Pattern ONLY_DAMAGE_AT_LEAST = Pattern.compile("\\.onlyDamageAtLeast\\((\\d+)\\)");
    private static final Pattern ONLY_DAMAGE_BETWEEN = Pattern.compile("\\.onlyDamageBetween\\((\\d+), ?(\\d+)\\)");
    private static final Pattern WITH_DAMAGE = Pattern.compile("\\.withDamage\\((\\d+)\\)");
    private static final Pattern TRANSFORM_DAMAGE = Pattern.compile("\\.transformDamage\\((\\d+)\\)");
    private static final Pattern GIVE_BACK = Pattern.compile("\\.giveBack\\(<(.*):(.*)(:\\d+)?>(?: ?\\* ?(\\d+))\\)");
    private static final Pattern TRANSFORM_REPLACE = Pattern.compile("\\.transformReplace\\(<(.*):(.*)(:\\d+)?>(?: ?\\* ?(\\d+))\\)");
    private static final int ID_SEND = 10;
    private static final int ID_REMOVE = 11;
    private static final int ID_SHAPELESS = 12;
    private static final int ID_MIRRORED = 13;
    private static final int ID_OPTION_OK = 14;
    private static final int ID_OPTION_MATCHALL = 15;
    private static final int ID_OPTION_OREDICT = 16;
    private static final int ID_OPTION_META_WILDCARD = 17;
    private static final int ID_OPTION_NEXT_OREDICT = 18;
    private static final int ID_OPTION_ANY_DAMAGE = 19;
    private static final int ID_OPTION_WITH_DAMAGE = 20;
    private static final int ID_OPTION_ONLY_DAMAGED = 21;
    private static final int ID_CLOSE = 22;
    private static final int ID_OPTION_ONLY_DAMAGE_AT_LEAST = 23;
    private static final int ID_OPTION_ONLY_DAMAGE_AT_MOST = 24;
    private static final int ID_OPTION_ONLY_DAMAGE_BETWEEN = 25;
    private static final int ID_OPTION_REUSE = 26;
    private static final int ID_OPTION_ID_OPTION_TRANSFORM_DAMAGE = 27;
    private static final int ID_OPTION_NO_RETURN = 28;
    private static final int ID_OPTION_RETURN_OK = 29;
    private static final int ID_OPTION_ID_OPTION_TRANSFORM_REPLACE = 30;
    private static final int ID_OPTION_GIVE_BACK = 31;
    private final GuiSlider.ISlider iSlider = new GuiSlider.ISlider(){

        public void onChangeSliderValue(GuiSlider slider) {
            MTRMGui.this.tokenTxt.func_146180_a(MTRMGui.this.getStackToken(false, MTRMGui.this.field_147002_h.func_75139_a(MTRMGui.this.editing).func_75211_c()));
        }
    };
    private final MTRMContainer container;
    private GuiCheckBox remove;
    private GuiCheckBox shapeless;
    private GuiCheckBox mirrored;
    private GuiCheckBox matchAll;
    private GuiCheckBox oreDict;
    private GuiCheckBox metaWildcard;
    private GuiCheckBox anyDamage;
    private GuiButtonExt optionsOk;
    private GuiButtonExt nextOreDict;
    private GuiTextField tokenTxt;
    private GuiCheckBox onlyDamaged;
    private GuiCheckBox withDamage;
    private GuiCheckBox onlyDamageAtLeast;
    private GuiCheckBox onlyDamageAtMost;
    private GuiCheckBox onlyDamageBetween;
    private GuiCheckBox reuse;
    private GuiCheckBox noReturn;
    private GuiCheckBox transformDamage;
    private GuiCheckBox transformReplace;
    private GuiCheckBox giveBack;
    private GuiButtonExt returnOk;
    private Map<GuiCheckBox, GuiSlider[]> sliders = new HashMap<GuiCheckBox, GuiSlider[]>();
    private Map<GuiCheckBox, Pattern> patterns = new HashMap<GuiCheckBox, Pattern>();
    private Map<GuiCheckBox, GuiCustomLabel[]> labels = new HashMap<GuiCheckBox, GuiCustomLabel[]>();
    private GuiCheckBox[] allDamage;
    private GuiCheckBox[] allTransform;
    private GuiCheckBox[][] allGroups;
    private MessageSend messageSend = new MessageSend();
    private int editing = -1;
    private int lastOreId = 0;
    private String errorMessage;

    public MTRMGui(MTRMContainer container) {
        super((Container)container);
        this.field_147000_g = 181;
        this.container = container;
    }

    public String getStackToken(boolean nextOreDict, ItemStack stack) {
        boolean metaWildcard = this.metaWildcard.isChecked();
        boolean oreDict = this.oreDict.isChecked();
        if (stack == null) {
            return "null";
        }
        String stackName = GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b());
        StringBuilder builder = new StringBuilder("<");
        if (oreDict) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            if (ids.length != 0) {
                stackName = "ore:" + OreDictionary.getOreName((int)ids[this.lastOreId]);
                if (nextOreDict) {
                    ++this.lastOreId;
                }
                if (this.lastOreId >= ids.length) {
                    this.lastOreId = 0;
                }
            } else {
                oreDict = false;
            }
        }
        builder.append(stackName);
        if (!oreDict && (metaWildcard || stack.func_77960_j() != 0)) {
            builder.append(':').append(metaWildcard || stack.func_77960_j() == Short.MAX_VALUE ? "*" : Integer.valueOf(stack.func_77960_j()));
        }
        builder.append('>');
        if (stack.field_77994_a > 1) {
            builder.append(" * ").append(stack.field_77994_a);
        }
        if (this.anyDamage.isChecked()) {
            builder.append(".anyDamage()");
        }
        if (this.onlyDamaged.isChecked()) {
            builder.append(".onlyDamaged()");
        }
        if (this.withDamage.isChecked()) {
            builder.append(".withDamage(").append(this.sliders.get(this.withDamage)[0].getValueInt()).append(')');
        }
        if (this.onlyDamageAtLeast.isChecked()) {
            builder.append(".onlyDamageAtLeast(").append(this.sliders.get(this.onlyDamageAtLeast)[0].getValueInt()).append(')');
        }
        if (this.onlyDamageAtMost.isChecked()) {
            builder.append(".onlyDamageAtMost(").append(this.sliders.get(this.onlyDamageAtMost)[0].getValueInt()).append(')');
        }
        if (this.onlyDamageBetween.isChecked()) {
            builder.append(".onlyDamageBetween(").append(this.sliders.get(this.onlyDamageBetween)[0].getValueInt()).append(", ").append(this.sliders.get(this.onlyDamageBetween)[1].getValueInt()).append(')');
        }
        if (this.reuse.isChecked()) {
            builder.append(".reuse()");
        }
        if (this.noReturn.isChecked()) {
            builder.append(".noReturn()");
        }
        if (this.transformDamage.isChecked()) {
            builder.append(".transformDamage(").append(this.sliders.get(this.transformDamage)[0].getValueInt()).append(')');
        }
        if (this.container.func_75139_a(46).func_75216_d() && (this.giveBack.isChecked() || this.transformReplace.isChecked())) {
            ItemStack returnStack = this.container.func_75139_a(46).func_75211_c();
            if (this.giveBack.isChecked()) {
                builder.append(".giveBack(<");
            } else if (this.transformReplace.isChecked()) {
                builder.append(".transformReplace(<");
            }
            builder.append(GameData.getItemRegistry().func_148750_c((Object)returnStack.func_77973_b()));
            if (returnStack.func_77960_j() != 0) {
                builder.append(':').append(returnStack.func_77960_j());
            }
            builder.append('>');
            if (returnStack.field_77994_a > 1) {
                builder.append(" * ").append(returnStack.field_77994_a);
            }
            builder.append(')');
        }
        return builder.toString();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 0;
        this.field_146292_n.add(new GuiButtonExt(id++, this.field_146294_l / 2 + 65, this.field_146295_m / 2 - 50, 10, 10, "*"));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.field_146292_n.add(new GuiButtonExt(id++, this.field_146294_l / 2 - 52 + x * 26, this.field_146295_m / 2 - 78 + y * 26, 10, 10, "*"));
            }
        }
        this.remove = new GuiCheckBox(11, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 80, "Remove", false);
        this.field_146292_n.add(this.remove);
        this.shapeless = new GuiCheckBox(12, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 70, "Shapeless", false);
        this.field_146292_n.add(this.shapeless);
        this.mirrored = new GuiCheckBox(13, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 60, "Mirrored", true);
        this.field_146292_n.add(this.mirrored);
        this.field_146292_n.add(new GuiButtonExt(10, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 45, 110, 20, "Ok!"));
        this.field_146292_n.add(new GuiButtonExt(22, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 25, 110, 20, "Close"));
        int wOffset = this.field_146294_l / 2 - 200;
        int hOffset = this.field_146295_m / 2 - 110;
        this.tokenTxt = new GuiTextField(this.field_146289_q, wOffset, hOffset - 25, 220 + this.field_146999_f, 20);
        this.tokenTxt.func_146203_f(Integer.MAX_VALUE);
        this.matchAll = new GuiCheckBox(15, wOffset, hOffset += 10, "Match not empty (*)", false);
        this.field_146292_n.add(this.matchAll);
        this.oreDict = new GuiCheckBox(16, wOffset, hOffset += 10, "Use ore dictionary", true);
        this.field_146292_n.add(this.oreDict);
        this.metaWildcard = new GuiCheckBox(17, wOffset, hOffset += 10, "Match any metadata", false);
        this.field_146292_n.add(this.metaWildcard);
        this.anyDamage = new GuiCheckBox(19, wOffset, hOffset += 10, "Any Damage", false);
        this.field_146292_n.add(this.anyDamage);
        this.onlyDamaged = new GuiCheckBox(21, wOffset, hOffset += 10, "Only Damaged", false);
        this.field_146292_n.add(this.onlyDamaged);
        this.withDamage = new GuiCheckBox(20, wOffset, hOffset += 10, "With Damage X", false);
        this.field_146292_n.add(this.withDamage);
        this.onlyDamageAtLeast = new GuiCheckBox(23, wOffset, hOffset += 10, "With Damage >= X", false);
        this.field_146292_n.add(this.onlyDamageAtLeast);
        this.onlyDamageAtMost = new GuiCheckBox(24, wOffset, hOffset += 10, "With Damage < X", false);
        this.field_146292_n.add(this.onlyDamageAtMost);
        this.onlyDamageBetween = new GuiCheckBox(25, wOffset, hOffset += 10, "With X > Damage > Y", false);
        this.field_146292_n.add(this.onlyDamageBetween);
        this.transformDamage = new GuiCheckBox(27, wOffset, hOffset += 10, "Transform Damage", false);
        this.field_146292_n.add(this.transformDamage);
        this.transformReplace = new GuiCheckBox(30, wOffset, hOffset += 10, "Transform Replace", false);
        this.field_146292_n.add(this.transformReplace);
        this.reuse = new GuiCheckBox(26, wOffset, hOffset += 10, "Reuse", false);
        this.field_146292_n.add(this.reuse);
        this.noReturn = new GuiCheckBox(28, wOffset, hOffset += 10, "No Return", false);
        this.field_146292_n.add(this.noReturn);
        this.giveBack = new GuiCheckBox(31, wOffset, hOffset += 10, "GiveBack", false);
        this.field_146292_n.add(this.giveBack);
        this.nextOreDict = new GuiButtonExt(18, wOffset, hOffset += 40, 110, 20, "Next oredict value");
        this.field_146292_n.add(this.nextOreDict);
        this.optionsOk = new GuiButtonExt(14, wOffset, hOffset += 20, 110, 20, "Save changes!");
        this.field_146292_n.add(this.optionsOk);
        this.allDamage = new GuiCheckBox[]{this.matchAll, this.metaWildcard, this.anyDamage, this.onlyDamaged, this.withDamage, this.onlyDamageAtLeast, this.onlyDamageAtMost, this.onlyDamageBetween};
        this.allTransform = new GuiCheckBox[]{this.transformDamage, this.transformReplace, this.reuse, this.noReturn, this.giveBack};
        this.allGroups = new GuiCheckBox[][]{this.allDamage, this.allTransform};
        this.addPatterns(this.matchAll, MATCH_ALL);
        this.addPatterns(this.metaWildcard, META_WILDCARD);
        this.addPatterns(this.anyDamage, ANY_DAMAGE);
        this.addPatterns(this.onlyDamaged, ONLY_DAMAGE);
        this.addPatterns(this.reuse, REUSE);
        this.addPatterns(this.noReturn, NO_RETURN);
        id = 100;
        int hOffsetText = (hOffset += 30) - this.field_147009_r - 10;
        GuiCustomLabel returnSlot = new GuiCustomLabel(){

            @Override
            public void draw(boolean b) {
                if (!b) {
                    MTRMGui.this.func_73729_b((MTRMGui.this.field_146294_l - MTRMGui.this.field_146999_f) / 2 - 110, (MTRMGui.this.field_146295_m - MTRMGui.this.field_147000_g) / 2 + 142, 21, 20, 18, 18);
                }
            }
        };
        this.addLabels(this.transformReplace, returnSlot, new GuiCustomLabelText("Transform Replace:", -110, hOffsetText - 68));
        this.addPatterns(this.transformReplace, TRANSFORM_REPLACE);
        returnSlot = new GuiCustomLabel(){

            @Override
            public void draw(boolean b) {
                if (!b) {
                    MTRMGui.this.func_73729_b((MTRMGui.this.field_146294_l - MTRMGui.this.field_146999_f) / 2 - 110, (MTRMGui.this.field_146295_m - MTRMGui.this.field_147000_g) / 2 + 142, 21, 20, 18, 18);
                }
            }
        };
        this.addLabels(this.giveBack, returnSlot, new GuiCustomLabelText("Give Back:", -110, hOffsetText - 68));
        this.addPatterns(this.giveBack, GIVE_BACK);
        this.returnOk = new GuiButtonExt(29, wOffset + 20, hOffset - 68, 20, 18, "OK");
        this.field_146292_n.add(this.returnOk);
        this.addSliders(this.withDamage, new GuiSlider(id++, wOffset, hOffset, 220 + this.field_146999_f, 20, "X = ", "", 0.0, 0.0, 0.0, false, true, this.iSlider));
        this.addLabels(this.withDamage, new GuiCustomLabelText("With Damage X", -110, hOffsetText));
        this.addPatterns(this.withDamage, WITH_DAMAGE);
        this.addSliders(this.onlyDamageAtLeast, new GuiSlider(id++, wOffset, hOffset, 220 + this.field_146999_f, 20, "X = ", "", 0.0, 0.0, 0.0, false, true, this.iSlider));
        this.addLabels(this.onlyDamageAtLeast, new GuiCustomLabelText("With Damage >= X", -110, hOffsetText));
        this.addPatterns(this.onlyDamageAtLeast, ONLY_DAMAGE_AT_LEAST);
        this.addSliders(this.onlyDamageAtMost, new GuiSlider(id++, wOffset, hOffset, 220 + this.field_146999_f, 20, "X = ", "", 0.0, 0.0, 0.0, false, true, this.iSlider));
        this.addLabels(this.onlyDamageAtMost, new GuiCustomLabelText("With Damage < X", -110, hOffsetText));
        this.addPatterns(this.onlyDamageAtMost, ONLY_DAMAGE_AT_MOST);
        this.addSliders(this.onlyDamageBetween, new GuiSlider(id++, wOffset, hOffset, 220 + this.field_146999_f, 20, "X = ", "", 0.0, 0.0, 0.0, false, true, this.iSlider), new GuiSlider(id++, wOffset, hOffset + 20, 220 + this.field_146999_f, 20, "Y = ", "", 0.0, 0.0, 0.0, false, true, this.iSlider));
        this.addLabels(this.onlyDamageBetween, new GuiCustomLabelText("With X > Damage > Y", -110, hOffsetText));
        this.addPatterns(this.onlyDamageBetween, ONLY_DAMAGE_BETWEEN);
        this.addSliders(this.transformDamage, new GuiSlider(id++, wOffset, hOffset += 50, 220 + this.field_146999_f, 20, "X = ", "", 0.0, 0.0, 0.0, false, true, this.iSlider));
        this.addLabels(this.transformDamage, new GuiCustomLabelText("Transform with X damage", -110, hOffsetText += 50));
        this.addPatterns(this.transformDamage, TRANSFORM_DAMAGE);
        this.setOptionsVisible(false);
    }

    private void addPatterns(GuiCheckBox key, Pattern values) {
        this.patterns.put(key, values);
    }

    private void addSliders(GuiCheckBox key, GuiSlider ... values) {
        for (GuiSlider value : values) {
            this.field_146292_n.add(value);
        }
        this.sliders.put(key, values);
    }

    private void addLabels(GuiCheckBox key, GuiCustomLabel ... values) {
        this.labels.put(key, values);
    }

    protected void func_146984_a(Slot slot, int slotNumber, int mouseBtn, int modifier) {
        super.func_146984_a(slot, slotNumber, mouseBtn, modifier);
        if (slot != null && slotNumber >= 0 && slotNumber <= 9) {
            this.showOptionsFor(slotNumber);
            this.messageSend.data[slotNumber] = this.getStackToken(false, slot.func_75211_c());
            this.showOptionsFor(slotNumber);
        }
        if (slotNumber == 46) {
            this.tokenTxt.func_146180_a(this.getStackToken(true, this.field_147002_h.func_75139_a(this.editing).func_75211_c()));
        }
    }

    protected void func_146284_a(GuiButton btn) {
        switch (btn.field_146127_k) {
            case 22: {
                this.field_146297_k.field_71439_g.func_71053_j();
                break;
            }
            case 10: {
                this.messageSend.remove = this.remove.isChecked();
                this.messageSend.shapeless = this.shapeless.isChecked();
                this.messageSend.mirrored = this.mirrored.isChecked();
                MineTweakerRecipeMaker.getSnw().sendToServer((IMessage)this.messageSend);
                break;
            }
            case 11: 
            case 12: {
                boolean bl = this.mirrored.field_146124_l = !this.shapeless.isChecked() && !this.remove.isChecked();
                if (this.mirrored.field_146124_l) break;
                this.mirrored.setIsChecked(false);
                break;
            }
            case 14: {
                this.saveOptions();
                break;
            }
            case 15: {
                this.radioBoxToggle(this.matchAll, this.allDamage);
                this.oreDict.setIsChecked(!this.matchAll.isChecked());
                this.oreDict.field_146124_l = !this.matchAll.isChecked();
                this.nextOreDict.field_146124_l = this.oreDict.isChecked();
                if (this.matchAll.isChecked()) {
                    this.tokenTxt.func_146180_a("<*>");
                    break;
                }
                this.tokenTxt.func_146180_a(this.getStackToken(false, this.field_147002_h.func_75139_a(this.editing).func_75211_c()));
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                this.radioBoxToggle((GuiCheckBox)btn, this.allDamage);
                this.tokenTxt.func_146180_a(this.getStackToken(false, this.field_147002_h.func_75139_a(this.editing).func_75211_c()));
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                this.radioBoxToggle((GuiCheckBox)btn, this.allTransform);
                this.tokenTxt.func_146180_a(this.getStackToken(false, this.field_147002_h.func_75139_a(this.editing).func_75211_c()));
                break;
            }
            case 16: {
                this.nextOreDict.field_146124_l = this.oreDict.isChecked();
            }
            case 18: 
            case 29: {
                this.tokenTxt.func_146180_a(this.getStackToken(true, this.field_147002_h.func_75139_a(this.editing).func_75211_c()));
                break;
            }
            default: {
                if (btn.field_146127_k < 0 || btn.field_146127_k > 10) break;
                this.showOptionsFor(btn.field_146127_k);
            }
        }
    }

    private void radioBoxToggle(GuiCheckBox clicked, GuiCheckBox ... others) {
        for (GuiCheckBox checkBox : others) {
            if (this.sliders.containsKey(checkBox)) {
                for (GuiSlider guiSlider : this.sliders.get(checkBox)) {
                    guiSlider.field_146125_m = checkBox.isChecked();
                }
            }
            if (this.labels.containsKey(checkBox)) {
                for (GuiCustomLabel guiCustomLabel : this.labels.get(checkBox)) {
                    guiCustomLabel.draw = checkBox.isChecked();
                }
            }
            if (checkBox == clicked) continue;
            if (clicked.isChecked()) {
                checkBox.setIsChecked(false);
            }
            checkBox.field_146124_l = !clicked.isChecked();
        }
    }

    private void saveOptions() {
        this.messageSend.data[this.editing] = this.tokenTxt.func_146179_b();
        if (this.messageSend.data[this.editing].equalsIgnoreCase("null")) {
            this.messageSend.data[this.editing] = null;
        }
        this.editing = -1;
        this.setOptionsVisible(false);
    }

    private void showOptionsFor(int id) {
        GuiCheckBox[] group;
        int i$;
        int len$;
        GuiCheckBox[][] arr$;
        if (this.editing != id) {
            this.lastOreId = 0;
        }
        this.editing = id;
        String token = this.messageSend.data[id];
        if (token == null) {
            this.tokenTxt.func_146180_a("null");
            this.oreDict.field_146124_l = id != 0;
            this.oreDict.setIsChecked(id != 0);
            this.nextOreDict.field_146124_l = id != 0;
            arr$ = this.allGroups;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                for (GuiCheckBox checkBox : group = arr$[i$]) {
                    checkBox.setIsChecked(false);
                    if (this.sliders.containsKey(checkBox)) {
                        for (GuiSlider guiSlider : this.sliders.get(checkBox)) {
                            guiSlider.minValue = 0.0;
                            guiSlider.maxValue = 0.0;
                            guiSlider.setValue(0.0);
                        }
                    }
                    if (!this.labels.containsKey(checkBox)) continue;
                    for (GuiCustomLabel guiCustomLabel : this.labels.get(checkBox)) {
                        guiCustomLabel.draw = false;
                    }
                }
            }
            this.container.func_75139_a(46).func_75215_d(null);
        } else {
            this.tokenTxt.func_146180_a(token);
            this.oreDict.field_146124_l = id != 0;
            this.oreDict.setIsChecked(ORE_DICT.matcher(token).find() && id != 0);
            this.nextOreDict.field_146124_l = this.oreDict.isChecked() && id != 0;
            arr$ = this.allGroups;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                for (GuiCheckBox checkBox : group = arr$[i$]) {
                    if (!this.patterns.containsKey(checkBox)) continue;
                    checkBox.setIsChecked(this.patterns.get(checkBox).matcher(token).find());
                    this.radioBoxToggle(checkBox, group);
                }
            }
            Matcher m = GIVE_BACK.matcher(token);
            if (m.find()) {
                int meta = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                int size = m.group(4) != null ? Integer.parseInt(m.group(4)) : 1;
                this.container.func_75139_a(46).func_75215_d(new ItemStack(GameRegistry.findItem((String)m.group(1), (String)m.group(2)), size, meta));
            }
        }
        arr$ = this.allGroups;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (GuiCheckBox checkBox : group = arr$[i$]) {
                Matcher matcher;
                GuiSlider[] guiSliderArray;
                boolean bl = checkBox.field_146124_l = id != 0;
                if (!this.sliders.containsKey(checkBox)) continue;
                for (GuiSlider slider : guiSliderArray = this.sliders.get(checkBox)) {
                    ItemStack stack;
                    slider.minValue = 0.0;
                    slider.maxValue = 2.147483647E9;
                    slider.setValue(0.0);
                    if (this.oreDict.isChecked() || (stack = this.container.func_75139_a(this.editing).func_75211_c()) == null) continue;
                    slider.maxValue = stack.func_77973_b().func_77612_l();
                }
                if (token == null || !this.patterns.containsKey(checkBox) || !(matcher = this.patterns.get(checkBox).matcher(token)).find()) continue;
                for (int i = 0; i < matcher.groupCount() && i < guiSliderArray.length; ++i) {
                    guiSliderArray[i].setValue((double)Integer.parseInt(matcher.group(i + 1)));
                }
            }
        }
        this.setOptionsVisible(true);
    }

    private void setOptionsVisible(boolean visible) {
        this.matchAll.field_146125_m = visible;
        this.metaWildcard.field_146125_m = visible;
        this.optionsOk.field_146125_m = visible;
        this.oreDict.field_146125_m = visible;
        this.nextOreDict.field_146125_m = visible;
        this.anyDamage.field_146125_m = visible;
        this.withDamage.field_146125_m = visible;
        this.onlyDamaged.field_146125_m = visible;
        this.reuse.field_146125_m = visible;
        this.returnOk.field_146125_m = visible;
        GuiCheckBox[][] arr$ = this.allGroups;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            GuiCheckBox[] group;
            for (GuiCheckBox gui : group = arr$[i$]) {
                gui.field_146125_m = visible;
                if (this.sliders.containsKey(gui)) {
                    for (GuiSlider guiSlider : this.sliders.get(gui)) {
                        guiSlider.field_146125_m = visible && gui.isChecked();
                    }
                }
                if (!this.labels.containsKey(gui)) continue;
                for (GuiCustomLabel guiCustomLabel : this.labels.get(gui)) {
                    guiCustomLabel.draw = visible && gui.isChecked();
                }
            }
        }
        this.tokenTxt.func_146189_e(visible);
        if (!visible) {
            this.container.func_75141_a(46, null);
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (!this.tokenTxt.func_146201_a(p_73869_1_, p_73869_2_)) {
            super.func_73869_a(p_73869_1_, p_73869_2_);
        }
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
        this.tokenTxt.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        if (this.editing != -1) {
            this.field_146289_q.func_78276_b("Editing slot " + this.editing, -110, -55, 0xFFFFFF);
            this.field_146289_q.func_78276_b("Slot Options", -100, -20, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b("Recipe Options", this.field_146999_f + 15, 0, 0xFFFFFF);
        this.field_146289_q.func_78276_b("MineTweaker Recipe Maker", 28, 4, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 5, 0x404040);
        if (this.errorMessage != null) {
            this.func_73732_a(this.field_146289_q, this.errorMessage, this.field_146999_f / 2, -15, 0xFF0000);
        }
        this.field_146289_q.func_78276_b("0", 144, 53, 0xFFFFFF);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.field_146289_q.func_78276_b(String.valueOf(1 + y * 3 + x), 28 + x * 26, 25 + y * 26, 0xFFFFFF);
            }
        }
        for (GuiCustomLabel[] labela : this.labels.values()) {
            for (GuiCustomLabel label : labela) {
                if (!label.draw) continue;
                label.draw(true);
            }
        }
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(craftingTableGuiTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        for (GuiCustomLabel[] labela : this.labels.values()) {
            for (GuiCustomLabel label : labela) {
                if (!label.draw) continue;
                label.draw(false);
            }
        }
        this.tokenTxt.func_146194_f();
    }

    public void showMessage(String message) {
        this.errorMessage = message;
    }

    private class GuiCustomLabelText
    extends GuiCustomLabel {
        String text;
        int color;
        int x;
        int y;

        public GuiCustomLabelText(String s, int x, int y) {
            this.color = 0xFFFFFF;
            this.x = x;
            this.y = y;
            this.text = s;
        }

        @Override
        public void draw(boolean b) {
            if (b) {
                MTRMGui.this.field_146289_q.func_78276_b(this.text, this.x, this.y, this.color);
            }
        }
    }

    private abstract class GuiCustomLabel {
        boolean draw = false;

        private GuiCustomLabel() {
        }

        public abstract void draw(boolean var1);
    }
}

