/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.worldgen;

import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.block.BlockArtifactsPressurePlate;
import com.draco18s.artifacts.block.BlockIllusionary;
import com.draco18s.artifacts.block.BlockQuickSand;
import com.draco18s.artifacts.block.BlockSpikes;
import com.draco18s.artifacts.block.BlockTrap;
import com.draco18s.artifacts.entity.TileEntityTrap;
import com.draco18s.artifacts.worldgen.StructureApprenticeTower;
import com.draco18s.artifacts.worldgen.StructureApprenticeTowerAncient;
import com.draco18s.artifacts.worldgen.StructureJourneymanTower;
import com.draco18s.artifacts.worldgen.StructureJourneymanTowerAncient;
import com.draco18s.artifacts.worldgen.StructureMasterTower;
import com.draco18s.artifacts.worldgen.StructureMasterTowerAncient;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;

public class PlaceTraps
implements IWorldGenerator {
    WorldGenerator quicksandPit = new WorldGenLakes(BlockQuickSand.instance);
    WorldGenerator wizardTowerTier1 = new StructureApprenticeTower();
    WorldGenerator wizardTowerTier1Ancient = new StructureApprenticeTowerAncient();
    WorldGenerator wizardTowerTier2 = new StructureJourneymanTower();
    WorldGenerator wizardTowerTier2Ancient = new StructureJourneymanTowerAncient();
    WorldGenerator wizardTowerTier3 = new StructureMasterTower();
    WorldGenerator wizardTowerTier3Ancient = new StructureMasterTowerAncient();
    public static boolean genPyramids;
    public static boolean genTemples;
    public static boolean genStrongholds;
    public static boolean genMystcraftLibraries;
    public static boolean genQuicksand;
    public static int weightTower1;
    public static int weightTower1A;
    public static int weightTower2;
    public static int weightTower2A;
    public static int weightTower3;
    public static int weightTower3A;
    public static int quicksandRarity;
    public static int towerRarity;
    public static int towerRarityMod;
    public static boolean whitelistEnabled;
    public static boolean blacklistEnabled;
    public static int[] whitelist;
    public static int[] blacklist;
    public static boolean iDontLikeAntibuilders;

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int dim = world.field_73011_w.field_76574_g;
        boolean found = false;
        if (!(dim != 0 || whitelistEnabled && Arrays.binarySearch(whitelist, 0) < 0 || blacklistEnabled && Arrays.binarySearch(blacklist, 0) >= 0)) {
            int vary;
            int tex = chunkX * 16 + 10;
            int tez = chunkZ * 16 + 10;
            if (genPyramids && BiomeDictionary.isBiomeOfType((BiomeGenBase)world.func_72807_a(tex, tez), (BiomeDictionary.Type)BiomeDictionary.Type.DESERT) && world.func_147439_a(tex, 64, tez) == Blocks.field_150325_L) {
                this.generatePyramidTrap(rand, world, tex, 64, tez);
            }
            tex = chunkX * 16 + 9;
            tez = chunkZ * 16 + 11;
            if (genTemples && BiomeDictionary.isBiomeOfType((BiomeGenBase)world.func_72807_a(tex, tez), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                for (vary = 60; vary < 130; ++vary) {
                    if (world.func_147439_a(tex, vary, tez) == Blocks.field_150367_z) {
                        this.generateTempleTrap(rand, world, tex, vary, tez);
                    }
                    if (world.func_147439_a(tex + 2, vary, tez - 2) != Blocks.field_150367_z) continue;
                    this.generateTempleTrap(rand, world, tex + 2, vary, tez - 2);
                }
            }
            if (genStrongholds) {
                for (vary = 0; vary < 60; ++vary) {
                    tex = chunkX * 16 + 8;
                    tez = chunkZ * 16 + 12;
                    Block block = world.func_147439_a(tex, vary, tez);
                    if (block == Blocks.field_150417_aV) {
                        found = this.generateStrongholdTrap(rand, world, this.locateStrongholdCorridor(world, tex, vary, tez));
                    }
                    if ((block = world.func_147439_a(tex = chunkX * 16 + 8, vary, tez = chunkZ * 16 + 4)) == Blocks.field_150417_aV) {
                        found = this.generateStrongholdTrap(rand, world, this.locateStrongholdCorridor(world, tex, vary, tez));
                    }
                    if ((block = world.func_147439_a(tex = chunkX * 16 + 4, vary, tez = chunkZ * 16 + 8)) == Blocks.field_150417_aV) {
                        found = this.generateStrongholdTrap(rand, world, this.locateStrongholdCorridor(world, tex, vary, tez));
                    }
                    if ((block = world.func_147439_a(tex = chunkX * 16 + 4, vary, tez = chunkZ * 16 + 12)) == Blocks.field_150417_aV) {
                        found = this.generateStrongholdTrap(rand, world, this.locateStrongholdCorridor(world, tex, vary, tez));
                    }
                    if (found) break;
                }
            }
            int ch = 0;
            int bid = world.func_72807_a((int)(chunkX * 16), (int)(chunkZ * 16)).field_76756_M;
            if (bid == 6) {
                ch = 4;
            } else if (genQuicksand && rand.nextInt(quicksandRarity) == 0 && bid != 2 && bid != 3 && bid != 22 && (bid < 17 || bid > 20)) {
                tex = chunkX * 16 + rand.nextInt(16) + 8;
                tez = chunkZ * 16 + rand.nextInt(16) + 8;
                this.quicksandPit.func_76484_a(world, rand, tex, 128, tez);
            }
            boolean ocean = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
            boolean mushroom = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM);
            boolean mountain = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
            boolean magical = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
            boolean frozen = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN);
            boolean flag = (mountain || magical || mushroom || ocean) && !frozen;
            int weightTotal = weightTower1 + weightTower1A + weightTower2 + weightTower2A + weightTower3 + weightTower3A;
            if (weightTotal > 0 && (bid == 3 || flag) && rand.nextInt(towerRarity) == 0 && chunkX % 3 == 0 && chunkZ % 3 == 0) {
                tex = chunkX * 16 + rand.nextInt(24);
                tez = chunkZ * 16 + rand.nextInt(24);
                int m = rand.nextInt(weightTotal);
                if (magical && m >= 3) {
                    m -= 2;
                }
                if (m < weightTower3) {
                    this.wizardTowerTier3.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower3A + weightTower3) {
                    this.wizardTowerTier3Ancient.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower2 + weightTower3A + weightTower3) {
                    this.wizardTowerTier2.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower2A + weightTower2 + weightTower3A + weightTower3) {
                    this.wizardTowerTier2Ancient.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower1 + weightTower2A + weightTower2 + weightTower3A + weightTower3) {
                    this.wizardTowerTier1.func_76484_a(world, rand, tex, 128, tez);
                } else {
                    this.wizardTowerTier1Ancient.func_76484_a(world, rand, tex, 128, tez);
                }
            }
        } else if (!(dim == 1 || dim == -1 || whitelistEnabled && Arrays.binarySearch(whitelist, dim) < 0 || blacklistEnabled && Arrays.binarySearch(blacklist, dim) >= 0)) {
            Block mystcraftLectern;
            int tez;
            int tex;
            int bid = world.func_72807_a((int)(chunkX * 16), (int)(chunkZ * 16)).field_76756_M;
            boolean ocean = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
            boolean mushroom = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM);
            boolean mountain = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
            boolean magical = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
            boolean frozen = BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150568_d((int)bid), (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN);
            boolean flag = (mountain || magical || mushroom || ocean) && !frozen;
            int weightTotal = weightTower1 + weightTower1A + weightTower2 + weightTower2A + weightTower3 + weightTower3A;
            if (weightTotal > 0 && (bid == 3 || flag) && rand.nextInt(towerRarity) == 0 && chunkX % 3 == 0 && chunkZ % 3 == 0) {
                tex = chunkX * 16 + rand.nextInt(24);
                tez = chunkZ * 16 + rand.nextInt(24);
                int m = rand.nextInt(weightTotal);
                if (magical && m >= 3) {
                    m -= 2;
                }
                if (m < weightTower3) {
                    this.wizardTowerTier3.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower3A + weightTower3) {
                    this.wizardTowerTier3Ancient.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower2 + weightTower3A + weightTower3) {
                    this.wizardTowerTier2.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower2A + weightTower2 + weightTower3A + weightTower3) {
                    this.wizardTowerTier2Ancient.func_76484_a(world, rand, tex, 128, tez);
                } else if (m < weightTower1 + weightTower2A + weightTower2 + weightTower3A + weightTower3) {
                    this.wizardTowerTier1.func_76484_a(world, rand, tex, 128, tez);
                } else {
                    this.wizardTowerTier1Ancient.func_76484_a(world, rand, tex, 128, tez);
                }
            }
            if (DragonArtifacts.mystcraftLoaded && (mystcraftLectern = Block.func_149684_b((String)"Mystcraft:BlockLectern")) != null) {
                for (int vary = 130; vary > 0; --vary) {
                    Block b;
                    tex = chunkX * 16 + 8;
                    tez = chunkZ * 16 + 4;
                    if ((world.func_147439_a(tex, vary, tez) == mystcraftLectern || world.func_147439_a(tex, vary, tez + 1) == mystcraftLectern) && (b = world.func_147439_a(tex - 2, vary - 2, tez)) == Blocks.field_150347_e) {
                        found = this.generateLibraryTrap(rand, world, tex - 2, vary - 2, tez, ForgeDirection.WEST);
                    }
                    tex = chunkX * 16 + 4;
                    tez = chunkZ * 16 + 8;
                    if (found || world.func_147439_a(tex, vary, tez) != mystcraftLectern && world.func_147439_a(tex + 1, vary, tez) != mystcraftLectern || (b = world.func_147439_a(tex, vary - 2, tez - 2)) != Blocks.field_150347_e) continue;
                    found = this.generateLibraryTrap(rand, world, tex, vary - 2, tez - 2, ForgeDirection.NORTH);
                }
            }
        }
    }

    private void generateTempleTrap(Random rand, World world, int tex, int tey, int tez) {
        EnumFacing enumfacing;
        int m = world.func_72805_g(tex, tey, tez);
        TileEntityDispenser disp = (TileEntityDispenser)world.func_147438_o(tex, tey, tez);
        for (int d = 0; d < 9; ++d) {
            disp.func_70298_a(d, 64);
        }
        world.func_147449_b(tex, tey, tez, BlockTrap.instance);
        world.func_72921_c(tex, tey, tez, m, 3);
        TileEntityTrap dis = (TileEntityTrap)world.func_147438_o(tex, tey, tez);
        if (dis != null) {
            PlaceTraps.addTrapItem(rand, dis, 4);
        }
        if ((enumfacing = BlockDispenser.func_149937_b((int)m)).func_82599_e() != 0) {
            disp = (TileEntityDispenser)world.func_147438_o(tex += 2, tey, tez += 6 * enumfacing.func_82599_e());
            if (disp != null) {
                for (int d = 0; d < 9; ++d) {
                    disp.func_70298_a(d, 64);
                }
                m = world.func_72805_g(tex, tey, tez);
                world.func_147449_b(tex, tey, tez, BlockTrap.instance);
                world.func_72921_c(tex, tey, tez, m, 3);
                dis = (TileEntityTrap)world.func_147438_o(tex, tey, tez);
                if (dis != null) {
                    PlaceTraps.addTrapItem(rand, dis, 4);
                }
            }
        } else {
            disp = (TileEntityDispenser)world.func_147438_o(tex += 6 * enumfacing.func_82601_c(), tey, tez += 2);
            if (disp != null) {
                for (int d = 0; d < 9; ++d) {
                    disp.func_70298_a(d, 64);
                }
                m = world.func_72805_g(tex, tey, tez);
                world.func_147449_b(tex, tey, tez, BlockTrap.instance);
                world.func_72921_c(tex, tey, tez, m, 3);
                dis = (TileEntityTrap)world.func_147438_o(tex, tey, tez);
                if (dis != null) {
                    PlaceTraps.addTrapItem(rand, dis, 4);
                }
            }
        }
    }

    private void generatePyramidTrap(Random rand, World world, int x, int y, int z) {
        int r = rand.nextInt(4);
        switch (r) {
            case 0: {
                this.pyramidSpikeTrap(rand, world, x, y, z);
                break;
            }
            case 1: {
                this.pyramidArrowTrap(rand, world, x, y, z);
                break;
            }
            case 2: {
                this.pyramidHiddenBoom(rand, world, x, y, z);
                break;
            }
        }
    }

    private void pyramidHiddenBoom(Random rand, World world, int x, int y, int z) {
        world.func_147468_f(x, 53, z);
        int l = 3;
        do {
            int ox = rand.nextInt(3) - 1;
            int oz = rand.nextInt(3) - 1;
            world.func_147449_b(x + ox, 53, z + oz, BlockArtifactsPressurePlate.invisObsidian);
        } while (--l >= 0);
    }

    private void pyramidArrowTrap(Random rand, World world, int x, int y, int z) {
        int oz;
        int ox;
        for (ox = -1; ox <= 1; ++ox) {
            for (oz = -1; oz <= 1; ++oz) {
                world.func_147449_b(x + ox, 51, z + oz, Blocks.field_150322_A);
            }
        }
        for (ox = -1; ox <= 1; ++ox) {
            for (oz = -1; oz <= 1; ++oz) {
                Vec3 v = Vec3.func_72443_a((double)(x + ox), (double)52.0, (double)(z + oz));
                this.simpleTrap(rand, world, v);
            }
        }
    }

    private void pyramidSpikeTrap(Random rand, World world, int x, int y, int z) {
        int oz;
        int ox;
        for (ox = -1; ox <= 1; ++ox) {
            for (oz = -1; oz <= 1; ++oz) {
                if (ox == 0 && oz == 0) continue;
                world.func_147449_b(x + ox, 51, z + oz, Blocks.field_150322_A);
            }
        }
        for (ox = -1; ox <= 1; ++ox) {
            for (oz = -1; oz <= 1; ++oz) {
                if (ox == 0 && oz == 0) continue;
                world.func_147449_b(x + ox, 52, z + oz, BlockSpikes.instance);
            }
        }
        world.func_147449_b(x, 53, z, BlockArtifactsPressurePlate.invisObsidian);
    }

    private Vec3[] locateStrongholdCorridor(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            if (world.func_147439_a(x + 1, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x - 1, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z + 1) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z - 1) == Blocks.field_150350_a) {
                if (world.func_147439_a(x + 1, y + 1, z + 1) == Blocks.field_150350_a && world.func_147439_a(x + 1, y + 1, z - 1) == Blocks.field_150350_a && world.func_147439_a(x - 1, y + 1, z + 1) == Blocks.field_150350_a && world.func_147439_a(x - 1, y + 1, z - 1) == Blocks.field_150350_a) {
                    return new Vec3[]{Vec3.func_72443_a((double)x, (double)y, (double)z), Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0)};
                }
                if (world.func_147439_a(x + 1, y + 1, z + 1) == Blocks.field_150417_aV) {
                    return this.locateStrongholdCorridor(world, x + 1, y + 1, z + 1);
                }
                if (world.func_147439_a(x + 1, y + 1, z - 1) == Blocks.field_150417_aV) {
                    return this.locateStrongholdCorridor(world, x + 1, y + 1, z - 1);
                }
                if (world.func_147439_a(x - 1, y + 1, z + 1) == Blocks.field_150417_aV) {
                    return this.locateStrongholdCorridor(world, x - 1, y + 1, z + 1);
                }
                if (world.func_147439_a(x - 1, y + 1, z - 1) == Blocks.field_150417_aV) {
                    return this.locateStrongholdCorridor(world, x - 1, y + 1, z - 1);
                }
            } else {
                if (world.func_147439_a(x + 1, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z + 1) == Blocks.field_150350_a && world.func_147439_a(x + 2, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z + 2) == Blocks.field_150350_a && world.func_147439_a(x + 1, y + 1, z + 1) == Blocks.field_150350_a) {
                    return new Vec3[]{Vec3.func_72443_a((double)(x + 1), (double)y, (double)(z + 1)), Vec3.func_72443_a((double)-1.0, (double)0.0, (double)-1.0)};
                }
                if (world.func_147439_a(x - 1, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z + 1) == Blocks.field_150350_a && world.func_147439_a(x - 2, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z + 2) == Blocks.field_150350_a && world.func_147439_a(x - 1, y + 1, z + 1) == Blocks.field_150350_a) {
                    return new Vec3[]{Vec3.func_72443_a((double)(x - 1), (double)y, (double)(z + 1)), Vec3.func_72443_a((double)1.0, (double)0.0, (double)-1.0)};
                }
                if (world.func_147439_a(x + 1, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z - 1) == Blocks.field_150350_a && world.func_147439_a(x + 2, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z - 2) == Blocks.field_150350_a && world.func_147439_a(x + 1, y + 1, z - 1) == Blocks.field_150350_a) {
                    return new Vec3[]{Vec3.func_72443_a((double)(x + 1), (double)y, (double)(z - 1)), Vec3.func_72443_a((double)-1.0, (double)0.0, (double)1.0)};
                }
                if (world.func_147439_a(x - 1, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z - 1) == Blocks.field_150350_a && world.func_147439_a(x - 2, y + 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z - 2) == Blocks.field_150350_a && world.func_147439_a(x - 1, y + 1, z - 1) == Blocks.field_150350_a) {
                    return new Vec3[]{Vec3.func_72443_a((double)(x - 1), (double)y, (double)(z - 1)), Vec3.func_72443_a((double)-1.0, (double)0.0, (double)-1.0)};
                }
            }
        } else if (world.func_147439_a(x, y + 1, z) == Blocks.field_150417_aV) {
            if (world.func_147439_a(x + 1, ++y, z) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x + 1, y - 1, z);
            }
            if (world.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x - 1, y - 1, z);
            }
            if (world.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x, y - 1, z + 1);
            }
            if (world.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x, y - 1, z - 1);
            }
            if (world.func_147439_a(x + 1, y, z + 1) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x + 1, y - 1, z + 1);
            }
            if (world.func_147439_a(x - 1, y, z + 1) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x - 1, y - 1, z + 1);
            }
            if (world.func_147439_a(x - 1, y, z - 1) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x - 1, y - 1, z - 1);
            }
            if (world.func_147439_a(x + 1, y, z - 1) == Blocks.field_150350_a) {
                return this.locateStrongholdCorridor(world, x + 1, y - 1, z - 1);
            }
        }
        return null;
    }

    private boolean generateLibraryTrap(Random rand, World world, int tex, int vary, int tez, ForgeDirection orientation) {
        boolean ret = false;
        int r = rand.nextInt(2);
        Vec3[] vec = new Vec3[]{Vec3.func_72443_a((double)tex, (double)vary, (double)tez), Vec3.func_72443_a((double)orientation.offsetX, (double)orientation.offsetY, (double)orientation.offsetZ)};
        int ox = 0;
        int oz = 0;
        switch (r) {
            case 0: {
                ox = rand.nextInt(3) - 1;
                oz = rand.nextInt(3) - 1;
                vec[0].field_72450_a += (double)ox;
                vec[0].field_72449_c += (double)oz;
                ret = this.simpleTrap(rand, world, vec[0]);
                break;
            }
            case 1: {
                ret = this.coveredSpikedPit(rand, world, vec[0], Blocks.field_150347_e, 0);
                break;
            }
        }
        return ret;
    }

    private boolean generateStrongholdTrap(Random rand, World world, Vec3[] center) {
        boolean ret = false;
        if (center != null) {
            int x = MathHelper.func_76128_c((double)center[0].field_72450_a);
            int y = MathHelper.func_76128_c((double)center[0].field_72448_b);
            int z = MathHelper.func_76128_c((double)center[0].field_72449_c);
            if (MathHelper.func_76128_c((double)center[1].field_72450_a) == 0 || world.func_147439_a(x + MathHelper.func_76128_c((double)(center[1].field_72450_a * 2.0)), y + 1, z) != Blocks.field_150417_aV) {
                center[1].field_72450_a = MathHelper.func_76128_c((double)center[1].field_72450_a) != 0 && world.func_147439_a(x - MathHelper.func_76128_c((double)(center[1].field_72450_a * 2.0)), y + 1, z) == Blocks.field_150417_aV ? (center[1].field_72450_a *= -1.0) : 0.0;
            }
            if (MathHelper.func_76128_c((double)center[1].field_72449_c) == 0 || world.func_147439_a(x, y + 1, z + MathHelper.func_76128_c((double)(center[1].field_72449_c * 2.0))) != Blocks.field_150417_aV) {
                center[1].field_72449_c = MathHelper.func_76128_c((double)center[1].field_72449_c) != 0 && world.func_147439_a(x, y + 1, z - MathHelper.func_76128_c((double)(center[1].field_72449_c * 2.0))) == Blocks.field_150417_aV ? (center[1].field_72449_c *= -1.0) : 0.0;
            }
            int r = rand.nextInt(6);
            if (MathHelper.func_76128_c((double)center[1].field_72450_a) == 0 && MathHelper.func_76128_c((double)center[1].field_72449_c) == 0 && r > 4) {
                r = rand.nextInt(5);
            }
            switch (r) {
                case 0: 
                case 1: {
                    ret = this.simpleTrap(rand, world, center[0]);
                    break;
                }
                case 2: 
                case 3: {
                    ret = this.spikedPit(rand, world, center[0]);
                    break;
                }
                case 4: {
                    ret = this.coveredSpikedPit(rand, world, center[0], Blocks.field_150417_aV, -3);
                    break;
                }
                case 5: {
                    ret = this.trapChest(rand, world, center);
                }
            }
        }
        return ret;
    }

    private boolean trapChest(Random rand, World world, Vec3[] c) {
        boolean flag;
        Vec3 a = Vec3.func_72443_a((double)c[0].field_72450_a, (double)c[0].field_72448_b, (double)c[0].field_72449_c);
        boolean bl = flag = world.func_147439_a(MathHelper.func_76128_c((double)(a.field_72450_a + c[1].field_72449_c * 2.0)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c + c[1].field_72450_a * 2.0))) != Blocks.field_150350_a || world.func_147439_a(MathHelper.func_76128_c((double)(a.field_72450_a - c[1].field_72449_c * 2.0)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c - c[1].field_72450_a * 2.0))) != Blocks.field_150350_a;
        if (!flag) {
            if (MathHelper.func_76128_c((double)c[1].field_72450_a) != 0 && MathHelper.func_76128_c((double)c[1].field_72449_c) != 0) {
                if (rand.nextBoolean()) {
                    c[1].field_72450_a = 0.0;
                } else {
                    c[1].field_72449_c = 0.0;
                }
            }
            world.func_147465_d(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)a.field_72449_c), (Block)Blocks.field_150333_U, 5, 3);
            world.func_147465_d(MathHelper.func_76128_c((double)(a.field_72450_a + c[1].field_72449_c)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c + c[1].field_72450_a)), (Block)Blocks.field_150333_U, 5, 3);
            world.func_147465_d(MathHelper.func_76128_c((double)(a.field_72450_a - c[1].field_72449_c)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c - c[1].field_72450_a)), (Block)Blocks.field_150333_U, 5, 3);
            a.field_72450_a += c[1].field_72450_a;
            a.field_72449_c += c[1].field_72449_c;
            world.func_147449_b(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)a.field_72449_c), Blocks.field_150417_aV);
            world.func_147449_b(MathHelper.func_76128_c((double)(a.field_72450_a + c[1].field_72449_c)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c + c[1].field_72450_a)), Blocks.field_150417_aV);
            world.func_147449_b(MathHelper.func_76128_c((double)(a.field_72450_a - c[1].field_72449_c)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c - c[1].field_72450_a)), Blocks.field_150417_aV);
            world.func_147465_d(MathHelper.func_76128_c((double)(a.field_72450_a + c[1].field_72449_c * 2.0)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c + c[1].field_72450_a * 2.0)), (Block)Blocks.field_150333_U, 5, 3);
            world.func_147465_d(MathHelper.func_76128_c((double)(a.field_72450_a - c[1].field_72449_c * 2.0)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)(a.field_72449_c - c[1].field_72450_a * 2.0)), (Block)Blocks.field_150333_U, 5, 3);
            world.func_147449_b(MathHelper.func_76128_c((double)(a.field_72450_a + c[1].field_72449_c)), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)(a.field_72449_c + c[1].field_72450_a)), Blocks.field_150417_aV);
            world.func_147449_b(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)a.field_72449_c), Blocks.field_150447_bR);
            world.func_147449_b(MathHelper.func_76128_c((double)(a.field_72450_a - c[1].field_72449_c)), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)(a.field_72449_c - c[1].field_72450_a)), Blocks.field_150417_aV);
            if (MathHelper.func_76128_c((double)a.field_72450_a) == 1) {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)a.field_72449_c), 2, 3);
            } else if (MathHelper.func_76128_c((double)a.field_72450_a) == -1) {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)a.field_72449_c), 3, 3);
            } else if (MathHelper.func_76128_c((double)a.field_72449_c) == 1) {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)a.field_72449_c), 4, 3);
            } else {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)a.field_72449_c), 5, 3);
            }
            a.field_72450_a += c[1].field_72450_a;
            a.field_72449_c += c[1].field_72449_c;
            world.func_147449_b(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)a.field_72449_c), (Block)Blocks.field_150488_af);
            world.func_147449_b(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c), BlockIllusionary.instance);
            a.field_72450_a += c[1].field_72450_a;
            a.field_72449_c += c[1].field_72449_c;
            world.func_147465_d(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 1.0)), MathHelper.func_76128_c((double)a.field_72449_c), Blocks.field_150429_aA, 5, 3);
            world.func_147449_b(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c), BlockTrap.instance);
            if (MathHelper.func_76128_c((double)a.field_72450_a) == 1) {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c), 2, 3);
            } else if (MathHelper.func_76128_c((double)a.field_72450_a) == -1) {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c), 3, 3);
            } else if (MathHelper.func_76128_c((double)a.field_72449_c) == 1) {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c), 4, 3);
            } else {
                world.func_72921_c(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c), 5, 3);
            }
            TileEntityTrap dis = (TileEntityTrap)world.func_147438_o(MathHelper.func_76128_c((double)a.field_72450_a), MathHelper.func_76128_c((double)(a.field_72448_b + 2.0)), MathHelper.func_76128_c((double)a.field_72449_c));
            if (dis != null) {
                PlaceTraps.addTrapItem(rand, dis);
            } else {
                TileEntityDispenser dis2 = (TileEntityDispenser)world.func_147438_o(MathHelper.func_76128_c((double)(a.field_72450_a + 2.0)), MathHelper.func_76128_c((double)a.field_72448_b), MathHelper.func_76128_c((double)a.field_72449_c));
                if (dis2 != null) {
                    PlaceTraps.addTrapItem(rand, dis);
                }
            }
            return true;
        }
        return false;
    }

    private boolean spikedPit(Random rand, World world, Vec3 c) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j > -2 && j < 2) {
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), Blocks.field_150350_a, 0, 3);
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 1.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), BlockSpikes.instance, 0, 3);
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 2.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), Blocks.field_150417_aV, rand.nextInt(3), 3);
                    continue;
                }
                if (!world.func_147439_a(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 1.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j))).func_149662_c()) continue;
                world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 1.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), Blocks.field_150417_aV, rand.nextInt(3), 3);
            }
        }
        return true;
    }

    private boolean coveredSpikedPit(Random rand, World world, Vec3 c, Block blockID, int meta) {
        if (meta < 0) {
            meta = rand.nextInt(-1 * meta);
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j > -2 && j < 2) {
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), BlockIllusionary.instance, 0, 3);
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 1.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), Blocks.field_150350_a, 0, 3);
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 2.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), Blocks.field_150350_a, 0, 3);
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 3.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), BlockSpikes.instance, 0, 3);
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 4.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), blockID, meta, 3);
                    continue;
                }
                if (world.func_147439_a(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 1.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j))).func_149662_c()) {
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 1.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), blockID, meta, 3);
                }
                if (world.func_147439_a(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 2.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j))).func_149662_c()) {
                    world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 2.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), blockID, meta, 3);
                }
                if (!world.func_147439_a(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 3.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j))).func_149662_c()) continue;
                world.func_147465_d(MathHelper.func_76128_c((double)(c.field_72450_a + (double)i)), MathHelper.func_76128_c((double)(c.field_72448_b - 3.0)), MathHelper.func_76128_c((double)(c.field_72449_c + (double)j)), blockID, meta, 3);
            }
        }
        return true;
    }

    private boolean simpleTrap(Random rand, World world, Vec3 c) {
        boolean nn = false;
        if (world.func_147437_c(MathHelper.func_76128_c((double)c.field_72450_a), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)c.field_72449_c))) {
            c.field_72448_b -= 1.0;
            nn = true;
        }
        world.func_147465_d(MathHelper.func_76128_c((double)c.field_72450_a), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)c.field_72449_c), BlockTrap.instance, 1, 3);
        world.func_72921_c(MathHelper.func_76128_c((double)c.field_72450_a), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)c.field_72449_c), 1, 3);
        world.func_147449_b(MathHelper.func_76128_c((double)c.field_72450_a), MathHelper.func_76128_c((double)(c.field_72448_b + 1.0)), MathHelper.func_76128_c((double)c.field_72449_c), rand.nextInt(5) == 0 ? BlockArtifactsPressurePlate.camoObsidian : BlockArtifactsPressurePlate.invisObsidian);
        TileEntityTrap dis = (TileEntityTrap)world.func_147438_o(MathHelper.func_76128_c((double)c.field_72450_a), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)c.field_72449_c));
        if (dis != null) {
            PlaceTraps.addTrapItem(rand, dis);
        } else {
            TileEntityDispenser dis2 = (TileEntityDispenser)world.func_147438_o(MathHelper.func_76128_c((double)c.field_72450_a), MathHelper.func_76128_c((double)c.field_72448_b), MathHelper.func_76128_c((double)c.field_72449_c));
            if (dis2 != null) {
                PlaceTraps.addTrapItem(rand, dis);
            }
        }
        if (nn) {
            c.field_72448_b += 1.0;
        }
        return true;
    }

    public static void addTrapItem(Random rand, TileEntityTrap dis) {
        PlaceTraps.addTrapItem(rand, dis, 0);
    }

    public static void addTrapItem(Random rand, TileEntityTrap dis, int min) {
        int max = 9;
        if (dis.field_145847_g > 1) {
            max += 7;
            if (!(dis instanceof TileEntityTrap)) {
                --max;
            }
        }
        int r = rand.nextInt(max - min) + min;
        switch (r) {
            case 0: 
            case 1: {
                int s;
                ItemStack egg = new ItemStack(Items.field_151063_bx, 8);
                int e = rand.nextInt(5);
                switch (e) {
                    case 0: {
                        s = 50;
                        break;
                    }
                    case 1: {
                        s = 51;
                        break;
                    }
                    case 2: {
                        s = 54;
                        break;
                    }
                    case 3: {
                        s = 59;
                        break;
                    }
                    default: {
                        s = 60;
                    }
                }
                egg.func_77964_b(s);
                dis.func_146019_a(egg);
                break;
            }
            case 2: 
            case 3: {
                dis.func_146019_a(new ItemStack(Items.field_151033_d));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                dis.func_146019_a(new ItemStack(Items.field_151032_g, rand.nextInt(20)));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                dis.func_146019_a(new ItemStack(Items.field_151059_bz, 4));
                break;
            }
            case 14: 
            case 15: {
                dis.func_146019_a(new ItemStack(Items.field_151040_l, 1, 245));
            }
        }
    }

    private boolean forwardTrap(Random rand, World world, Vec3[] c) {
        Vec3 pos = Vec3.func_72443_a((double)c[0].field_72450_a, (double)c[0].field_72448_b, (double)c[0].field_72449_c);
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)pos.field_72448_b), MathHelper.func_76128_c((double)(pos.field_72449_c + 1.0)), BlockTrap.instance, 0, 3);
        int m = 0;
        m = c[1].field_72450_a == 0.0 ? (c[1].field_72449_c == 1.0 ? 3 : 2) : (c[1].field_72450_a == 1.0 ? 5 : 4);
        world.func_72921_c(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b + 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c), m, 3);
        TileEntityTrap dis = (TileEntityTrap)world.func_147438_o(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b + 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c));
        if (dis != null) {
            PlaceTraps.addTrapItem(rand, dis);
        } else {
            TileEntityDispenser dis2 = (TileEntityDispenser)world.func_147438_o(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b + 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c));
            if (dis2 != null) {
                PlaceTraps.addTrapItem(rand, dis);
            }
        }
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)pos.field_72448_b), MathHelper.func_76128_c((double)pos.field_72449_c), Blocks.field_150437_az, 5, 3);
        pos.field_72450_a += c[1].field_72450_a;
        pos.field_72449_c += c[1].field_72449_c;
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b - 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c), (Block)Blocks.field_150488_af, 15, 3);
        pos.field_72450_a += c[1].field_72450_a;
        pos.field_72449_c += c[1].field_72449_c;
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b - 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c), Blocks.field_150350_a, 0, 3);
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b - 2.0)), MathHelper.func_76128_c((double)pos.field_72449_c), (Block)Blocks.field_150488_af, 14, 3);
        pos.field_72450_a += c[1].field_72450_a;
        pos.field_72449_c += c[1].field_72449_c;
        m = 0;
        m = c[1].field_72450_a == 0.0 ? (c[1].field_72449_c == 1.0 ? 3 : 4) : (c[1].field_72450_a == 1.0 ? 1 : 2);
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b - 2.0)), MathHelper.func_76128_c((double)pos.field_72449_c), Blocks.field_150429_aA, m, 3);
        pos.field_72450_a += c[1].field_72450_a;
        pos.field_72449_c += c[1].field_72449_c;
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b - 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c), (Block)Blocks.field_150488_af, 0, 3);
        world.func_147465_d(MathHelper.func_76128_c((double)pos.field_72450_a), MathHelper.func_76128_c((double)(pos.field_72448_b + 1.0)), MathHelper.func_76128_c((double)pos.field_72449_c), BlockArtifactsPressurePlate.invisObsidian, 0, 3);
        return true;
    }

    private boolean sideTrapA(World world, Vec3[] c) {
        Vec3 pos = Vec3.func_72443_a((double)c[0].field_72450_a, (double)c[0].field_72448_b, (double)c[0].field_72449_c);
        pos.field_72450_a += c[1].field_72450_a * 3.0;
        pos.field_72449_c += c[1].field_72449_c * 3.0;
        return false;
    }

    private boolean sideTrapB(World world, Vec3[] c) {
        Vec3 pos = Vec3.func_72443_a((double)c[0].field_72450_a, (double)c[0].field_72448_b, (double)c[0].field_72449_c);
        pos.field_72450_a += c[1].field_72450_a * 4.0;
        pos.field_72449_c += c[1].field_72449_c * 4.0;
        return false;
    }

    static {
        weightTower1 = 5;
        weightTower1A = 5;
        weightTower2 = 4;
        weightTower2A = 4;
        weightTower3 = 3;
        weightTower3A = 3;
        quicksandRarity = 2;
        towerRarity = 3;
        towerRarityMod = 29;
    }
}

