/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.components;

import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.block.BlockLight;
import com.draco18s.artifacts.block.BlockSolidAir;
import com.draco18s.artifacts.components.BaseComponent;
import com.draco18s.artifacts.components.UtilsForComponents;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ComponentLight
extends BaseComponent {
    @Override
    public String getRandomTrigger(Random rand, boolean isArmor) {
        if (isArmor) {
            return "onArmorTickUpdate";
        }
        return "onUpdate";
    }

    @Override
    public ItemStack attached(ItemStack i, Random rand, int[] eff) {
        i.field_77990_d.func_74768_a("lastLightX", -1);
        i.field_77990_d.func_74768_a("lastLightY", -1);
        i.field_77990_d.func_74768_a("lastLightZ", -1);
        return i;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (DragonArtifacts.baublesLoaded && stack.field_77990_d != null && UtilsForComponents.equipableByBaubles(stack.field_77990_d.func_74779_i("iconName")) && DragonArtifacts.baublesMustBeEquipped && slot >= 0) {
            return;
        }
        if (slot >= 0 && stack.field_77990_d != null && UtilsForComponents.isArmor(stack.field_77990_d.func_74779_i("iconName"))) {
            return;
        }
        if (!world.field_72995_K) {
            int lx = stack.field_77990_d.func_74762_e("lastLightX");
            int ly = stack.field_77990_d.func_74762_e("lastLightY");
            int lz = stack.field_77990_d.func_74762_e("lastLightZ");
            if (entity instanceof EntityPlayer) {
                int nlx = MathHelper.func_76128_c((double)entity.field_70165_t);
                int nly = MathHelper.func_76128_c((double)entity.field_70163_u);
                int nlz = MathHelper.func_76128_c((double)entity.field_70161_v);
                boolean setLightBlock = false;
                if (nlx != lx || nly != ly || nlz != lz) {
                    int d = (nlx - lx) * (nlx - lx) + (nly - ly) * (nly - ly) + (nlz - lz) * (nlz - lz);
                    if (world.func_72957_l(nlx, nly, nlz) < 10) {
                        if (d > 13) {
                            if (ly >= 0 && ly < 256 && world.func_147439_a(lx, ly, lz) == BlockLight.instance) {
                                world.func_147468_f(lx, ly, lz);
                            }
                            setLightBlock = true;
                        } else if (world.func_147439_a(lx, ly, lz) != BlockLight.instance) {
                            if (world.func_147437_c(lx, ly, lz) && world.func_147439_a(lx, ly, lz) != BlockSolidAir.instance) {
                                world.func_147449_b(lx, ly, lz, BlockLight.instance);
                            } else {
                                setLightBlock = true;
                            }
                        }
                    }
                    if (setLightBlock && nly >= 0 && nly < 256 && world.func_147437_c(nlx, nly, nlz) && world.func_147439_a(nlx, nly, nlz) != BlockSolidAir.instance) {
                        world.func_147449_b(nlx, nly, nlz, BlockLight.instance);
                        stack.field_77990_d.func_74768_a("lastLightX", nlx);
                        stack.field_77990_d.func_74768_a("lastLightY", nly);
                        stack.field_77990_d.func_74768_a("lastLightZ", nlz);
                    }
                }
            }
        }
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, String trigger, boolean advTooltip) {
        par3List.add(StatCollector.func_74838_a((String)"effect.Provides illumination"));
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean advTooltip) {
        par3List.add(StatCollector.func_74838_a((String)"effect.Provides illumination"));
    }

    @Override
    public String getPreAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "Illuminating";
                break;
            }
            case 1: {
                str = "Bright";
            }
        }
        return str;
    }

    @Override
    public String getPostAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "of Light";
                break;
            }
            case 1: {
                str = "of the Sun";
            }
        }
        return str;
    }

    @Override
    public int getTextureBitflags() {
        return 2525;
    }

    @Override
    public int getNegTextureBitflags() {
        return 5632;
    }

    @Override
    public boolean onEntityItemUpdate(EntityItem entityItem, String type) {
        if (type == "onUpdate") {
            int d;
            World world = entityItem.field_70170_p;
            NBTTagCompound data = entityItem.func_92059_d().field_77990_d;
            int lx = data.func_74762_e("lastLightX");
            int ly = data.func_74762_e("lastLightY");
            int lz = data.func_74762_e("lastLightZ");
            int nlx = (int)entityItem.field_70165_t;
            int nly = (int)entityItem.field_70163_u;
            int nlz = (int)entityItem.field_70161_v;
            if ((nlx != lx || nly != ly || nlz != lz) && (d = (nlx - lx) * (nlx - lx) + (nly - ly) * (nly - ly) + (nlz - lz) * (nlz - lz)) > 13) {
                if (ly >= 0 && ly < 256 && world.func_147439_a(nlx, nly, nlz) == BlockLight.instance) {
                    world.func_147468_f(lx, ly, lz);
                }
                if (nly >= 0 && nly < 256 && world.func_147437_c(nlx, nly, nlz)) {
                    world.func_147449_b(nlx, nly, nlz, BlockLight.instance);
                    data.func_74768_a("lastLightX", nlx);
                    data.func_74768_a("lastLightY", nly);
                    data.func_74768_a("lastLightZ", nlz);
                }
            }
        } else {
            System.out.println("Hmm. " + type);
        }
        return false;
    }

    @Override
    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack, boolean worn) {
        this.onUpdate(itemStack, world, (Entity)player, worn ? -1 : 0, false);
    }
}

