/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.components;

import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.components.BaseComponent;
import com.draco18s.artifacts.components.UtilsForComponents;
import com.draco18s.artifacts.network.CToSMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ComponentHeal
extends BaseComponent {
    @Override
    public String getRandomTrigger(Random rand, boolean isArmor) {
        if (isArmor) {
            return "onArmorTickUpdate";
        }
        String str = "";
        switch (rand.nextInt(4)) {
            case 0: {
                str = "onUpdate";
                break;
            }
            case 1: {
                str = "hitEntity";
                break;
            }
            case 2: {
                str = "onItemRightClick";
                break;
            }
            case 3: {
                str = "onHeld";
            }
        }
        return str;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        PacketBuffer out = new PacketBuffer(Unpooled.buffer());
        out.writeInt(1);
        out.writeFloat(1.0f);
        CToSMessage packet = new CToSMessage((ByteBuf)out);
        DragonArtifacts.artifactNetworkWrapper.sendToServer((IMessage)packet);
        UtilsForComponents.sendItemDamagePacket(player, player.field_71071_by.field_70461_c, 1);
        itemStack.field_77990_d.func_74768_a("onItemRightClickDelay", 20);
        return itemStack;
    }

    @Override
    public boolean hitEntity(ItemStack itemStack, EntityLivingBase entityLivingHit, EntityLivingBase entityLivingPlayer) {
        if (!entityLivingPlayer.field_70170_p.field_72995_K && entityLivingPlayer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingPlayer;
            player.func_70691_i(1.0f);
        }
        return false;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (DragonArtifacts.baublesLoaded && stack.field_77990_d != null && UtilsForComponents.equipableByBaubles(stack.field_77990_d.func_74779_i("iconName")) && DragonArtifacts.baublesMustBeEquipped && slot >= 0) {
            return;
        }
        if (entity instanceof EntityLivingBase && !world.field_72995_K && world.field_73012_v.nextInt(300) == 0) {
            EntityLivingBase elb = (EntityLivingBase)entity;
            elb.func_70606_j(elb.func_110143_aJ() + 1.0f);
        }
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, String trigger, boolean advTooltip) {
        par3List.add(StatCollector.func_74838_a((String)"effect.Heals the Player") + " " + StatCollector.func_74838_a((String)("tool." + trigger)));
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean advTooltip) {
        par3List.add(StatCollector.func_74838_a((String)"effect.Heals the Player"));
    }

    @Override
    public String getPreAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "Healing";
                break;
            }
            case 1: {
                str = "Rejuvenating";
                break;
            }
            case 2: {
                str = "Holy";
            }
        }
        return str;
    }

    @Override
    public String getPostAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "of Healing";
                break;
            }
            case 1: {
                str = "of Rejuvenation";
            }
        }
        return str;
    }

    @Override
    public int getTextureBitflags() {
        return 16383;
    }

    @Override
    public int getNegTextureBitflags() {
        return 0;
    }

    @Override
    public void onHeld(ItemStack itemStack, World world, Entity entity, int slot, boolean held) {
        if (entity instanceof EntityLivingBase && !world.field_72995_K && world.field_73012_v.nextInt(100) == 0) {
            EntityLivingBase elb = (EntityLivingBase)entity;
            elb.func_70606_j(elb.func_110143_aJ() + 1.0f);
        }
    }

    @Override
    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack, boolean worn) {
        if (worn) {
            this.onUpdate(itemStack, world, (Entity)player, 0, true);
        }
    }
}

