/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.components;

import com.draco18s.artifacts.components.BaseComponent;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ComponentExcavation
extends BaseComponent {
    @Override
    public String getRandomTrigger(Random rand, boolean isArmor) {
        if (isArmor) {
            return "";
        }
        return "onBlockDestroyed";
    }

    @Override
    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        Item.ToolMaterial toolMaterial = Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")];
        if (toolMaterial == Item.ToolMaterial.WOOD) {
            return Math.max(Items.field_151039_o.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f, Items.field_151038_n.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f);
        }
        if (toolMaterial == Item.ToolMaterial.STONE) {
            return Math.max(Items.field_151050_s.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f, Items.field_151051_r.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f);
        }
        if (toolMaterial == Item.ToolMaterial.EMERALD) {
            return Math.max(Items.field_151046_w.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f, Items.field_151047_v.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f);
        }
        if (toolMaterial == Item.ToolMaterial.IRON) {
            return Math.max(Items.field_151035_b.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f, Items.field_151037_a.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f);
        }
        if (toolMaterial == Item.ToolMaterial.GOLD) {
            return Math.max(Items.field_151005_D.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f, Items.field_151011_C.getDigSpeed(itemStack, block, meta) / 2.0f * Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f);
        }
        return Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")].func_77998_b() / 10.0f;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemStack, World world, Block destroyedBlock, int x, int y, int z, EntityLivingBase player) {
        int numBlocks = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Block block = world.func_147439_a(x + i, y + j, z + k);
                    if (block == null) continue;
                    System.out.println("block: " + block.func_149739_a());
                    System.out.println("can:  " + itemStack.func_77973_b().canHarvestBlock(block, itemStack));
                    if (!this.canHarvestBlock(block, itemStack)) continue;
                    int fortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemStack);
                    block.func_149697_b(world, x, y, z, world.func_72805_g(x + i, y + j, z + k), fortuneLevel);
                    world.func_147468_f(x + i, y + j, z + k);
                    ++numBlocks;
                }
            }
        }
        itemStack.func_77972_a(numBlocks / 3, player);
        return false;
    }

    @Override
    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        Item.ToolMaterial toolMaterial = Item.ToolMaterial.values()[itemStack.field_77990_d.func_74762_e("material")];
        try {
            if (block.func_149712_f(null, 0, 0, 0) == -1.0f) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        if (toolMaterial == Item.ToolMaterial.WOOD) {
            return Items.field_151039_o.func_150897_b(block) || Items.field_151038_n.func_150897_b(block);
        }
        if (toolMaterial == Item.ToolMaterial.STONE) {
            return Items.field_151050_s.func_150897_b(block) || Items.field_151051_r.func_150897_b(block);
        }
        if (toolMaterial == Item.ToolMaterial.EMERALD) {
            return Items.field_151046_w.func_150897_b(block) || Items.field_151047_v.func_150897_b(block);
        }
        if (toolMaterial == Item.ToolMaterial.IRON) {
            return Items.field_151035_b.func_150897_b(block) || Items.field_151037_a.func_150897_b(block);
        }
        if (toolMaterial == Item.ToolMaterial.GOLD) {
            return Items.field_151005_D.func_150897_b(block) || Items.field_151011_C.func_150897_b(block);
        }
        return toolMaterial.func_77996_d() >= block.getHarvestLevel(0);
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, String trigger, boolean advTooltip) {
        par3List.add(StatCollector.func_74838_a((String)"effect.Digs big holes"));
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean advTooltip) {
        par3List.add(StatCollector.func_74838_a((String)"effect.Digs big holes"));
    }

    @Override
    public String getPreAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "Excavator's";
                break;
            }
            case 1: {
                str = "Digger's";
            }
        }
        return str;
    }

    @Override
    public String getPostAdj(Random rand) {
        return "of Excavation";
    }

    @Override
    public int getTextureBitflags() {
        return 156;
    }

    @Override
    public int getNegTextureBitflags() {
        return 8481;
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        Item.ToolMaterial toolMaterial = Item.ToolMaterial.values()[stack.field_77990_d.func_74762_e("material")];
        if (toolClass.equals("pickaxe") || toolClass.equals("shovel")) {
            return toolMaterial.func_77996_d();
        }
        return -1;
    }
}

