/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.components;

import com.draco18s.artifacts.components.BaseComponent;
import com.draco18s.artifacts.components.UtilsForComponents;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ComponentBreathing
extends BaseComponent {
    @Override
    public String getRandomTrigger(Random rand, boolean isArmor) {
        if (isArmor) {
            switch (rand.nextInt(2)) {
                case 0: {
                    return "onArmorTickUpdate";
                }
                case 1: {
                    return "onTakeDamage";
                }
            }
            return "";
        }
        String str = "";
        switch (rand.nextInt(5)) {
            case 0: 
            case 1: {
                str = "onItemRightClick";
                break;
            }
            case 2: 
            case 3: {
                str = "hitEntity";
                break;
            }
            case 4: {
                str = "onHeld";
            }
        }
        return str;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        UtilsForComponents.sendPotionPacket(13, 1200, 0, (Entity)player);
        UtilsForComponents.sendItemDamagePacket(player, player.field_71071_by.field_70461_c, 1);
        itemStack.field_77990_d.func_74768_a("onItemRightClickDelay", 200);
        return itemStack;
    }

    @Override
    public boolean hitEntity(ItemStack itemStack, EntityLivingBase entityLivingHit, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_70690_d(new PotionEffect(13, 1200, 0));
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, String trigger, boolean advTooltip) {
        int time = 0;
        if (trigger.equals("when inflicting damage.")) {
            time = 15;
        } else if (trigger.equals("when used.")) {
            time = 60;
        } else if (trigger.equals("after taking damage.")) {
            trigger = "after taking drowning damage.";
            time = 2;
        }
        par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"effect.Water Breathing"));
        par3List.add("  " + EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)("tool." + trigger)) + " (" + time + StatCollector.func_74838_a((String)"time.seconds") + ")");
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean advTooltip) {
        par3List.add(EnumChatFormatting.AQUA + "Water Breathing");
    }

    @Override
    public String getPreAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(3)) {
            case 0: {
                str = "Aerated";
                break;
            }
            case 1: {
                str = "Breathy";
                break;
            }
            case 2: {
                str = "Oxygenated";
            }
        }
        return str;
    }

    @Override
    public String getPostAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "of Breathing";
                break;
            }
            case 1: {
                str = "of Fresh Air";
            }
        }
        return str;
    }

    @Override
    public int getTextureBitflags() {
        return 2397;
    }

    @Override
    public int getNegTextureBitflags() {
        return 4738;
    }

    @Override
    public void onHeld(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)entity;
            ent.func_70690_d(new PotionEffect(13, 10, 0));
        }
    }

    @Override
    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack, boolean worn) {
        if (worn) {
            this.onHeld(itemStack, world, (Entity)player, 0, true);
        }
    }

    @Override
    public void onTakeDamage(ItemStack itemStack, LivingHurtEvent event, boolean isWornArmor) {
        if (isWornArmor && event.source == DamageSource.field_76369_e) {
            event.entityLiving.func_70690_d(new PotionEffect(13, 40, 0));
        }
    }
}

