/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.block;

import com.draco18s.artifacts.BlockSourceImpl;
import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.api.interfaces.IBehaviorTrapItem;
import com.draco18s.artifacts.api.internals.IBlockSource;
import com.draco18s.artifacts.arrowtrapbehaviors.BehaviorDefaultDispenseItem;
import com.draco18s.artifacts.arrowtrapbehaviors.IRegistry;
import com.draco18s.artifacts.arrowtrapbehaviors.PositionImpl;
import com.draco18s.artifacts.arrowtrapbehaviors.RegistryDefaulted;
import com.draco18s.artifacts.block.BlockArtifactsPressurePlate;
import com.draco18s.artifacts.block.BlockWallPlate;
import com.draco18s.artifacts.entity.EntitySpecialArrow;
import com.draco18s.artifacts.entity.TileEntityTrap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTrap
extends BlockContainer {
    public static Block instance;
    private static IBehaviorTrapItem defaultBehavior;
    public static final IRegistry dispenseBehaviorRegistry;
    protected Random random = new Random();
    @SideOnly(value=Side.CLIENT)
    protected IIcon furnaceTopIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon furnaceFrontIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon verticalFront;
    public int renderType = 0;

    public BlockTrap() {
        super(Material.field_151576_e);
        this.func_149647_a(DragonArtifacts.tabGeneral);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149711_c(2.0f);
    }

    public int func_149738_a(World par1World) {
        return 4;
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        this.setDispenserDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDispenserDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K) {
            Block block = par1World.func_147439_a(par2, par3, par4 - 1);
            Block block1 = par1World.func_147439_a(par2, par3, par4 + 1);
            Block block2 = par1World.func_147439_a(par2 - 1, par3, par4);
            Block block3 = par1World.func_147439_a(par2 + 1, par3, par4);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            par1World.func_72921_c(par2, par3, par4, b0, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        if (par2 <= 1) {
            return this.verticalFront;
        }
        return this.field_149761_L;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int k;
        int m = world.func_72805_g(x, y, z) & 7;
        if (m == (k = side & 7)) {
            return this.neighborBlockTexture(world, x, y, z, side, m);
        }
        return this.func_149691_a(m, side);
    }

    public IIcon neighborBlockTexture(IBlockAccess world, int x, int y, int z, int side, int mymeta) {
        Block[] blocks = new Block[]{world.func_147439_a(x, y, z + 1), world.func_147439_a(x, y, z - 1), world.func_147439_a(x + 1, y, z), world.func_147439_a(x - 1, y, z)};
        int[] meta = new int[]{world.func_72805_g(x, y, z + 1), world.func_72805_g(x, y, z - 1), world.func_72805_g(x + 1, y, z), world.func_72805_g(x - 1, y, z)};
        for (int i = 0; i < blocks.length; ++i) {
            IIcon icon;
            if (i + 2 == mymeta || blocks[i] == null || blocks[i] == this || blocks[i] instanceof BlockWallPlate || blocks[i] instanceof BlockArtifactsPressurePlate || (icon = blocks[i].func_149691_a(side, meta[i])) == null) continue;
            return icon;
        }
        return Blocks.field_150417_aV.func_149733_h(1);
    }

    public static int[] getNeighbourBlockPosition(IBlockAccess world, int x, int y, int z, Block block, int blockMeta) {
        int xOffset = 0;
        int zOffset = 0;
        switch (blockMeta) {
            case 0: 
            case 2: 
            case 3: {
                xOffset = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                zOffset = 1;
            }
        }
        boolean metaToCopy = false;
        Block adjacentBlock1 = world.func_147439_a(x + xOffset, y, z + zOffset);
        Block adjacentBlock2 = world.func_147439_a(x - xOffset, y, z - zOffset);
        Block blockToCopy = Blocks.field_150417_aV;
        if (adjacentBlock1 != block && adjacentBlock1 != null && adjacentBlock1.func_149662_c()) {
            return new int[]{x + xOffset, y, z + zOffset};
        }
        if (adjacentBlock2 != block && adjacentBlock2 != null && adjacentBlock2.func_149662_c()) {
            return new int[]{x - xOffset, y, z - zOffset};
        }
        if (blockMeta <= 1) {
            adjacentBlock1 = world.func_147439_a(x + zOffset, y, z + xOffset);
            adjacentBlock2 = world.func_147439_a(x - zOffset, y, z - xOffset);
            if (adjacentBlock1 != block && adjacentBlock1 != null && adjacentBlock1.func_149662_c()) {
                return new int[]{x + zOffset, y, z + xOffset};
            }
            if (adjacentBlock2 != block && adjacentBlock2 != null && adjacentBlock2.func_149662_c()) {
                return new int[]{x - zOffset, y, z - xOffset};
            }
        } else {
            adjacentBlock1 = world.func_147439_a(x, y + 1, z);
            adjacentBlock2 = world.func_147439_a(x, y - 1, z);
            if (adjacentBlock1 != block && adjacentBlock1 != null && adjacentBlock1.func_149662_c()) {
                return new int[]{x, y + 1, z};
            }
            if (adjacentBlock2 != block && adjacentBlock2 != null && adjacentBlock2.func_149662_c()) {
                return new int[]{x, y - 1, z};
            }
        }
        return new int[]{x, y, z};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("artifacts:arrow_trap_front");
        this.verticalFront = par1IconRegister.func_94245_a("artifacts:arrow_trap_front_vertical");
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)par1World.func_147438_o(par2, par3, par4);
        if (tileentitydispenser != null) {
            par5EntityPlayer.func_146102_a(tileentitydispenser);
        }
        return true;
    }

    protected void dispense(World par1World, int par2, int par3, int par4, int i) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(par1World, par2, par3, par4, i);
        TileEntityTrap tileentitydispenser = (TileEntityTrap)blocksourceimpl.getBlockTileEntity();
        if (tileentitydispenser != null) {
            int l = -1;
            int c = 0;
            do {
                if ((l = tileentitydispenser.func_146017_i()) <= 0 || this.getBehaviorForItemStack(tileentitydispenser.func_70301_a(l)) != defaultBehavior) continue;
                l = -5;
                ++c;
            } while (l < -2 && c < 20);
            if (l < 0) {
                par1World.func_72926_e(1001, par2, par3, par4, 0);
            } else {
                ItemStack itemstack = tileentitydispenser.func_70301_a(l);
                IBehaviorTrapItem ibehaviordispenseitem = this.getBehaviorForItemStack(itemstack);
                if (ibehaviordispenseitem != IBehaviorTrapItem.itemDispenseBehaviorProvider) {
                    ItemStack itemstack1 = ibehaviordispenseitem.dispense(blocksourceimpl, itemstack);
                    tileentitydispenser.func_70299_a(l, itemstack1.field_77994_a <= 0 ? null : itemstack1);
                }
            }
        }
    }

    protected IBehaviorTrapItem getBehaviorForItemStack(ItemStack par1ItemStack) {
        return (IBehaviorTrapItem)dispenseBehaviorRegistry.func_82594_a(par1ItemStack.func_77973_b());
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block block) {
        boolean flag1;
        boolean flag = par1World.func_72864_z(par2, par3, par4) || par1World.func_72864_z(par2, par3 + 1, par4);
        int i1 = par1World.func_72805_g(par2, par3, par4);
        boolean bl = flag1 = (i1 & 8) != 0;
        if (flag && !flag1) {
            par1World.func_147464_a(par2, par3, par4, instance, this.func_149738_a(par1World));
            par1World.func_72921_c(par2, par3, par4, i1 | 8, 4);
        } else if (!flag && flag1) {
            par1World.func_72921_c(par2, par3, par4, i1 & 0xFFFFFFF7, 4);
        } else if (flag1) {
            // empty if block
        }
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        TileEntity te;
        if (!par1World.field_72995_K && (te = par1World.func_147438_o(par2, par3, par4)) instanceof TileEntityDispenser) {
            TileEntityDispenser dis = (TileEntityDispenser)te;
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)par2 - 0.2), (double)((double)par3 - 0.2), (double)((double)par4 - 0.2), (double)((double)par2 + 1.2), (double)((double)par3 + 1.2), (double)((double)par4 + 1.2));
            List arrs = par1World.func_72872_a(EntitySpecialArrow.class, aabb);
            block0: for (int a = arrs.size() - 1; a >= 0; --a) {
                EntityArrow arr = (EntityArrow)arrs.get(a);
                for (int s = 0; s < 9; ++s) {
                    ItemStack is = dis.func_70301_a(s);
                    if (is == null) {
                        dis.func_70299_a(s, new ItemStack(Items.field_151032_g, 1));
                        arr.func_70106_y();
                        continue block0;
                    }
                    if (is == null || is.func_77973_b() != Items.field_151032_g || is.field_77994_a >= 64) continue;
                    ++is.field_77994_a;
                    arr.func_70106_y();
                    continue block0;
                }
            }
            this.dispense(par1World, par2, par3, par4, par5Random.nextInt(4) + 1);
            this.dispense(par1World, par2, par3, par4, par5Random.nextInt(4) + 1);
        }
    }

    public TileEntity func_149915_a(World par1World, int meta) {
        return new TileEntityTrap();
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int l = BlockPistonBase.func_150071_a((World)par1World, (int)par2, (int)par3, (int)par4, (EntityLivingBase)par5EntityLiving);
        par1World.func_72921_c(par2, par3, par4, l, 2);
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityDispenser)par1World.func_147438_o(par2, par3, par4)).func_146018_a(par6ItemStack.func_82833_r());
        }
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block block, int par6) {
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)par1World.func_147438_o(par2, par3, par4);
        if (!par1World.field_72995_K && tileentitydispenser != null) {
            for (int j1 = 0; j1 < tileentitydispenser.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileentitydispenser.func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_147453_f(par2, par3, par4, block);
        }
        super.func_149749_a(par1World, par2, par3, par4, block, par6);
    }

    public static IPosition getIPositionFromBlockSource(IBlockSource par0IBlockSource) {
        EnumFacing enumfacing = BlockTrap.getFacing(par0IBlockSource.getBlockMetadata());
        double d0 = par0IBlockSource.func_82615_a() + 0.7 * (double)enumfacing.func_82601_c();
        double d1 = par0IBlockSource.func_82617_b() + 0.7 * (double)enumfacing.func_96559_d();
        double d2 = par0IBlockSource.func_82616_c() + 0.7 * (double)enumfacing.func_82599_e();
        return new PositionImpl(d0, d1, d2);
    }

    public static EnumFacing getFacing(int par0) {
        return EnumFacing.func_82600_a((int)(par0 & 7));
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int par2, int par3, int par4, int par5) {
        return Container.func_94526_b((IInventory)((IInventory)par1World.func_147438_o(par2, par3, par4)));
    }

    public boolean func_149678_a(int meta, boolean clickedWithBoat) {
        return true;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    static {
        defaultBehavior = new BehaviorDefaultDispenseItem();
        dispenseBehaviorRegistry = new RegistryDefaulted(defaultBehavior);
    }
}

