/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.block;

import com.draco18s.artifacts.DamageSourceQuicksand;
import com.draco18s.artifacts.DragonArtifacts;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuickSand
extends Block {
    public static Block instance;
    public int renderType = 0;
    private static final boolean debug = false;
    private int flowDelay = 15;

    public BlockQuickSand() {
        super(Material.field_151595_p);
        this.func_149647_a(DragonArtifacts.tabGeneral);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149776_m);
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
    }

    public boolean isToolEffective(String type, int metadata) {
        if (type.equals("shovel")) {
            return true;
        }
        return super.isToolEffective(type, metadata);
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.tryFlowing(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, instance, this.flowDelay);
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockChanged) {
        world.func_147464_a(x, y, z, instance, this.flowDelay);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F - (double)(meta / 16)), (double)((double)z + this.field_149757_G));
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0f + (float)((double)BlockQuickSand.getQuicksandLevel(world, x, y, z) * 0.0625), 1.0f);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("artifacts:pourable_quicksand");
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        if (meta == 0 || rand.nextInt(16 - meta) > 6 - (fortune > 4 ? 4 : fortune)) {
            return Item.func_150898_a((Block)this);
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase && BlockQuickSand.headInQuicksand(world, x, y, z, entity)) {
            entity.func_70097_a(DamageSourceQuicksand.instance, 0.5f);
        }
        if (this.insideQuicksand(world, x, y, z, entity)) {
            if (entity instanceof EntityPlayer) {
                double horizMotion = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y);
                if (horizMotion > 0.0) {
                    // empty if block
                }
                entity.field_70181_x = entity.func_70093_af() ? 0.085102044 : 0.074897955;
                if (horizMotion > 0.001) {
                    entity.field_70181_x -= horizMotion * 0.3;
                }
                entity.field_70143_R = 0.0f;
            } else {
                entity.func_70110_aj();
            }
        }
    }

    private boolean insideQuicksand(World world, int x, int y, int z, Entity entity) {
        if (world.func_147439_a(x, y, z) != instance) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            return entity.field_70163_u < (double)y + (double)entity.field_70131_O + BlockQuickSand.getQuicksandBlockLevel((IBlockAccess)world, x, y, z);
        }
        return entity.field_70163_u < (double)y + BlockQuickSand.getQuicksandBlockLevel((IBlockAccess)world, x, y, z);
    }

    public static boolean headInQuicksand(World world, int x, int y, int z, Entity entity) {
        int headY;
        x = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (world.func_147439_a(x, headY = MathHelper.func_76128_c((double)(entity.field_70163_u + (double)entity.func_70047_e())), z = MathHelper.func_76128_c((double)entity.field_70161_v)) != instance) {
            return false;
        }
        return entity.field_70163_u + (double)entity.func_70047_e() < (double)y + BlockQuickSand.getQuicksandBlockLevel((IBlockAccess)world, x, y, z);
    }

    private void tryFlowing(World world, int x, int y, int z) {
        boolean flowedDown = this.flowDown(world, x, y, z);
        if (!flowedDown) {
            Random rand = new Random();
            int r = rand.nextInt(4);
            for (int i = 0; i < 4; ++i) {
                int xOffset;
                int n = r == 2 ? 1 : (xOffset = r == 3 ? -1 : 0);
                int zOffset = r == 0 ? 1 : (r == 1 ? -1 : 0);
                this.flowSideways(world, x, y, z, xOffset, zOffset);
                if (++r <= 3) continue;
                r = 0;
            }
        }
    }

    private boolean flowDown(World world, int x, int y, int z) {
        int sandAmount;
        int amountFlowed;
        if (world.func_147439_a(x, y, z) == instance && (amountFlowed = this.flowIntoBlock(world, x, y - 1, z, sandAmount = BlockQuickSand.getQuicksandLevel((IBlockAccess)world, x, y, z))) > 0) {
            if (sandAmount <= amountFlowed) {
                world.func_147468_f(x, y, z);
                return true;
            }
            world.func_72921_c(x, y, z, 16 - (sandAmount - amountFlowed), 3);
            return true;
        }
        return false;
    }

    private boolean flowSideways(World world, int x, int y, int z, int xOffset, int zOffset) {
        if (world.func_147439_a(x, y, z) == instance && world.func_72805_g(x, y, z) < 15 && (world.func_147437_c(x + xOffset, y, z + zOffset) || world.func_147439_a(x + xOffset, y, z + zOffset) == instance && BlockQuickSand.getQuicksandLevel((IBlockAccess)world, x, y, z) > BlockQuickSand.getQuicksandLevel((IBlockAccess)world, x + xOffset, y, z + zOffset) + 2)) {
            int sandAmount = BlockQuickSand.getQuicksandLevel((IBlockAccess)world, x, y, z);
            int amountFlowed = this.flowIntoBlock(world, x + xOffset, y, z + zOffset, 1);
            if (amountFlowed > 0) {
                if (sandAmount <= amountFlowed) {
                    world.func_147468_f(x, y, z);
                    return true;
                }
                world.func_72921_c(x, y, z, 16 - (sandAmount - amountFlowed), 3);
                return true;
            }
        }
        return false;
    }

    public int flowIntoBlock(World world, int x, int y, int z, int flowAmount) {
        Block toFlowInto = world.func_147439_a(x, y, z);
        if (flowAmount > 0 && (toFlowInto == instance && world.func_72805_g(x, y, z) != 0 || world.func_147437_c(x, y, z))) {
            if (toFlowInto == Blocks.field_150350_a) {
                world.func_147465_d(x, y, z, instance, 16 - flowAmount, 3);
                return flowAmount;
            }
            if (toFlowInto == instance) {
                int emptyAmount = world.func_72805_g(x, y, z);
                int finalFlowAmount = Math.min(emptyAmount, flowAmount);
                if (finalFlowAmount > 0) {
                    world.func_72921_c(x, y, z, emptyAmount - finalFlowAmount, 3);
                }
                return finalFlowAmount;
            }
            return 0;
        }
        return 0;
    }

    public static int getQuicksandLevel(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == instance) {
            return BlockQuickSand.getQuicksandLevelFromMeta(world.func_72805_g(x, y, z));
        }
        return 0;
    }

    public static double getQuicksandBlockLevel(IBlockAccess world, int x, int y, int z) {
        return (double)BlockQuickSand.getQuicksandLevel(world, x, y, z) * 0.0625;
    }

    public static int getQuicksandLevelFromMeta(int meta) {
        return 16 - meta;
    }

    public static int getMetaFromQuicksandLevel(int level) {
        return 16 - level;
    }
}

