/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts;

import baubles.api.BaublesApi;
import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.components.UtilsForComponents;
import com.draco18s.artifacts.entity.TileEntityAntibuilder;
import com.draco18s.artifacts.item.ItemArtifact;
import com.draco18s.artifacts.item.ItemArtifactArmor;
import com.draco18s.artifacts.item.ItemOrichalcumDust;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ArtifactTickHandler {
    private World world;
    private EntityPlayer eobj;
    public static ArtifactTickHandler instance;
    private boolean shouldRun = false;
    private int lastLevel = 0;
    private int trigger1 = 0;
    private int trigger2 = 1;
    private int trigger3 = 18000;
    private int trigger4 = 2;
    private boolean randomized = false;
    private int healthTick = 0;
    public static int repairCount;

    public ArtifactTickHandler() {
        instance = this;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        block13: {
            block12: {
                boolean flag;
                if (event.phase != TickEvent.Phase.END) break block12;
                if (!this.shouldRun) {
                    return;
                }
                if (this.eobj.field_71070_bA != null && this.eobj.field_71070_bA != this.eobj.field_71069_bz) break block13;
                this.shouldRun = false;
                long state2 = this.world.func_72820_D();
                int state1 = this.world.field_73011_w.func_76559_b(state2);
                int calc = (int)Math.abs(state2 % 24000L - (long)this.trigger3);
                boolean bl = flag = (state1 == this.trigger1 || state1 == this.trigger2) && calc < 3000;
                if (!flag || this.eobj.field_71068_ca < this.trigger4 || this.lastLevel <= this.eobj.field_71068_ca) break block13;
                int m = Math.min((this.eobj.field_71068_ca + 1) / 3, 4);
                this.eobj.func_82242_a(-1 * m);
                EntityItem ent = new EntityItem(this.world, this.eobj.field_70165_t, this.eobj.field_70163_u, this.eobj.field_70161_v, new ItemStack(ItemOrichalcumDust.instance, m));
                this.world.func_72838_d((Entity)ent);
                break block13;
            }
            List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            ++this.healthTick;
            if (this.healthTick >= 20) {
                this.healthTick = 0;
                for (EntityPlayer player : playerList) {
                    int effectID;
                    ItemStack current;
                    int i;
                    int artifactHealthBoostCount = 0;
                    int artifactKnockbackCount = 0;
                    int artifactSpeedBoostCount = 0;
                    for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        current = player.field_71071_by.field_70462_a[i];
                        if (current == null || current.func_77978_p() == null || !(current.func_77973_b() instanceof ItemArtifact) || DragonArtifacts.baublesLoaded && DragonArtifacts.baublesMustBeEquipped && UtilsForComponents.equipableByBaubles(current.field_77990_d.func_74779_i("iconName")) || (effectID = current.func_77978_p().func_74762_e("onUpdate")) != 16) continue;
                        ++artifactHealthBoostCount;
                    }
                    for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                        current = player.field_71071_by.field_70460_b[i];
                        if (current == null || current.func_77978_p() == null || !(current.func_77973_b() instanceof ItemArtifactArmor)) continue;
                        effectID = current.func_77978_p().func_74762_e("onArmorTickUpdate");
                        int effectID2 = current.func_77978_p().func_74762_e("onArmorTickUpdate2");
                        if (effectID == 16 || effectID2 == 16) {
                            ++artifactHealthBoostCount;
                        }
                        if (effectID == 21 || effectID2 == 21) {
                            ++artifactKnockbackCount;
                        }
                        if (effectID != 15 && effectID2 != 15) continue;
                        ++artifactSpeedBoostCount;
                    }
                    if (DragonArtifacts.baublesLoaded) {
                        IInventory baublesSlots = BaublesApi.getBaubles(player);
                        for (int i2 = 0; i2 < baublesSlots.func_70302_i_(); ++i2) {
                            int effectID2;
                            ItemStack current2 = baublesSlots.func_70301_a(i2);
                            if (current2 == null || current2.func_77978_p() == null || !(current2.func_77973_b() instanceof ItemArtifact) || (effectID2 = current2.func_77978_p().func_74762_e("onUpdate")) != 16) continue;
                            ++artifactHealthBoostCount;
                        }
                    }
                    this.updateHealthBoost(artifactHealthBoostCount, player);
                    this.updateKnockbackResistance(artifactKnockbackCount, player);
                    this.updateSpeedBoost(artifactSpeedBoostCount, player);
                }
            }
            if (++repairCount > 1200) {
                repairCount = 0;
            }
            ArrayList<TileEntityAntibuilder.AntibuilderLocation> toRemove = new ArrayList<TileEntityAntibuilder.AntibuilderLocation>();
            for (TileEntityAntibuilder.AntibuilderLocation location : TileEntityAntibuilder.antibuilders.keySet()) {
                int strength = TileEntityAntibuilder.antibuilders.get(location);
                TileEntityAntibuilder.antibuilders.put(location, strength - 1);
                if (strength - 1 >= 0) continue;
                toRemove.add(location);
            }
            for (TileEntityAntibuilder.AntibuilderLocation location : toRemove) {
                TileEntityAntibuilder.antibuilders.remove(location);
            }
        }
    }

    private void updateHealthBoost(int artifactHealthBoostCount, EntityPlayer player) {
        NBTTagCompound playerData = player.getEntityData();
        int oldHealthBoostCount = playerData.func_74762_e("artifactHealthBoostCount");
        if (oldHealthBoostCount != artifactHealthBoostCount) {
            int diff;
            UUID healthID;
            String uu = playerData.func_74779_i("artifactHealthBoostUUID");
            if (uu.equals("")) {
                healthID = UUID.randomUUID();
                playerData.func_74778_a("artifactHealthBoostUUID", healthID.toString());
            } else {
                healthID = UUID.fromString(uu);
            }
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            atinst.func_111124_b(new AttributeModifier(healthID, "HealthBoostComponent", (double)(5.0f * (float)oldHealthBoostCount), 0));
            atinst.func_111121_a(new AttributeModifier(healthID, "HealthBoostComponent", (double)(5.0f * (float)artifactHealthBoostCount), 0));
            if (player.func_110143_aJ() > player.func_110138_aP()) {
                player.func_70606_j(player.func_110138_aP());
            }
            if ((diff = artifactHealthBoostCount - oldHealthBoostCount) > 0 && player.func_110143_aJ() < player.func_110138_aP()) {
                player.func_70691_i((float)(5 * diff));
            }
            playerData.func_74768_a("artifactHealthBoostCount", artifactHealthBoostCount);
        }
    }

    private void updateKnockbackResistance(int artifactKnockbackCount, EntityPlayer player) {
        NBTTagCompound playerData = player.getEntityData();
        int oldKnockbackCount = playerData.func_74762_e("artifactKnockbackCount");
        if (oldKnockbackCount != artifactKnockbackCount) {
            UUID knockbackID;
            String uu = playerData.func_74779_i("artifactKnockbackUUID");
            if (uu.equals("")) {
                knockbackID = UUID.randomUUID();
                playerData.func_74778_a("artifactKnockbackUUID", knockbackID.toString());
            } else {
                knockbackID = UUID.fromString(uu);
            }
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111266_c);
            atinst.func_111124_b(new AttributeModifier(knockbackID, "KnockbackComponent", (double)(0.2f * (float)oldKnockbackCount), 0));
            atinst.func_111121_a(new AttributeModifier(knockbackID, "KnockbackComponent", (double)(0.2f * (float)artifactKnockbackCount), 0));
            playerData.func_74768_a("artifactKnockbackCount", artifactKnockbackCount);
        }
    }

    private void updateSpeedBoost(int artifactSpeedBoostCount, EntityPlayer player) {
        NBTTagCompound playerData = player.getEntityData();
        int oldSpeedBoostCount = playerData.func_74762_e("artifactSpeedBoostCount");
        if (oldSpeedBoostCount != artifactSpeedBoostCount) {
            UUID speedID;
            String uu = playerData.func_74779_i("artifactSpeedBoostUUID");
            if (uu.equals("")) {
                speedID = UUID.randomUUID();
                playerData.func_74778_a("artifactSpeedBoostUUID", speedID.toString());
            } else {
                speedID = UUID.fromString(uu);
            }
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            atinst.func_111124_b(new AttributeModifier(speedID, "SpeedBoostComponent", (double)(0.05f * (float)oldSpeedBoostCount), 2));
            atinst.func_111121_a(new AttributeModifier(speedID, "SpeedBoostComponent", (double)(0.05f * (float)artifactSpeedBoostCount), 2));
            playerData.func_74768_a("artifactSpeedBoostCount", artifactSpeedBoostCount);
        }
    }

    public void readyTickHandler(World w, EntityPlayer pl) {
        this.world = w;
        this.eobj = pl;
        this.shouldRun = true;
        this.lastLevel = this.eobj.field_71068_ca;
        if (!this.randomized) {
            Random r = new Random(this.world.field_73011_w.getSeed());
            this.trigger3 = r.nextInt(4) * 6000;
            this.trigger1 = r.nextInt(4);
            this.trigger2 = this.trigger1 + 4;
        }
        this.randomized = true;
    }

    static {
        repairCount = 0;
    }
}

