/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.tiles.abstraction;

import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.localization.WailaText;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.networking.TileCableBus;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.common.integration.IWailaSource;
import thaumicenergistics.common.registries.EnumCache;
import thaumicenergistics.common.utils.EffectiveSide;

public abstract class TileProviderBase
extends AENetworkTile
implements IColorableTile,
IWailaSource {
    protected static final String NBT_KEY_COLOR = "TEColor";
    protected static final String NBT_KEY_ATTACHMENT = "TEAttachSide";
    protected static final String NBT_KEY_ISCOLORFORCED = "ColorForced";
    private final MachineSource asMachineSource = new MachineSource((IActionHost)this);
    protected int attachmentSide;
    protected IMEEssentiaMonitor monitor = null;
    protected boolean isActive;
    protected boolean isColorForced = false;

    private AEColor[] getNeighborCableColors() {
        AEColor[] sideColors = new AEColor[6];
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (tileEntity == null || !(tileEntity instanceof TileCableBus)) continue;
            sideColors[side.ordinal()] = ((TileCableBus)tileEntity).getColor();
        }
        return sideColors;
    }

    protected int extractEssentiaFromNetwork(Aspect wantedAspect, int wantedAmount, boolean mustMatch) {
        if (this.getEssentiaMonitor()) {
            long amountExtracted = this.monitor.extractEssentia(wantedAspect, wantedAmount, Actionable.SIMULATE, (BaseActionSource)this.asMachineSource, true);
            if (amountExtracted == 0L) {
                return 0;
            }
            if (mustMatch && amountExtracted != (long)wantedAmount) {
                return 0;
            }
            this.monitor.extractEssentia(wantedAspect, wantedAmount, Actionable.MODULATE, (BaseActionSource)this.asMachineSource, true);
            return (int)amountExtracted;
        }
        return 0;
    }

    protected boolean getEssentiaMonitor() {
        IMEEssentiaMonitor essentiaMonitor = null;
        IGrid grid = null;
        IGridNode node = this.getProxy().getNode();
        if (node != null && (grid = node.getGrid()) != null) {
            essentiaMonitor = (IMEEssentiaMonitor)grid.getCache(IEssentiaGrid.class);
        }
        this.monitor = essentiaMonitor;
        return this.monitor != null;
    }

    protected abstract double getIdlePowerusage();

    protected abstract ItemStack getItemFromTile(Object var1);

    protected void onPowerChange(boolean isPowered) {
    }

    protected void setProviderColor(AEColor gridColor) {
        this.getProxy().myColor = gridColor;
        if (EffectiveSide.isServerSide()) {
            this.markForUpdate();
            this.saveChanges();
        }
    }

    @Override
    public void addWailaInformation(List<String> tooltip) {
        if (this.isActive()) {
            tooltip.add(WailaText.DeviceOnline.getLocal());
        } else {
            tooltip.add(WailaText.DeviceOffline.getLocal());
        }
        tooltip.add("Color: " + this.getColor().toString());
    }

    @MENetworkEventSubscribe
    public final void channelEvent(MENetworkChannelsChanged event) {
        this.checkGridConnectionColor();
        if (EffectiveSide.isServerSide()) {
            this.getEssentiaMonitor();
        }
        this.markForUpdate();
    }

    public void checkGridConnectionColor() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || this.field_145850_b == null) {
            return;
        }
        if (this.isColorForced) {
            return;
        }
        AEColor[] sideColors = this.getNeighborCableColors();
        AEColor currentColor = this.getProxy().myColor;
        if (this.attachmentSide != ForgeDirection.UNKNOWN.ordinal() && sideColors[this.attachmentSide] != null) {
            if (sideColors[this.attachmentSide] == currentColor) {
                return;
            }
            this.setProviderColor(sideColors[this.attachmentSide]);
            return;
        }
        for (int index = 0; index < 6; ++index) {
            if (sideColors[index] == null) continue;
            if (sideColors[index] == currentColor) {
                this.attachmentSide = index;
                this.saveChanges();
                return;
            }
            if (currentColor != AEColor.Transparent) continue;
            this.attachmentSide = index;
            this.setProviderColor(sideColors[index]);
            return;
        }
        this.attachmentSide = ForgeDirection.UNKNOWN.ordinal();
        this.setProviderColor(AEColor.Transparent);
    }

    public long getAspectAmountInNetwork(Aspect searchAspect) {
        if (this.getEssentiaMonitor()) {
            return this.monitor.getEssentiaAmount(searchAspect);
        }
        return 0L;
    }

    public AECableType getCableConnectionType(ForgeDirection direction) {
        return AECableType.SMART;
    }

    public AEColor getColor() {
        return this.getProxy().myColor;
    }

    public AEColor getGridColor() {
        return this.getProxy().getGridColor();
    }

    public MachineSource getMachineSource() {
        return this.asMachineSource;
    }

    public boolean isActive() {
        if (EffectiveSide.isServerSide()) {
            boolean prevActive = this.isActive;
            if (this.getProxy() != null && this.getProxy().getNode() != null) {
                this.isActive = this.getProxy().getNode().isActive();
                if (prevActive != this.isActive) {
                    this.onPowerChange(this.isActive);
                }
            }
        }
        return this.isActive;
    }

    public void onBreakBlock() {
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void onLoadNBT(NBTTagCompound data) {
        int attachmentSideFromNBT = ForgeDirection.UNKNOWN.ordinal();
        if (data.func_74764_b(NBT_KEY_ISCOLORFORCED)) {
            this.isColorForced = data.func_74767_n(NBT_KEY_ISCOLORFORCED);
        }
        if (data.func_74764_b(NBT_KEY_COLOR)) {
            this.setProviderColor(EnumCache.AE_COLOR[data.func_74762_e(NBT_KEY_COLOR)]);
        }
        if (data.func_74764_b(NBT_KEY_ATTACHMENT)) {
            attachmentSideFromNBT = data.func_74762_e(NBT_KEY_ATTACHMENT);
        }
        this.setupProvider(attachmentSideFromNBT);
    }

    public void onReady() {
        super.onReady();
        this.checkGridConnectionColor();
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    @SideOnly(value=Side.CLIENT)
    public boolean onReceiveNetworkData(ByteBuf data) {
        this.setProviderColor(EnumCache.AE_COLOR[data.readInt()]);
        this.isActive = data.readBoolean();
        return true;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void onSaveNBT(NBTTagCompound data) {
        data.func_74768_a(NBT_KEY_COLOR, this.getGridColor().ordinal());
        data.func_74768_a(NBT_KEY_ATTACHMENT, this.attachmentSide);
        data.func_74757_a(NBT_KEY_ISCOLORFORCED, this.isColorForced);
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onSendNetworkData(ByteBuf data) throws IOException {
        data.writeInt(this.getGridColor().ordinal());
        data.writeBoolean(this.isActive());
    }

    @MENetworkEventSubscribe
    public final void powerEvent(MENetworkPowerStatusChange event) {
        this.markForUpdate();
    }

    public boolean recolourBlock(ForgeDirection side, AEColor color, EntityPlayer player) {
        this.isColorForced = true;
        this.setProviderColor(color);
        return true;
    }

    public void setOwner(EntityPlayer player) {
        this.getProxy().setOwner(player);
    }

    public void setupProvider(int attachmentSide) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.attachmentSide = attachmentSide;
            this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.getProxy().setIdlePowerUsage(this.getIdlePowerusage());
        }
    }
}

