/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.storage;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.common.network.ThEBasePacket;

public class AspectStack
implements IAspectStack {
    private static final String NBTKEY_ASPECT_TAG = "AspectTag";
    private static final String NBTKEY_ASPECT_AMOUNT = "Amount";
    private static final String NBTKEY_CRAFTABLE = "Craftable";
    @Nullable
    protected Aspect aspect;
    protected long stackSize;
    protected boolean isCraftable;

    public AspectStack() {
        this(null, 0L, false);
    }

    public AspectStack(Aspect aspect, long amount) {
        this(aspect, amount, false);
    }

    public AspectStack(Aspect aspect, long size, boolean craftable) {
        this.setAll(aspect, size, craftable);
    }

    public AspectStack(AspectStack stack) {
        this.setAll(stack);
    }

    public static AspectStack loadAspectStackFromNBT(NBTTagCompound data) {
        Aspect aspect = null;
        if (data.func_74764_b(NBTKEY_ASPECT_TAG)) {
            aspect = (Aspect)Aspect.aspects.get(data.func_74779_i(NBTKEY_ASPECT_TAG));
        }
        if (aspect == null) {
            return null;
        }
        long amount = 0L;
        if (data.func_74764_b(NBTKEY_ASPECT_AMOUNT)) {
            amount = data.func_74763_f(NBTKEY_ASPECT_AMOUNT);
        }
        boolean craftable = data.func_74764_b(NBTKEY_CRAFTABLE);
        return new AspectStack(aspect, amount, craftable);
    }

    public static AspectStack loadAspectStackFromStream(ByteBuf stream) {
        AspectStack stack = new AspectStack();
        stack.readFromStream(stream);
        return stack;
    }

    @Override
    public long adjustStackSize(long delta) {
        this.stackSize += delta;
        return this.stackSize;
    }

    @Override
    public IAspectStack copy() {
        return new AspectStack(this);
    }

    @Override
    public Aspect getAspect() {
        return this.aspect;
    }

    @Override
    public String getAspectDescription() {
        if (this.aspect != null) {
            return this.aspect.getLocalizedDescription();
        }
        return "";
    }

    @Override
    public String getAspectName() {
        if (this.aspect == null) {
            return "";
        }
        return this.aspect.getName();
    }

    @Override
    public String getAspectName(EntityPlayer player) {
        if (!this.hasPlayerDiscovered(player)) {
            return StatCollector.func_74838_a((String)"tc.aspect.unknown");
        }
        return this.getAspectName();
    }

    @Override
    public String getAspectTag() {
        if (this.aspect != null) {
            return this.aspect.getTag();
        }
        return "";
    }

    @Override
    public String getChatColor() {
        if (this.aspect != null) {
            return ThEGuiHelper.INSTANCE.getAspectChatColor(this.aspect);
        }
        return "";
    }

    @Override
    public boolean getCraftable() {
        return this.isCraftable;
    }

    @Override
    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public boolean hasAspect() {
        return this.aspect != null;
    }

    @Override
    public boolean hasPlayerDiscovered(EntityPlayer player) {
        if (player != null && this.aspect != null) {
            return Thaumcraft.proxy.getPlayerKnowledge().hasDiscoveredAspect(player.func_70005_c_(), this.aspect);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.stackSize <= 0L;
    }

    @Override
    public void readFromStream(ByteBuf stream) {
        this.aspect = ThEBasePacket.readAspect(stream);
        this.stackSize = stream.readLong();
        this.isCraftable = stream.readBoolean();
    }

    @Override
    public void setAll(Aspect aspect, long size, boolean craftable) {
        this.aspect = aspect;
        this.stackSize = size;
        this.isCraftable = craftable;
    }

    @Override
    public void setAll(IAspectStack stack) {
        if (stack != null) {
            this.aspect = stack.getAspect();
            this.stackSize = stack.getStackSize();
            this.isCraftable = stack.getCraftable();
        } else {
            this.aspect = null;
            this.stackSize = 0L;
            this.isCraftable = false;
        }
    }

    @Override
    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
    }

    @Override
    public void setCraftable(boolean craftable) {
        this.isCraftable = craftable;
    }

    @Override
    public void setStackSize(long size) {
        this.stackSize = size;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        if (this.aspect != null) {
            data.func_74778_a(NBTKEY_ASPECT_TAG, this.aspect.getTag());
            if (this.stackSize > 0L) {
                data.func_74772_a(NBTKEY_ASPECT_AMOUNT, this.stackSize);
            }
            if (this.isCraftable) {
                data.func_74757_a(NBTKEY_CRAFTABLE, true);
            }
        }
        return data;
    }

    @Override
    public void writeToStream(ByteBuf stream) {
        ThEBasePacket.writeAspect(this.aspect, stream);
        stream.writeLong(this.stackSize);
        stream.writeBoolean(this.isCraftable);
    }
}

