/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.parts.PartEssentiaStorageBus;

public abstract class HandlerEssentiaStorageBusBase
implements IMEInventoryHandler<IAEFluidStack> {
    protected static final ThEApi TEAPI = ThEApi.instance();
    protected PartEssentiaStorageBus partStorageBus;
    protected AccessRestriction access;
    protected List<Aspect> filteredAspects = new ArrayList<Aspect>();
    protected boolean inverted;
    protected MachineSource machineSource;
    private boolean isVoidAllowed = false;

    public HandlerEssentiaStorageBusBase(PartEssentiaStorageBus part) {
        this.partStorageBus = part;
        this.access = AccessRestriction.READ_WRITE;
        if (part != null) {
            this.machineSource = new MachineSource((IActionHost)part);
        }
    }

    protected boolean allowAny() {
        for (Aspect filteredAspect : this.filteredAspects) {
            if (filteredAspect == null) continue;
            return false;
        }
        return true;
    }

    protected boolean canTransferGas(GaseousEssentia essentiaGas) {
        if (this.allowAny()) {
            return true;
        }
        return this.filteredAspects.contains(essentiaGas.getAspect()) == !this.inverted;
    }

    protected TileEntity getFaceingTile() {
        TileEntity hostTile = this.partStorageBus.getHostTile();
        if (hostTile == null) {
            return null;
        }
        if (hostTile.func_145831_w() == null) {
            return null;
        }
        ForgeDirection orientation = this.partStorageBus.getSide();
        return hostTile.func_145831_w().func_147438_o(hostTile.field_145851_c + orientation.offsetX, hostTile.field_145848_d + orientation.offsetY, hostTile.field_145849_e + orientation.offsetZ);
    }

    protected IPart getFacingPartFromPartHost(IPartHost partHost) {
        return partHost.getPart(this.partStorageBus.getSide().getOpposite());
    }

    protected boolean hasSecurityPermission() {
        return this.access != AccessRestriction.READ && this.access != AccessRestriction.NO_ACCESS;
    }

    protected boolean isFluidEssentiaGas(FluidStack fluid) {
        if (fluid == null) {
            return false;
        }
        return fluid.getFluid() instanceof GaseousEssentia;
    }

    protected boolean isFluidEssentiaGas(IAEFluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        return this.isFluidEssentiaGas(fluidStack.getFluidStack());
    }

    protected void postAlterationToHostGrid(Iterable<IAEFluidStack> change) {
        try {
            if (this.partStorageBus.getActionableNode().isActive()) {
                this.partStorageBus.getGridBlock().getStorageGrid().postAlterationOfStoredItems(StorageChannel.FLUIDS, change, (BaseActionSource)this.machineSource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean canAccept(IAEFluidStack var1);

    public abstract IAEFluidStack extractItems(IAEFluidStack var1, Actionable var2, BaseActionSource var3);

    public AccessRestriction getAccess() {
        return this.access;
    }

    public abstract IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> var1);

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public int getPriority() {
        return this.partStorageBus.getPriority();
    }

    public int getSlot() {
        return 0;
    }

    public abstract IAEFluidStack injectItems(IAEFluidStack var1, Actionable var2, BaseActionSource var3);

    public final boolean isPrioritized(IAEFluidStack fluidStack) {
        if (!this.isFluidEssentiaGas(fluidStack)) {
            return false;
        }
        try {
            return this.filteredAspects.contains(((GaseousEssentia)fluidStack.getFluidStack().getFluid()).getAspect());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isVoidAllowed() {
        return this.isVoidAllowed;
    }

    public abstract boolean onNeighborChange();

    public void setInverted(boolean isInverted) {
        this.inverted = isInverted;
    }

    public void setPrioritizedAspects(List<Aspect> aspectList) {
        this.filteredAspects = aspectList;
    }

    public void setVoidAllowed(boolean isVoidAllowed) {
        this.isVoidAllowed = isVoidAllowed;
    }

    public abstract void tickingRequest(IGridNode var1, int var2);

    public abstract boolean validForPass(int var1);
}

