/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import appeng.api.networking.IGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.DimensionalCoord;
import java.lang.ref.WeakReference;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.api.grid.IDigiVisSource;
import thaumicenergistics.common.registries.ThEStrings;

public class DigiVisSourceData {
    private static final String NBT_KEY_HAS_DATA = "hasData";
    private static final String NBT_KEY_DATA = "data";
    private static final String NBT_KEY_UID = "uid";
    public static final String SOURCE_UNLOC_NAME = ThEStrings.Gui_DigiVisSource.getUnlocalized();
    private boolean hasData = false;
    private int worldID;
    private int x;
    private int y;
    private int z;
    private ForgeDirection side;
    private long UID;
    private WeakReference<IDigiVisSource> digiVisSource;

    public DigiVisSourceData() {
        this.clearData();
    }

    public DigiVisSourceData(IDigiVisSource digiVisSource) {
        this.clearData();
        if (digiVisSource == null) {
            return;
        }
        DimensionalCoord sourceLocation = digiVisSource.getLocation();
        if (sourceLocation == null) {
            return;
        }
        this.worldID = sourceLocation.getWorld().field_73011_w.field_76574_g;
        this.x = sourceLocation.x;
        this.y = sourceLocation.y;
        this.z = sourceLocation.z;
        this.side = digiVisSource.getSide();
        this.UID = digiVisSource.getUID();
        this.hasData = true;
    }

    private IDigiVisSource getSource(boolean forceUpdate) {
        if (this.hasData) {
            IDigiVisSource vInt = (IDigiVisSource)this.digiVisSource.get();
            if (forceUpdate || vInt == null) {
                this.refreshCache();
                return (IDigiVisSource)this.digiVisSource.get();
            }
            return vInt;
        }
        return null;
    }

    private void refreshCache() {
        this.digiVisSource.clear();
        IDigiVisSource visSource = null;
        try {
            WorldServer world = DimensionManager.getWorld((int)this.worldID);
            if (world == null) {
                return;
            }
            TileEntity tile = world.func_147438_o(this.x, this.y, this.z);
            if (tile == null) {
                return;
            }
            if (this.side.equals((Object)ForgeDirection.UNKNOWN)) {
                if (!(tile instanceof IDigiVisSource)) {
                    return;
                }
                visSource = (IDigiVisSource)tile;
            } else {
                if (!(tile instanceof IPartHost)) {
                    return;
                }
                IPart part = ((IPartHost)tile).getPart(this.side);
                if (!(part instanceof IDigiVisSource)) {
                    return;
                }
                visSource = (IDigiVisSource)part;
            }
            if (visSource.getUID() == this.UID) {
                this.digiVisSource = new WeakReference<IDigiVisSource>(visSource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearData() {
        this.hasData = false;
        this.worldID = -1;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.side = ForgeDirection.UNKNOWN;
        this.UID = 0L;
        this.digiVisSource = new WeakReference<Object>(null);
    }

    public boolean hasSourceData() {
        return this.hasData;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.clearData();
        if (tag == null) {
            return;
        }
        if (tag.func_74767_n(NBT_KEY_HAS_DATA)) {
            if (!tag.func_74764_b(NBT_KEY_UID) || !tag.func_74764_b(NBT_KEY_DATA)) {
                return;
            }
            int[] info = tag.func_74759_k(NBT_KEY_DATA);
            if (info.length < 5) {
                return;
            }
            this.worldID = info[0];
            this.x = info[1];
            this.y = info[2];
            this.z = info[3];
            this.side = ForgeDirection.getOrientation((int)info[4]);
            this.UID = tag.func_74763_f(NBT_KEY_UID);
            this.hasData = true;
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        this.readFromNBT(data.func_74775_l(name));
    }

    public IDigiVisSource tryGetSource(IGrid destinationGrid) {
        try {
            if (destinationGrid == null) {
                return null;
            }
            IDigiVisSource source = this.getSource(false);
            if (source == null) {
                return null;
            }
            IGrid sourceGrid = source.getGrid();
            if (!destinationGrid.equals(sourceGrid) && !destinationGrid.equals(sourceGrid = (source = this.getSource(true)).getGrid())) {
                return null;
            }
            return source;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(NBT_KEY_HAS_DATA, this.hasData);
        if (this.hasData) {
            tag.func_74783_a(NBT_KEY_DATA, new int[]{this.worldID, this.x, this.y, this.z, this.side.ordinal()});
            tag.func_74772_a(NBT_KEY_UID, this.UID);
        }
        return tag;
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        data.func_74782_a(name, (NBTBase)this.writeToNBT());
    }
}

