/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.util.Platform;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.container.ContainerEssentiaCellTerminalBase;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.common.inventory.TheInternalInventory;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaCellTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellTerminal;
import thaumicenergistics.common.storage.AspectStackComparator;
import thaumicenergistics.common.utils.EffectiveSide;

public class ContainerWirelessEssentiaTerminal
extends ContainerEssentiaCellTerminalBase {
    private static final int EXTRACT_POWER_ON_TICK = 10;
    @Nonnull
    private final HandlerWirelessEssentiaTerminal handler;
    private Aspect tmpSelectedAspect;
    private final TheInternalInventory privateInventory = new TheInternalInventory("thaumicenergistics.item.essentia.cell.inventory", 2, 64){

        @Override
        public boolean func_94041_b(int slotID, ItemStack itemStack) {
            EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack);
            return iType == EssentiaItemContainerHelper.AspectItemType.EssentiaContainer || iType == EssentiaItemContainerHelper.AspectItemType.JarLabel;
        }
    };
    private int powerTickCounter = 1;
    private int terminalSlotIndex = -1;

    public ContainerWirelessEssentiaTerminal(EntityPlayer player, @Nonnull HandlerWirelessEssentiaTerminal handler) {
        super(player);
        this.bindToInventory(this.privateInventory);
        this.terminalSlotIndex = player.field_71071_by.field_70461_c;
        this.handler = handler;
        if (EffectiveSide.isClientSide()) {
            Packet_S_EssentiaCellTerminal.sendFullUpdateRequest(player);
        }
    }

    @Override
    protected BaseActionSource getActionSource() {
        return this.handler.getActionHost();
    }

    @Override
    protected IGrid getHostGrid() {
        try {
            return this.handler.getActionableNode().getGrid();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Aspect getHostSelectedAspect() {
        return this.tmpSelectedAspect;
    }

    @Override
    protected IMEEssentiaMonitor getNewMonitor() {
        return this.handler.getEssentiaInventory();
    }

    @Override
    protected void setHostSelectedAspect(Aspect aspect) {
        this.tmpSelectedAspect = aspect;
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        if (this.handler != null) {
            return this.handler.isConnected();
        }
        return false;
    }

    @Override
    public void doWork(int elapsedTicks) {
        if (this.handler == null) {
            return;
        }
        this.powerTickCounter += elapsedTicks;
        if (this.powerTickCounter > 10) {
            this.handler.updatePowerMultiplier();
            this.handler.extractPower(this.powerTickCounter, Actionable.MODULATE);
            this.player.field_71071_by.field_70462_a[this.terminalSlotIndex] = this.handler.getTerminalItem();
            this.powerTickCounter = 0;
        }
        this.transferEssentiaFromWorkSlots();
    }

    @Override
    public ICraftingIssuerHost getCraftingHost() {
        return this.handler;
    }

    @Override
    public void onClientRequestAutoCraft(EntityPlayer player, Aspect aspect) {
        ThEGuiHandler.launchGui(80, player, player.field_70170_p, 0, 0, 0);
        if (player.field_71070_bA instanceof ContainerCraftAmount) {
            ContainerCraftAmount cca = (ContainerCraftAmount)this.player.field_71070_bA;
            cca.openContext = new ContainerOpenContext((Object)this.handler);
            cca.openContext.w = player.field_70170_p;
            IAEItemStack result = AEApi.instance().storage().createItemStack(ItemCraftingAspect.createStackForAspect(aspect, 1));
            cca.craftingItem.func_75215_d(result.getItemStack());
            cca.whatToMake = result;
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71137_h = false;
            }
            cca.func_75142_b();
        }
    }

    @Override
    public void onClientRequestFullUpdate() {
        Packet_C_EssentiaCellTerminal.sendViewingModes(this.player, this.handler.getSortingMode(), this.handler.getViewMode());
        Packet_C_EssentiaCellTerminal.sendFullList(this.player, this.repo.getAll());
    }

    @Override
    public void onClientRequestSortModeChange(EntityPlayer player, boolean backwards) {
        AspectStackComparator.AspectStackComparatorMode sortingMode = backwards ? this.handler.getSortingMode().previousMode() : this.handler.getSortingMode().nextMode();
        this.handler.setSortingMode(sortingMode);
        Packet_C_EssentiaCellTerminal.sendViewingModes(player, sortingMode, this.handler.getViewMode());
    }

    @Override
    public void onClientRequestViewModeChange(EntityPlayer player, boolean backwards) {
        ViewItems viewMode = (ViewItems)Platform.rotateEnum((Enum)this.handler.getViewMode(), (boolean)backwards, (EnumSet)Settings.VIEW_MODE.getPossibleValues());
        this.handler.setViewMode(viewMode);
        Packet_C_EssentiaCellTerminal.sendViewingModes(player, this.handler.getSortingMode(), viewMode);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide()) {
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
    }

    public ItemStack func_75144_a(int slotNumber, int buttonPressed, int flag, EntityPlayer player) {
        try {
            Slot clickedSlot = this.getSlotOrNull(slotNumber);
            if (clickedSlot.field_75224_c == this.player.field_71071_by && clickedSlot.getSlotIndex() == this.terminalSlotIndex) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.func_75144_a(slotNumber, buttonPressed, flag, player);
    }
}

