/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import appeng.container.slot.SlotFake;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.config.ConfigItems;
import thaumicenergistics.api.storage.IInventoryUpdateReceiver;
import thaumicenergistics.client.gui.EnumGuiParticles;
import thaumicenergistics.client.gui.GuiParticleAnimator;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.client.gui.abstraction.ThEBaseGui;
import thaumicenergistics.client.gui.buttons.GuiButtonEncodePattern;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerDistillationPatternEncoder;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.network.packet.server.Packet_S_DistillationEncoder;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.utils.ThEUtils;

@SideOnly(value=Side.CLIENT)
public class GuiDistillationPatternEncoder
extends ThEBaseGui
implements IInventoryUpdateReceiver {
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 234;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 6;
    private static final int BUTTON_ENCODE_POS_X = 146;
    private static final int BUTTON_ENCODE_POS_Y = 94;
    private static final int ITEM_HALF_SIZE = 8;
    private static final float THAUMOMETER_SCALE = 2.8f;
    private final String title;
    private final ContainerDistillationPatternEncoder deContainer;
    private final ItemStack thaumometer = new ItemStack(ConfigItems.itemThaumometer);
    private final ArrayList<GuiParticleAnimator> particles = new ArrayList();
    private GuiButtonEncodePattern buttonEncode;
    private boolean sourceItemDirty = false;

    public GuiDistillationPatternEncoder(EntityPlayer player, World world, int x, int y, int z) {
        super(new ContainerDistillationPatternEncoder(player, world, x, y, z));
        this.title = ThEStrings.Block_DistillationEncoder.getLocalized();
        this.field_146999_f = 176;
        this.field_147000_g = 234;
        this.deContainer = (ContainerDistillationPatternEncoder)this.field_147002_h;
        this.deContainer.slotUpdateReceiver = this;
    }

    private void checkSourceItem() {
        this.sourceItemDirty = false;
        this.particles.clear();
        if (!this.deContainer.slotSourceItem.func_75216_d()) {
            return;
        }
        boolean isItemScanned = false;
        for (SlotFake slot : this.deContainer.slotSourceAspects) {
            if (!slot.func_75216_d()) break;
            Aspect aspect = ItemCraftingAspect.getAspect(slot.func_75211_c());
            if (aspect == null) continue;
            isItemScanned = true;
            GuiParticleAnimator gpa = new GuiParticleAnimator(this.deContainer.slotSourceItem.field_75223_e, this.deContainer.slotSourceItem.field_75221_f, slot.field_75223_e, slot.field_75221_f, 0.3f, EnumGuiParticles.Orb);
            gpa.framesPerSecond = 30;
            float[] argb = ThEGuiHelper.INSTANCE.convertPackedColorToARGBf(aspect.getColor());
            gpa.setColor(argb[1], argb[2], argb[3]);
            this.particles.add(gpa);
        }
        if (isItemScanned) {
            ThEUtils.playClientSound(null, "thaumcraft:hhon");
        } else {
            ThEUtils.playClientSound(null, "thaumcraft:hhoff");
        }
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.DISTILLATION_ENCODER.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        float th_PosX = this.field_147003_i + 15 + 8;
        float th_PosY = (float)this.field_147009_r + 68.75f + 8.0f;
        float th_Rotation = (float)(System.currentTimeMillis() % 36000L) * 0.02f;
        float th_ScaleOffset = (float)Math.sin(th_Rotation * 0.15f) * 0.1f;
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)th_PosX, (float)th_PosY, (float)0.0f);
        GL11.glScalef((float)(2.8f + th_ScaleOffset), (float)(2.8f + th_ScaleOffset), (float)1.0f);
        GL11.glRotatef((float)th_Rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiScreen.field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.thaumometer, -8, -8);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 6, 6, 0);
        if (this.sourceItemDirty) {
            this.checkSourceItem();
        }
        if (this.particles.size() > 0) {
            EnumGuiParticles.Orb.prepareDraw();
            Iterator<GuiParticleAnimator> iterator = this.particles.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().draw((Gui)this, false)) continue;
                iterator.remove();
            }
            EnumGuiParticles.finishDraw();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (SlotFake slot : this.deContainer.slotSourceAspects) {
            if (!slot.func_75216_d() || !ThEGuiHelper.INSTANCE.isPointInGuiRegion(slot.field_75221_f, slot.field_75223_e, 18, 18, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) continue;
            ThEUtils.playClientSound(null, "gui.button.press");
            break;
        }
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        if (button == this.buttonEncode) {
            Packet_S_DistillationEncoder.sendEncodePattern(this.deContainer.getPlayer());
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonEncode = new GuiButtonEncodePattern(0, 146 + this.field_147003_i, 94 + this.field_147009_r, 16, 16);
        this.field_146292_n.add(this.buttonEncode);
        this.sourceItemDirty = false;
    }

    @Override
    public void onInventoryChanged(IInventory sourceInventory) {
        this.sourceItemDirty = true;
    }
}

