/*
 * Decompiled with CFR 0.152.
 */
package igwmod;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import igwmod.ConfigHandler;
import igwmod.IProxy;
import igwmod.InfoSupplier;
import igwmod.TickHandler;
import igwmod.WikiUtils;
import igwmod.api.VariableRetrievalEvent;
import igwmod.api.WikiRegistry;
import igwmod.gui.tabs.BlockAndItemWikiTab;
import igwmod.gui.tabs.EntityWikiTab;
import igwmod.gui.tabs.IGWWikiTab;
import igwmod.json.JsonRegistrator;
import igwmod.lib.IGWLog;
import igwmod.lib.Util;
import igwmod.recipeintegration.IntegratorComment;
import igwmod.recipeintegration.IntegratorCraftingRecipe;
import igwmod.recipeintegration.IntegratorFurnace;
import igwmod.recipeintegration.IntegratorImage;
import igwmod.recipeintegration.IntegratorStack;
import igwmod.render.TooltipOverlayHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
implements IProxy {
    public static KeyBinding openInterfaceKey;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new TickHandler());
        FMLCommonHandler.instance().bus().register((Object)new TooltipOverlayHandler());
        openInterfaceKey = new KeyBinding("igwmod.keys.wiki", 23, "igwmod.keys.category");
        ClientRegistry.registerKeyBinding((KeyBinding)openInterfaceKey);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        WikiRegistry.registerWikiTab(new IGWWikiTab());
        WikiRegistry.registerWikiTab(new BlockAndItemWikiTab());
        WikiRegistry.registerWikiTab(new EntityWikiTab());
        WikiRegistry.registerRecipeIntegrator(new IntegratorImage());
        WikiRegistry.registerRecipeIntegrator(new IntegratorCraftingRecipe());
        WikiRegistry.registerRecipeIntegrator(new IntegratorFurnace());
        WikiRegistry.registerRecipeIntegrator(new IntegratorStack());
        WikiRegistry.registerRecipeIntegrator(new IntegratorComment());
    }

    @SubscribeEvent
    public void onVariableTest(VariableRetrievalEvent event) {
        if (event.variableName.equals("igwmod:test1")) {
            event.replacementValue = "value1";
        } else if (event.variableName.equals("igwmod:test2")) {
            event.replacementValue = "value2";
        }
    }

    @SubscribeEvent
    public void onKeyBind(InputEvent.KeyInputEvent event) {
        if (openInterfaceKey.func_151468_f() && FMLClientHandler.instance().getClient().field_71415_G) {
            TickHandler.openWikiGui();
        }
    }

    @Override
    public void postInit() {
        JsonRegistrator.init();
        this.addDefaultKeys();
    }

    private void addDefaultKeys() {
        String blockCode;
        String modid;
        ArrayList allCreativeStacks = new ArrayList();
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_77640_w() == null) continue;
            try {
                item.func_150895_a(item, (CreativeTabs)null, allCreativeStacks);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        for (ItemStack itemStack : allCreativeStacks) {
            List<String> info;
            if (itemStack.func_77973_b() == null || GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b()) == null) continue;
            modid = "igwmod".toLowerCase();
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
            if (id != null && id.modId != null) {
                modid = id.modId.toLowerCase();
            }
            if ((info = InfoSupplier.getInfo(modid, WikiUtils.getNameFromStack(itemStack), true)) == null) continue;
            WikiRegistry.registerBlockAndItemPageEntry(itemStack);
        }
        for (Map.Entry entry : EntityList.field_75625_b.entrySet()) {
            modid = Util.getModIdForEntity((Class)entry.getValue());
            if (InfoSupplier.getInfo(modid, "entity/" + (String)entry.getKey(), true) == null) continue;
            WikiRegistry.registerEntityPageEntry((Class)entry.getValue());
        }
        for (IRecipe iRecipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (iRecipe.func_77571_b() == null || iRecipe.func_77571_b().func_77973_b() == null) continue;
            try {
                if (iRecipe.func_77571_b().func_77977_a() == null) {
                    IGWLog.error("Item has no unlocalized name: " + iRecipe.func_77571_b().func_77973_b());
                    continue;
                }
                blockCode = WikiUtils.getNameFromStack(iRecipe.func_77571_b());
                if (IntegratorCraftingRecipe.autoMappedRecipes.containsKey(blockCode)) continue;
                IntegratorCraftingRecipe.autoMappedRecipes.put(blockCode, iRecipe);
            }
            catch (Throwable e) {
                IGWLog.error("IGW-Mod failed to add recipe handling support for " + iRecipe.func_77571_b());
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (entry.getValue() == null || ((ItemStack)entry.getValue()).func_77973_b() == null || IntegratorFurnace.autoMappedFurnaceRecipes.containsKey(blockCode = WikiUtils.getNameFromStack((ItemStack)entry.getValue()))) continue;
            IntegratorFurnace.autoMappedFurnaceRecipes.put(blockCode, (ItemStack)entry.getKey());
        }
        IGWLog.info("Registered " + WikiRegistry.getItemAndBlockPageEntries().size() + " Block & Item page entries.");
        IGWLog.info("Registered " + WikiRegistry.getEntityPageEntries().size() + " Entity page entries.");
    }

    @Override
    public void processIMC(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        for (FMLInterModComms.IMCMessage message : messages) {
            try {
                Class<?> clazz = Class.forName(message.key);
                try {
                    Method method = clazz.getMethod(message.getStringValue(), new Class[0]);
                    if (method == null) {
                        IGWLog.error("Couldn't find the \"" + message.key + "\" method. Make sure it's there and marked with the 'static' modifier!");
                        continue;
                    }
                    try {
                        method.invoke(null, new Object[0]);
                        IGWLog.info("Successfully gave " + message.getSender() + " a nudge! Happy to be doing business!");
                    }
                    catch (IllegalAccessException e) {
                        IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method can NOT be accessed: " + message.getStringValue());
                    }
                    catch (IllegalArgumentException e) {
                        IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method has arguments or it isn't static: " + message.getStringValue());
                    }
                    catch (InvocationTargetException e) {
                        IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method threw an exception: " + message.getStringValue());
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method can NOT be found: " + message.getStringValue());
                }
                catch (SecurityException e) {
                    IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method can NOT be accessed: " + message.getStringValue());
                }
            }
            catch (ClassNotFoundException e) {
                IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the class can NOT be found: " + message.key);
            }
        }
    }

    @Override
    public String getSaveLocation() {
        String mcDataLocation = Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
        return mcDataLocation.substring(0, mcDataLocation.length() - 2);
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

