/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.mobiuscore.monitors.MonitoredEntityList;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.data.holders.basetypes.AmountHolder;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import mcp.mobius.opis.data.holders.newtypes.DataEntity;
import mcp.mobius.opis.data.holders.newtypes.DataEntityPerClass;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.data.holders.newtypes.PlayerStatus;
import mcp.mobius.opis.data.profilers.ProfilerEntityUpdate;
import mcp.mobius.opis.helpers.Teleport;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.PlayerEv;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public enum EntityManager {
    INSTANCE;


    public ArrayList<DataEntity> getWorses(int amount) {
        ArrayList<DataEntity> sorted = new ArrayList<DataEntity>();
        ArrayList<DataEntity> topEntities = new ArrayList<DataEntity>();
        for (Entity entity : ((ProfilerEntityUpdate)ProfilerSection.ENTITY_UPDATETIME.getProfiler()).data.keySet()) {
            sorted.add(new DataEntity().fill(entity));
        }
        Collections.sort(sorted);
        int i = 0;
        while (topEntities.size() < Math.min(amount, sorted.size()) && i < sorted.size()) {
            DataEntity testats = (DataEntity)sorted.get(i);
            if (testats.npoints < 40L) {
                ++i;
                continue;
            }
            if (DimensionManager.getWorld((int)testats.pos.dim) == null) {
                ++i;
                continue;
            }
            topEntities.add(testats);
            ++i;
        }
        return topEntities;
    }

    public ArrayList<DataEntity> getAllEntities() {
        ArrayList<DataEntity> entities = new ArrayList<DataEntity>();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            entities.addAll(this.getEntitiesInDim(i2));
        }
        return entities;
    }

    public ArrayList<DataEntity> getEntitiesInDim(int dim) {
        ArrayList<DataEntity> entities = new ArrayList<DataEntity>();
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return entities;
        }
        for (Object o : world.field_72996_f.toArray()) {
            Entity ent = (Entity)o;
            entities.add(new DataEntity().fill(ent));
        }
        return entities;
    }

    public HashMap<CoordinatesChunk, ArrayList<DataEntity>> getAllEntitiesPerChunk() {
        HashMap<CoordinatesChunk, ArrayList<DataEntity>> entities = new HashMap<CoordinatesChunk, ArrayList<DataEntity>>();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            entities.putAll(this.getEntitiesPerChunkInDim(i2));
        }
        return entities;
    }

    public HashMap<CoordinatesChunk, ArrayList<DataEntity>> getEntitiesPerChunkInDim(int dim) {
        HashMap<CoordinatesChunk, ArrayList<DataEntity>> entities = new HashMap<CoordinatesChunk, ArrayList<DataEntity>>();
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return entities;
        }
        for (Object o : world.field_72996_f.toArray()) {
            Entity ent = (Entity)o;
            CoordinatesChunk chunk = new CoordinatesBlock(ent.field_71093_bK, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v).asCoordinatesChunk();
            if (!entities.containsKey(chunk)) {
                entities.put(chunk, new ArrayList());
            }
            entities.get(chunk).add(new DataEntity().fill(ent));
        }
        return entities;
    }

    public ArrayList<DataEntity> getEntitiesInChunk(CoordinatesChunk coord) {
        ArrayList<DataEntity> entities = new ArrayList<DataEntity>();
        WorldServer world = DimensionManager.getWorld((int)coord.dim);
        if (world == null) {
            return entities;
        }
        for (Object o : world.field_72996_f.toArray()) {
            Entity ent = (Entity)o;
            CoordinatesChunk chunk = new CoordinatesBlock(ent.field_71093_bK, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v).asCoordinatesChunk();
            if (!chunk.equals(coord)) continue;
            entities.add(new DataEntity().fill(ent));
        }
        return entities;
    }

    public ArrayList<AmountHolder> getCumulativeEntities(boolean filtered) {
        ArrayList<AmountHolder> cumData = new ArrayList<AmountHolder>();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) continue;
            if (!(world.field_72996_f instanceof MonitoredEntityList)) {
                modOpis.log.info("Improper type detected for entity list in world " + dim + ". Regenerating tracking list.");
                MonitoredEntityList newList = new MonitoredEntityList();
                for (Object o : world.field_72996_f) {
                    newList.add((Entity)o);
                }
                world.field_72996_f = newList;
            }
            Map count = ((MonitoredEntityList)world.field_72996_f).getCount();
            for (String key : count.keySet()) {
                if ((Integer)count.get(key) <= 0) continue;
                cumData.add(new AmountHolder(key, (Integer)count.get(key), "Plop"));
            }
        }
        return cumData;
    }

    public boolean teleportPlayer(CoordinatesBlock coord, EntityPlayerMP player) {
        CoordinatesBlock target = Teleport.instance().getTeleportTarget(coord);
        if (target == null) {
            return false;
        }
        target = Teleport.instance().fixNetherTP(target);
        if (target == null) {
            return false;
        }
        if (!Teleport.instance().movePlayerToDimension(player, coord.dim)) {
            return false;
        }
        player.func_70634_a((double)target.x + 0.5, (double)target.y, (double)target.z + 0.5);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean teleportEntity(Entity src, Entity trg, EntityPlayerMP msgtrg) {
        if (src == null && msgtrg != null) {
            PacketManager.sendChatMsg(String.format("\u00a7oCannot find source entity %s", src), msgtrg);
            return false;
        }
        if (trg == null && msgtrg != null) {
            PacketManager.sendChatMsg(String.format("\u00a7oCannot find target entity %s", src), msgtrg);
            return false;
        }
        if (src instanceof EntityPlayerMP) {
            if (!Teleport.instance().movePlayerToDimension((EntityPlayerMP)src, trg.field_70170_p.field_73011_w.field_76574_g)) return false;
            src.func_70012_b(trg.field_70165_t, trg.field_70163_u, trg.field_70161_v, src.field_70177_z, src.field_70125_A);
            return true;
        } else {
            if (!Teleport.instance().moveEntityToDimension(src, trg.field_70170_p.field_73011_w.field_76574_g)) return false;
            src.func_70012_b(trg.field_70165_t, trg.field_70163_u, trg.field_70161_v, src.field_70177_z, src.field_70125_A);
        }
        return true;
    }

    public Entity getEntity(int eid, int dim) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return null;
        }
        Entity entity = world.func_73045_a(eid);
        return entity;
    }

    public String getEntityName(Entity ent) {
        return this.getEntityName(ent, false);
    }

    public String getEntityName(Entity ent, boolean filtered) {
        if (ent instanceof EntityItem && filtered) {
            return "Dropped Item";
        }
        if (ent instanceof EntityItem && !filtered) {
            try {
                return "[Stack] " + ((EntityItem)ent).func_92059_d().func_82833_r();
            }
            catch (Exception e) {
                return "<Unknown dropped item>";
            }
        }
        if (ent instanceof EntityPlayerMP && filtered) {
            return "Player";
        }
        if (ent instanceof EntityPlayerMP && !filtered) {
            return "[ Player ] " + ((EntityPlayerMP)ent).func_146103_bH().getName();
        }
        String name = ent.func_70005_c_();
        if (name.contains(".")) {
            String[] namelst = ent.getClass().getName().split("\\.");
            return namelst[namelst.length - 1];
        }
        return name;
    }

    public DataTiming getTotalUpdateTime() {
        double updateTime = 0.0;
        for (Entity entity : ((ProfilerEntityUpdate)ProfilerSection.ENTITY_UPDATETIME.getProfiler()).data.keySet()) {
            updateTime += ((ProfilerEntityUpdate)ProfilerSection.ENTITY_UPDATETIME.getProfiler()).data.get(entity).getGeometricMean();
        }
        return new DataTiming(updateTime);
    }

    public int killAll(String entName) {
        int nkilled = 0;
        if (entName.contains("Player")) {
            return -1;
        }
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) continue;
            for (Object o : world.field_72996_f.toArray()) {
                Entity ent = (Entity)o;
                String nameFiltered = this.getEntityName(ent, true).toLowerCase();
                String nameUnfiltered = this.getEntityName(ent, false).toLowerCase();
                if (!nameFiltered.equals(entName.toLowerCase()) && !nameUnfiltered.equals(entName.toLowerCase())) continue;
                ent.func_70106_y();
                ++nkilled;
            }
        }
        System.out.printf("Killed %d %s\n", nkilled, entName);
        return nkilled;
    }

    public ArrayList<PlayerStatus> getAllPlayers() {
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        ArrayList<PlayerStatus> outList = new ArrayList<PlayerStatus>();
        for (Object o : players) {
            EntityPlayer p = (EntityPlayer)o;
            outList.add(new PlayerStatus(p.func_146103_bH().getName(), PlayerEv.ONLINE, p.field_70170_p.field_73011_w.field_76574_g, (int)p.field_70165_t, (int)p.field_70163_u, (int)p.field_70161_v));
        }
        return outList;
    }

    public int getAmountEntities() {
        int amountEntities = 0;
        for (WorldServer world : DimensionManager.getWorlds()) {
            amountEntities += world.field_72996_f.size();
        }
        return amountEntities;
    }

    public int killAllPerClass(int dim, Class clazz) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return -1;
        }
        int killedEnts = 0;
        ArrayList copyList = new ArrayList(world.field_72996_f);
        for (Entity entity : copyList) {
            if (!clazz.isInstance(entity)) continue;
            entity.func_70106_y();
            ++killedEnts;
        }
        return killedEnts;
    }

    public ArrayList<DataEntityPerClass> getTotalPerClass() {
        HashMap<String, DataEntityPerClass> data = new HashMap<String, DataEntityPerClass>();
        for (Entity entity : ((ProfilerEntityUpdate)ProfilerSection.ENTITY_UPDATETIME.getProfiler()).data.keySet()) {
            String name = this.getEntityName(entity, true);
            if (!data.containsKey(name)) {
                data.put(name, new DataEntityPerClass(name));
            }
            ((DataEntityPerClass)data.get(name)).add(((ProfilerEntityUpdate)ProfilerSection.ENTITY_UPDATETIME.getProfiler()).data.get(entity).getGeometricMean());
        }
        return new ArrayList<DataEntityPerClass>(data.values());
    }
}

