/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.newtypes;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.data.profilers.ProfilerDimTick;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import opisapache.math3.stat.descriptive.DescriptiveStatistics;

public class DataDimension
implements ISerializable {
    public int dim;
    public CachedString name;
    public int players;
    public int forced;
    public int loaded;
    public int entities;
    public int mobs;
    public int neutral;
    public int itemstacks;
    public DataTiming update;

    public DataDimension fill(int dim) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        this.dim = dim;
        this.name = new CachedString(world.field_73011_w.func_80007_l());
        this.players = world.field_73010_i.size();
        this.forced = world.getPersistentChunks().size();
        this.loaded = world.func_72863_F().func_73152_e();
        HashMap<Integer, DescriptiveStatistics> data = ((ProfilerDimTick)ProfilerSection.DIMENSION_TICK.getProfiler()).data;
        this.update = new DataTiming(data.containsKey(dim) ? data.get(dim).getGeometricMean() : 0.0);
        this.mobs = 0;
        this.neutral = 0;
        this.entities = world.field_72996_f.size();
        for (Entity entity : (ArrayList)world.field_72996_f) {
            if (entity instanceof EntityMob) {
                ++this.mobs;
            }
            if (entity instanceof EntityAnimal) {
                ++this.neutral;
            }
            if (!(entity instanceof EntityItem)) continue;
            ++this.itemstacks;
        }
        return this;
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        stream.writeInt(this.dim);
        stream.writeInt(this.players);
        stream.writeInt(this.forced);
        stream.writeInt(this.loaded);
        stream.writeInt(this.entities);
        stream.writeInt(this.mobs);
        stream.writeInt(this.neutral);
        stream.writeInt(this.itemstacks);
        this.update.writeToStream(stream);
        this.name.writeToStream(stream);
    }

    public static DataDimension readFromStream(ByteArrayDataInput stream) {
        DataDimension retVal = new DataDimension();
        retVal.dim = stream.readInt();
        retVal.players = stream.readInt();
        retVal.forced = stream.readInt();
        retVal.loaded = stream.readInt();
        retVal.entities = stream.readInt();
        retVal.mobs = stream.readInt();
        retVal.neutral = stream.readInt();
        retVal.itemstacks = stream.readInt();
        retVal.update = DataTiming.readFromStream(stream);
        retVal.name = CachedString.readFromStream(stream);
        return retVal;
    }
}

