/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod;

import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModRange;
import cofh.mod.updater.ModVersion;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringTranslate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public abstract class BaseMod
implements IUpdatableMod {
    protected File _configFolder;
    protected final String _modid;
    protected final Logger _log;

    protected BaseMod(Logger logger) {
        String string = this.getModId();
        this._modid = string.toLowerCase();
        this._log = logger;
        this.init();
    }

    protected BaseMod() {
        String string = this.getModId();
        this._modid = string.toLowerCase();
        this._log = LogManager.getLogger((String)string);
        this.init();
    }

    private void init() {
        ModContainer modContainer = Loader.instance().activeModContainer();
        if (modContainer.getSource().isDirectory()) {
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashCallable("Loaded from a directory"));
        } else {
            try {
                JarFile jarFile = new JarFile(modContainer.getSource());
                ZipEntry zipEntry = jarFile.getEntry("vers.prop");
                if (zipEntry != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(zipEntry)));
                    String string = bufferedReader.readLine();
                    FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashCallable(string));
                } else {
                    FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashCallable("Lacking version information."));
                }
                jarFile.close();
            }
            catch (IOException iOException) {
                FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashCallable("Error reading version information." + iOException.getMessage()));
            }
        }
    }

    @NetworkCheckHandler
    public final boolean networkCheck(Map<String, String> map, Side side) throws InvalidVersionSpecificationException {
        if (!this.requiresRemoteFrom(side)) {
            return true;
        }
        Mod mod = this.getClass().getAnnotation(Mod.class);
        String string = mod.modid();
        if (!map.containsKey(string)) {
            return false;
        }
        String string2 = mod.acceptableRemoteVersions();
        if (!"*".equals(string2)) {
            String string3 = map.get(string);
            if (Strings.isNullOrEmpty((String)string2)) {
                return this.getModVersion().equalsIgnoreCase(string3);
            }
            return ModRange.createFromVersionSpec(string, string2).containsVersion((ArtifactVersion)new ModVersion(string, string3));
        }
        return true;
    }

    protected boolean requiresRemoteFrom(Side side) {
        return true;
    }

    protected String getConfigBaseFolder() {
        String string = this.getClass().getPackage().getName();
        int n = string.indexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    protected void setConfigFolderBase(File file) {
        this._configFolder = new File(file, this.getConfigBaseFolder() + "/" + this._modid + "/");
    }

    protected File getConfig(String string) {
        return new File(this._configFolder, string + ".cfg");
    }

    protected File getClientConfig() {
        return this.getConfig("client");
    }

    protected File getCommonConfig() {
        return this.getConfig("common");
    }

    protected String getAssetDir() {
        return this._modid;
    }

    @Override
    public Logger getLogger() {
        return this._log;
    }

    private void loadLanguageFile(Properties properties, InputStream inputStream) throws Throwable {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        Properties properties2 = new Properties();
        properties2.load(inputStreamReader);
        properties.putAll((Map<?, ?>)properties2);
    }

    private void loadLanguageFile(String string, Properties properties) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.putAll(properties);
        LanguageRegistry.instance().injectLanguage(string.intern(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLang() {
        if (FMLLaunchHandler.side() == Side.CLIENT) {
            try {
                this.loadClientLang();
                return;
            }
            catch (Throwable throwable) {
                this._log.error(AbstractLogger.CATCHING_MARKER, "???", throwable);
            }
        }
        String string = "assets/" + this.getAssetDir() + "/language/";
        InputStream inputStream = null;
        String string2 = "en_US";
        try {
            inputStream = org.apache.logging.log4j.core.helpers.Loader.getResource((String)(string + string2 + ".lang"), null).openStream();
            Properties properties = new Properties();
            this.loadLanguageFile(properties, inputStream);
            StringTranslate stringTranslate = (StringTranslate)ObfuscationReflectionHelper.getPrivateValue(StringTranslate.class, null, (String[])new String[]{"instance", "field_74817_a"});
            Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(StringTranslate.class, (Object)stringTranslate, (String[])new String[]{"field_74816_c", "languageList"});
            map.putAll(properties);
        }
        catch (Throwable throwable) {
            this._log.catching(Level.INFO, throwable);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this._log.catching(Level.INFO, (Throwable)iOException);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClientLang() {
        IReloadableResourceManager iReloadableResourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        iReloadableResourceManager.func_110542_a((IResourceManagerReloadListener)new LangManager((IResourceManager)iReloadableResourceManager));
    }

    private class CrashCallable
    implements ICrashCallable {
        private final String data;

        private CrashCallable(String string) {
            this.data = string;
        }

        public String call() throws Exception {
            return this.data;
        }

        public String getLabel() {
            return BaseMod.this.getModId();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class LangManager
    implements IResourceManagerReloadListener {
        private final String _path;

        public LangManager(IResourceManager iResourceManager) {
            this._path = BaseMod.this.getAssetDir() + ":language/";
            this.func_110549_a(iResourceManager);
        }

        public void func_110549_a(IResourceManager iResourceManager) {
            String string = null;
            try {
                string = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            }
            catch (Throwable throwable) {
                BaseMod.this._log.catching(Level.WARN, throwable);
            }
            for (String string2 : Arrays.asList("en_US", string)) {
                if (string2 == null) continue;
                Properties properties = new Properties();
                try {
                    List list = iResourceManager.func_135056_b(new ResourceLocation(this._path + string2 + ".lang"));
                    for (IResource iResource : list) {
                        if (iResource.func_110527_b() == null) {
                            BaseMod.this._log.warn("A resource pack defines an entry for language '" + string2 + "' but the InputStream is null.");
                            continue;
                        }
                        try {
                            BaseMod.this.loadLanguageFile(properties, iResource.func_110527_b());
                        }
                        catch (Throwable throwable) {
                            BaseMod.this._log.warn(AbstractLogger.CATCHING_MARKER, "A resource pack has a file for language '" + string2 + "' but the file is invalid.", throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    BaseMod.this._log.info(AbstractLogger.CATCHING_MARKER, "No language data for '" + string2 + "'", throwable);
                }
                BaseMod.this.loadLanguageFile(string2, properties);
            }
            Minecraft.func_71410_x().func_135016_M().func_110549_a(iResourceManager);
        }
    }
}

