/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementButtonBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class ElementButton
extends ElementButtonBase {
    int sheetX;
    int sheetY;
    int hoverX;
    int hoverY;
    int disabledX = 0;
    int disabledY = 0;
    boolean tooltipLocalized = false;
    boolean managedClicks;
    String tooltip;

    public ElementButton(GuiBase guiBase, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        super(guiBase, n, n2, n3, n4);
        this.setGuiManagedClicks(false);
        this.setTexture(string, this.texW, this.texH);
        this.sheetX = n5;
        this.sheetY = n6;
        this.hoverX = n7;
        this.hoverY = n8;
    }

    public ElementButton(GuiBase guiBase, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, String string) {
        this(guiBase, n, n2, n3, n4, n5, n6, n7, n8, string);
        this.disabledX = n9;
        this.disabledY = n10;
    }

    public ElementButton(GuiBase guiBase, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, String string2) {
        super(guiBase, n, n2, n7, n8);
        this.setGuiManagedClicks(true);
        this.setName(string);
        this.setTexture(string2, this.texW, this.texH);
        this.sheetX = n3;
        this.sheetY = n4;
        this.hoverX = n5;
        this.hoverY = n6;
    }

    public ElementButton(GuiBase guiBase, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, String string2) {
        this(guiBase, n, n2, string, n3, n4, n5, n6, n9, n10, string2);
        this.disabledX = n7;
        this.disabledY = n8;
    }

    public ElementButton setGuiManagedClicks(boolean bl) {
        this.managedClicks = bl;
        return this;
    }

    public ElementButton clearToolTip() {
        this.tooltip = null;
        return this;
    }

    public ElementButton setToolTip(String string) {
        this.tooltip = string;
        return this;
    }

    public ElementButton setToolTipLocalized(boolean bl) {
        this.tooltipLocalized = bl;
        return this;
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        if (this.isEnabled()) {
            if (this.intersectsWith(n, n2)) {
                this.drawTexturedModalRect(this.posX, this.posY, this.hoverX, this.hoverY, this.sizeX, this.sizeY);
            } else {
                this.drawTexturedModalRect(this.posX, this.posY, this.sheetX, this.sheetY, this.sizeX, this.sizeY);
            }
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, this.disabledX, this.disabledY, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void drawForeground(int n, int n2) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tooltip != null) {
            if (this.tooltipLocalized) {
                list.add(this.tooltip);
            } else {
                list.add(StringHelper.localize(this.tooltip));
            }
        }
    }

    @Override
    public void onClick() {
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.managedClicks) {
            return super.onMousePressed(n, n2, n3);
        }
        if (this.isEnabled()) {
            this.gui.handleElementButtonClick(this.getName(), n3);
            return true;
        }
        return false;
    }

    public void setSheetX(int n) {
        this.sheetX = n;
    }

    public void setSheetY(int n) {
        this.sheetY = n;
    }

    public void setHoverX(int n) {
        this.hoverX = n;
    }

    public void setHoverY(int n) {
        this.hoverY = n;
    }

    public ElementButton setDisabledX(int n) {
        this.disabledX = n;
        return this;
    }

    public ElementButton setDisabledY(int n) {
        this.disabledY = n;
        return this;
    }

    public void setActive() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }
}

