/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectSourceHelper;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.config.ConfigBlocks;
import tuhljin.automagy.api.nethermind.INetherRune;
import tuhljin.automagy.api.nethermind.INetherRuneBase;
import tuhljin.automagy.api.nethermind.INetherRuneCreature;
import tuhljin.automagy.api.nethermind.RuneCategory;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.entities.EntityWispNether;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.ModTileEntityWithBasicAspectContainer;
import tuhljin.automagy.tiles.TileEntityDimensionLure;

public class TileEntityNethermind
extends ModTileEntityWithBasicAspectContainer {
    public static int MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY = 4;
    public static int TICKS_BEFORE_ALLOW_DISABLE = 10;
    public static int EERIE_SPREAD_CHANCE = 25;
    public static float SPEED_RUNE_MULTIPLIER = 0.075f;
    public static float MAX_SPEED_RUNES = 12.0f;
    public static int MIN_LURE_DISTANCE_BASE = 6;
    public static int MAX_LURE_DISTANCE = 10;
    public static int MAX_NEARBY_ENTITIES = 9;
    public static int INSTABILITY_PER_SUMMON = 80;
    public static int INSTABILITY_LEVEL_DESTROY_SUMMONED = 350;
    public static int INSTABILITY_PER_SPEED_RUNE = 5;
    public static int MIN_Y = 10;
    public static int VALIDITY_CHECK_FREQUENCY = 60;
    private int ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
    public Set<BlockCoord> specifyingRunePos = new HashSet<BlockCoord>();
    public int numSpeedRunes = 0;
    public int currentRuneX;
    public int currentRuneY = -1;
    public int currentRuneZ;
    public int currentRuneType;
    public int ticksToConjure;
    public int poweredTime = 0;
    public int instability = 0;
    protected int numCreatureRunes = 0;
    protected int dimensionLureY = -1;
    protected boolean didInstabilityCheckThisSummon = false;
    private int ticksEnabled;
    private int minLureDistance;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isEnabled()) {
                ++this.ticksEnabled;
                if (this.ticksSinceValidityCheck >= VALIDITY_CHECK_FREQUENCY) {
                    if (!this.mapStructure(null)) {
                        this.tryDisable();
                        return;
                    }
                } else {
                    ++this.ticksSinceValidityCheck;
                }
                int prevPower = this.poweredTime;
                if (this.poweredTime > 0) {
                    this.poweredTime = this.numCreatureRunes > 0 ? (this.poweredTime -= 2) : --this.poweredTime;
                }
                if (this.poweredTime < 1) {
                    int amt;
                    int n = amt = this.isEnabled() ? VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 1), (int)this.field_145849_e, (Aspect)Aspect.FIRE, (int)20) : 0;
                    if (amt > 0) {
                        this.poweredTime += amt;
                        if (prevPower < 1) {
                            this.markDirty(true);
                        } else {
                            this.markDirty(false);
                        }
                    } else if (prevPower > 0) {
                        this.markDirty(true);
                    }
                }
                if (this.poweredTime > 0) {
                    boolean nethermindNeedEssentia;
                    boolean bl = nethermindNeedEssentia = this.aspects.visSize() > 0;
                    if (!(nethermindNeedEssentia || this.numCreatureRunes >= 1 && this.lureAspectsNeeded() != 0)) {
                        --this.ticksToConjure;
                        if (this.ticksToConjure == 0) {
                            if (this.numCreatureRunes > 0) {
                                INetherRuneCreature rune = this.getCurrentCreatureRune(false);
                                TileEntityDimensionLure lure = this.getDimensionLure();
                                if (rune == null || lure == null) {
                                    this.requireValidityCheck();
                                    return;
                                }
                                int numToSpawn = rune.getSpawnCount(this.currentRuneType);
                                if (!this.didInstabilityCheckThisSummon) {
                                    boolean destroySpawn;
                                    this.didInstabilityCheckThisSummon = true;
                                    int extraInstability = rune.getInstability(this.currentRuneType);
                                    this.instabilityBuildup(lure.getStabilityModifiers() * 10 - (extraInstability += this.field_145850_b.field_73012_v.nextInt(10)));
                                    if (this.instability > 0 && this.field_145850_b.field_73012_v.nextInt(500) < this.instability && (destroySpawn = this.instabilityDischarge(rune, true))) {
                                        --numToSpawn;
                                    }
                                }
                                boolean anySpawned = false;
                                int delay = 0;
                                for (int i = 0; i < numToSpawn; ++i) {
                                    Boolean spawned = this.trySpawnCreatureFromRune(rune);
                                    if (spawned == null) {
                                        delay = 60;
                                        continue;
                                    }
                                    if (spawned.booleanValue()) {
                                        anySpawned = true;
                                        continue;
                                    }
                                    delay = Math.max(delay, 10);
                                }
                                if (anySpawned || numToSpawn < 1) {
                                    lure.consumeBait(rune, this.currentRuneType);
                                    this.doBiomeSpread(true);
                                } else {
                                    this.ticksToConjure = delay;
                                }
                            } else {
                                BlockCoord pos = this.findValidPosition(false);
                                if (pos != null) {
                                    INetherRune rune = this.getCurrentBlockRune(false);
                                    if (rune == null) {
                                        this.requireValidityCheck();
                                        return;
                                    }
                                    Block block = rune.blockCreated(this.currentRuneType);
                                    if (block == null) {
                                        this.requireValidityCheck();
                                        return;
                                    }
                                    this.field_145850_b.func_147465_d(pos.x, pos.y, pos.z, block, rune.blockCreatedMetadata(this.currentRuneType), 3);
                                    this.field_145850_b.func_147460_e(pos.x, pos.y, pos.z, block);
                                    MessageParticles.sendToClients(this.field_145850_b, pos.x, pos.y, pos.z, 0, 0, 0, (short)8);
                                    this.doBiomeSpread(false);
                                } else {
                                    this.ticksToConjure = 60;
                                }
                            }
                        }
                        if (this.ticksToConjure < 1) {
                            this.setNextRune();
                        } else {
                            this.markDirty(false);
                        }
                    } else {
                        int n = Math.max(5 - this.numSpeedRunes, 1);
                        if (n == 1 || this.ticksEnabled % n == 0) {
                            if (this.numCreatureRunes > 0) {
                                TileEntityDimensionLure lure = this.getDimensionLure();
                                if (lure == null) {
                                    return;
                                }
                                if (lure.consumeEssentia()) {
                                    INetherRuneCreature rune = this.getCurrentCreatureRune(false);
                                    if (rune == null) {
                                        this.requireValidityCheck();
                                        return;
                                    }
                                    lure.addBait(rune, this.currentRuneType);
                                }
                            }
                            if (nethermindNeedEssentia) {
                                for (Aspect a : this.aspects.getAspects()) {
                                    if (this.aspects.getAmount(a) <= 0 || !AspectSourceHelper.drainEssentia((TileEntity)this, (Aspect)a, (ForgeDirection)ForgeDirection.UNKNOWN, (int)12)) continue;
                                    this.aspects.reduce(a, 1);
                                    this.func_70296_d();
                                    break;
                                }
                            }
                        }
                    }
                    if (this.instability > 0 && this.ticksEnabled % 20 == 0 && this.field_145850_b.field_73012_v.nextBoolean() && this.field_145850_b.field_73012_v.nextInt(5000) < this.instability) {
                        this.instabilityDischarge(null, false);
                    }
                }
            }
        } else if (this.isEnabled()) {
            ++this.ticksEnabled;
            if (this.isConjuring() && !this.hasActiveDimensionLure() && this.ticksEnabled % 16 == 0 && this.field_145850_b.field_73012_v.nextBoolean()) {
                this.field_145850_b.func_72869_a("dripLava", (double)this.field_145851_c + 0.6, (double)this.field_145848_d - 0.02, (double)this.field_145849_e + 0.6, 0.0, 0.0, 0.0);
            }
        }
    }

    protected int lureAspectsNeeded() {
        TileEntityDimensionLure lure = this.getDimensionLure();
        return lure == null ? -1 : lure.aspects.visSize();
    }

    protected boolean spawnNetherWisp() {
        EntityWispNether entity = new EntityWispNether(this.field_145850_b);
        if (this.getNearbyEntitiesCount((Entity)entity) < MAX_NEARBY_ENTITIES) {
            return this.doSpawn(null, (Entity)entity);
        }
        return false;
    }

    protected Boolean trySpawnCreatureFromRune(INetherRuneCreature rune) {
        Entity entity = rune.entityCreated(this.currentRuneType, this.field_145850_b);
        if (entity == null) {
            return null;
        }
        if (this.getNearbyEntitiesCount(entity) >= MAX_NEARBY_ENTITIES) {
            return null;
        }
        return this.doSpawn(rune, entity);
    }

    private boolean doSpawn(INetherRuneCreature rune, Entity entity) {
        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        for (int i = 0; i < 10; ++i) {
            double x = (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextDouble() * 3.0 - this.field_145850_b.field_73012_v.nextDouble() * 3.0;
            double z = (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextDouble() * 3.0 - this.field_145850_b.field_73012_v.nextDouble() * 3.0;
            double y = this.lureMidPoint() - (double)entity.field_70131_O / 2.0;
            entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.entityCanSpawn(entityliving)) continue;
            this.spawnMob(entity);
            if (rune != null) {
                rune.onEntitySpawned(this.currentRuneType, entity);
            }
            this.field_145850_b.func_72926_e(2004, this.field_145851_c, (int)this.lureMidPoint(), this.field_145849_e, 0);
            if (entityliving != null) {
                entityliving.func_70656_aK();
                MessageParticles.sendToClients(this.field_145850_b, (int)Math.round(entity.field_70165_t), (int)Math.round(entity.field_70163_u), (int)Math.round(entity.field_70161_v), 0, 0, 0, (short)8);
            }
            return true;
        }
        return false;
    }

    private double lureMidPoint() {
        return this.dimensionLureY > -1 ? (double)(this.field_145848_d + (this.dimensionLureY + 1)) / 2.0 : (double)this.field_145848_d;
    }

    protected BlockCoord findValidPosition(boolean smallArea) {
        int z;
        int y;
        int x;
        int minX = this.field_145851_c - (smallArea ? 2 : 4);
        int maxX = this.field_145851_c + (smallArea ? 2 : 4);
        int minY = Math.max(this.field_145848_d - (smallArea ? 6 : 11), 1);
        int maxY = Math.max(this.field_145848_d - 3, 1);
        int minZ = this.field_145849_e - (smallArea ? 2 : 4);
        int maxZ = this.field_145849_e + (smallArea ? 2 : 4);
        int attempt = 0;
        do {
            if (!this.field_145850_b.func_147437_c(x = TjUtil.randInt(this.field_145850_b.field_73012_v, minX, maxX), y = TjUtil.randInt(this.field_145850_b.field_73012_v, minY, maxY), z = TjUtil.randInt(this.field_145850_b.field_73012_v, minZ, maxZ))) continue;
            return new BlockCoord(x, y, z);
        } while (++attempt < 33);
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    if (!this.field_145850_b.func_147437_c(x, y, z)) continue;
                    return new BlockCoord(x, y, z);
                }
            }
        }
        return null;
    }

    public boolean mapStructure(EntityPlayer player) {
        this.ticksSinceValidityCheck = 0;
        this.specifyingRunePos.clear();
        this.numSpeedRunes = 0;
        this.numCreatureRunes = 0;
        this.dimensionLureY = -1;
        this.minLureDistance = MIN_LURE_DISTANCE_BASE;
        if (this.mapRuneAtOffset(player, -1, 0, -1) && this.mapRuneAtOffset(player, 0, 0, -1) && this.mapRuneAtOffset(player, 1, 0, -1) && this.mapRuneAtOffset(player, -1, 0, 0) && this.mapRuneAtOffset(player, 1, 0, 0) && this.mapRuneAtOffset(player, -1, 0, 1) && this.mapRuneAtOffset(player, 0, 0, 1) && this.mapRuneAtOffset(player, 1, 0, 1) && this.mapRuneAtOffset(player, -2, 0, 0) && this.mapRuneAtOffset(player, -3, 0, 0) && this.mapRuneAtOffset(player, -3, -1, 0) && this.mapRuneAtOffset(player, 2, 0, 0) && this.mapRuneAtOffset(player, 3, 0, 0) && this.mapRuneAtOffset(player, 3, -1, 0) && this.mapRuneAtOffset(player, 0, 0, -2) && this.mapRuneAtOffset(player, 0, 0, -3) && this.mapRuneAtOffset(player, 0, -1, -3) && this.mapRuneAtOffset(player, 0, 0, 2) && this.mapRuneAtOffset(player, 0, 0, 3) && this.mapRuneAtOffset(player, 0, -1, 3)) {
            if (this.numCreatureRunes > 0) {
                if (this.numCreatureRunes < MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY) {
                    if (player != null) {
                        TjUtil.sendChatToPlayer(player, "Automagy.chat.nethermind.needMoreMobRunes");
                    }
                    return false;
                }
                boolean found = false;
                boolean lureTooClose = false;
                block0: for (int yOffset = 1; yOffset <= MAX_LURE_DISTANCE; ++yOffset) {
                    TileEntity te;
                    int y = this.field_145848_d - yOffset;
                    if (yOffset >= MIN_LURE_DISTANCE_BASE && (te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e)) != null && te instanceof TileEntityDimensionLure) {
                        if (yOffset < this.minLureDistance) {
                            lureTooClose = true;
                            break;
                        }
                        if (!((TileEntityDimensionLure)te).isEnabled()) break;
                        found = true;
                        this.dimensionLureY = y;
                        break;
                    }
                    for (int x = this.field_145851_c - 2; x <= this.field_145851_c + 2; ++x) {
                        for (int z = this.field_145849_e - 2; z <= this.field_145849_e + 2; ++z) {
                            Block block;
                            if (TjUtil.doesBlockMovement((IBlockAccess)this.field_145850_b, x, y, z) && (block = this.field_145850_b.func_147439_a(x, y, z)) != ConfigBlocks.blockFluxGoo && block != ConfigBlocks.blockFluxGas && !block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) break block0;
                        }
                    }
                }
                if (!found) {
                    if (player != null) {
                        TjUtil.sendChatToPlayer(player, "Automagy.chat.nethermind.missingLure");
                        if (lureTooClose) {
                            TjUtil.sendChatToPlayer(player, "Automagy.chat.nethermind.missingLureExtraDistance");
                        }
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean mapRuneAtOffset(EntityPlayer player, int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x += this.field_145851_c, y += this.field_145848_d, z += this.field_145849_e);
        if (block instanceof INetherRuneBase) {
            INetherRuneBase rune = (INetherRuneBase)block;
            int type = rune.getRuneType(this.field_145850_b, x, y, z);
            RuneCategory sr = rune.getRuneCategory(type);
            if (sr == RuneCategory.speed) {
                if ((float)this.numSpeedRunes < MAX_SPEED_RUNES) {
                    ++this.numSpeedRunes;
                }
            } else if (type >= 0) {
                if (sr == RuneCategory.creature) {
                    if (!(block instanceof INetherRuneCreature)) {
                        return false;
                    }
                    if (this.specifyingRunePos.size() != this.numCreatureRunes) {
                        if (player != null) {
                            TjUtil.sendChatToPlayer(player, "Automagy.chat.nethermind.invalidMix");
                        }
                        return false;
                    }
                    this.specifyingRunePos.add(new BlockCoord(x, y, z));
                    ++this.numCreatureRunes;
                    this.minLureDistance = Math.max(this.minLureDistance, ((INetherRuneCreature)block).requiredLureDistance(this.field_145850_b, x, y, z));
                } else {
                    if (!(block instanceof INetherRune)) {
                        return false;
                    }
                    if (this.numCreatureRunes > 0) {
                        if (player != null) {
                            TjUtil.sendChatToPlayer(player, "Automagy.chat.nethermind.invalidMix");
                        }
                        return false;
                    }
                    this.specifyingRunePos.add(new BlockCoord(x, y, z));
                }
            }
            return true;
        }
        return false;
    }

    public TileEntityDimensionLure getDimensionLure() {
        if (this.dimensionLureY >= 0) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.dimensionLureY, this.field_145849_e);
            if (te instanceof TileEntityDimensionLure) {
                return (TileEntityDimensionLure)te;
            }
            this.requireValidityCheck();
        }
        return null;
    }

    public boolean hasActiveDimensionLure() {
        if (this.dimensionLureY == -1) {
            for (int yOffset = MIN_LURE_DISTANCE_BASE; yOffset <= MAX_LURE_DISTANCE; ++yOffset) {
                int y = this.field_145848_d - yOffset;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
                if (te == null || !(te instanceof TileEntityDimensionLure)) continue;
                if (!((TileEntityDimensionLure)te).isEnabled()) {
                    this.dimensionLureY = -2;
                    return false;
                }
                this.dimensionLureY = y;
                return true;
            }
            this.dimensionLureY = -2;
            return false;
        }
        return this.dimensionLureY != -2;
    }

    public boolean tryEnable(EntityPlayer player) {
        if (!this.isEnabled()) {
            if (this.field_145848_d < MIN_Y) {
                if (player != null) {
                    TjUtil.sendChatToPlayer(player, "Automagy.chat.nethermind.yTooLow");
                }
            } else if (this.mapStructure(player)) {
                this.ticksEnabled = 0;
                this.ticksToConjure = -1;
                this.markDirty(false);
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:craftstart", 1.0f, 1.0f);
                MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0, 0, (short)2);
                return true;
            }
        }
        return false;
    }

    public boolean tryDisable() {
        if (this.isEnabled() && this.ticksEnabled > TICKS_BEFORE_ALLOW_DISABLE) {
            this.aspects.aspects.clear();
            this.poweredTime = 0;
            this.markDirty(false);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.deactivateRune(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
            this.currentRuneY = -1;
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:craftfail", 1.0f, 1.0f);
            TileEntityDimensionLure lure = this.getDimensionLure();
            if (lure != null) {
                lure.clearActiveRune();
            }
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.func_145832_p() == 1;
    }

    public boolean isConjuring() {
        if (this.poweredTime > 0 && this.ticksToConjure > 0 && this.isEnabled() && this.aspects.visSize() == 0) {
            if (this.hasActiveDimensionLure()) {
                TileEntityDimensionLure lure = this.getDimensionLure();
                if (lure == null) {
                    this.dimensionLureY = -1;
                    return false;
                }
                return lure.aspects.visSize() == 0;
            }
            return true;
        }
        return false;
    }

    public Block getBlockConjuring() {
        INetherRune rune = this.getCurrentBlockRune(false);
        return rune.blockCreated(this.currentRuneType);
    }

    public void activateRune() {
        Block block;
        if (this.currentRuneType >= 0 && this.currentRuneY >= 0 && (block = this.field_145850_b.func_147439_a(this.currentRuneX, this.currentRuneY, this.currentRuneZ)) instanceof INetherRuneBase) {
            ((INetherRuneBase)block).activateRune(this.field_145850_b, this.currentRuneX, this.currentRuneY, this.currentRuneZ, this.currentRuneType);
        }
    }

    public void deactivateRune(int x, int y, int z) {
        Block block;
        if (this.currentRuneType >= 0 && y >= 0 && (block = this.field_145850_b.func_147439_a(x, y, z)) instanceof INetherRuneBase) {
            ((INetherRuneBase)block).deactivateRune(this.field_145850_b, x, y, z, this.currentRuneType);
        }
    }

    public void setNextRune() {
        int r;
        int prevX = this.currentRuneX;
        int prevY = this.currentRuneY;
        int prevZ = this.currentRuneZ;
        this.aspects.aspects.clear();
        int size = this.specifyingRunePos.size();
        if (size < MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY && (r = this.field_145850_b.field_73012_v.nextInt(MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY)) + 1 > size) {
            this.deactivateRune(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
            this.currentRuneY = -1;
            this.currentRuneType = ModBlocks.runedObsidian.getRandomBasicRuneType(this.field_145850_b.field_73012_v);
            this.ticksToConjure = this.getTicksToConjure(ModBlocks.runedObsidian, this.currentRuneType);
            this.aspects = ModBlocks.runedObsidian.essentiaCostPerCreation(this.currentRuneType).copy();
            this.func_70296_d();
            return;
        }
        int item = this.field_145850_b.field_73012_v.nextInt(size);
        int i = 0;
        for (BlockCoord bc : this.specifyingRunePos) {
            if (i == item) {
                this.currentRuneX = bc.x;
                this.currentRuneY = bc.y;
                this.currentRuneZ = bc.z;
                INetherRuneBase rune = this.getCurrentRune(true);
                if (rune == null) {
                    this.deactivateRune(prevX, prevY, prevZ);
                    this.requireValidityCheck();
                    this.markDirty(false);
                    return;
                }
                this.currentRuneType = rune.getRuneType(this.field_145850_b, this.currentRuneX, this.currentRuneY, this.currentRuneZ);
                this.ticksToConjure = this.getTicksToConjure(rune, this.currentRuneType);
                AspectList aspectsCost = rune.essentiaCostPerCreation(this.currentRuneType);
                if (aspectsCost == null) {
                    this.deactivateRune(prevX, prevY, prevZ);
                    this.requireValidityCheck();
                    this.markDirty(false);
                    return;
                }
                if (this.numCreatureRunes > 0 && rune instanceof INetherRuneCreature) {
                    TileEntityDimensionLure lure = this.getDimensionLure();
                    if (lure == null) {
                        this.deactivateRune(prevX, prevY, prevZ);
                        this.requireValidityCheck();
                        this.markDirty(false);
                        return;
                    }
                    lure.setActiveRune((INetherRuneCreature)rune, this.currentRuneType);
                    this.didInstabilityCheckThisSummon = false;
                }
                this.aspects = aspectsCost.copy();
                this.func_70296_d();
                if (prevX != this.currentRuneX || prevY != this.currentRuneY || prevZ != this.currentRuneZ) {
                    this.deactivateRune(prevX, prevY, prevZ);
                    this.activateRune();
                }
                return;
            }
            ++i;
        }
    }

    private int getTicksToConjure(INetherRuneBase rune, int runeType) {
        int ticksToConjure = rune.ticksUntilCreated(runeType);
        if (ticksToConjure > 0) {
            int t = ticksToConjure;
            if (this.numSpeedRunes > 0) {
                float f = (float)ticksToConjure * SPEED_RUNE_MULTIPLIER * (float)this.numSpeedRunes;
                ticksToConjure = Math.max(Math.round((float)ticksToConjure - f), 1);
            }
        }
        return ticksToConjure;
    }

    public INetherRune getCurrentBlockRune(boolean ignoreCurrentType) {
        if (!ignoreCurrentType && this.currentRuneType < 0) {
            return ModBlocks.runedObsidian;
        }
        Block block = this.field_145850_b.func_147439_a(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
        if (block instanceof INetherRune) {
            return (INetherRune)block;
        }
        return null;
    }

    public INetherRuneCreature getCurrentCreatureRune(boolean ignoreCurrentType) {
        if (!ignoreCurrentType && this.currentRuneType < 0) {
            return null;
        }
        Block block = this.field_145850_b.func_147439_a(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
        if (block instanceof INetherRuneCreature) {
            return (INetherRuneCreature)block;
        }
        return null;
    }

    public INetherRuneBase getCurrentRune(boolean ignoreCurrentType) {
        return this.numCreatureRunes > 0 ? this.getCurrentCreatureRune(ignoreCurrentType) : this.getCurrentBlockRune(ignoreCurrentType);
    }

    public int getNearbyEntitiesCount(Entity entity) {
        double x = this.field_145851_c;
        double y = (double)(this.field_145848_d + (this.dimensionLureY + 1)) / 2.0;
        double z = this.field_145849_e;
        int range = 6;
        return this.field_145850_b.func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)).func_72314_b((double)range, 4.0, (double)range)).size();
    }

    public boolean entityCanSpawn(EntityLiving entity) {
        return entity.field_70170_p.func_72855_b(entity.field_70121_D) && entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D);
    }

    public void doBiomeSpread(boolean nether) {
        if (this.field_145850_b.field_73011_w.field_76574_g != -1 && this.field_145850_b.field_73012_v.nextInt(100) < EERIE_SPREAD_CHANCE) {
            BiomeGenBase bg;
            int z;
            int x;
            if (nether && !TjUtil.isBiomeAt(this.field_145850_b, x = this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(8) - this.field_145850_b.field_73012_v.nextInt(8), z = this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(8) - this.field_145850_b.field_73012_v.nextInt(8), BiomeGenBase.field_76778_j)) {
                ThaumcraftExtension.setBiomeTo(this.field_145850_b, x, z, BiomeGenBase.field_76778_j);
            }
            if (!(ThaumcraftExtension.isBiomeEerie(bg = this.field_145850_b.func_72807_a(x = this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(12) - this.field_145850_b.field_73012_v.nextInt(12), z = this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(12) - this.field_145850_b.field_73012_v.nextInt(12))) || nether && TjUtil.isBiomeAt(this.field_145850_b, x, z, BiomeGenBase.field_76778_j))) {
                ThaumcraftExtension.setBiomeToEerie(this.field_145850_b, x, z);
            }
        }
    }

    public void instabilityBuildup(int modifier) {
        int change;
        if (this.instability < 1000 && (change = INSTABILITY_PER_SUMMON + INSTABILITY_PER_SPEED_RUNE * this.numSpeedRunes - modifier) > 0) {
            this.instability += change;
            if (this.instability > 1000) {
                this.instability = 1000;
            }
            this.markDirty(false);
        }
    }

    public boolean instabilityDischarge(INetherRuneCreature rune, boolean spawning) {
        int amt;
        boolean preventSummon = false;
        if (spawning && this.instability >= INSTABILITY_LEVEL_DESTROY_SUMMONED) {
            if (this.field_145850_b.field_73012_v.nextInt(this.instability) > INSTABILITY_LEVEL_DESTROY_SUMMONED / 2) {
                Entity entity;
                int z;
                int y;
                int x;
                BlockCoord bc;
                amt = INSTABILITY_LEVEL_DESTROY_SUMMONED;
                TileEntityDimensionLure lure = this.getDimensionLure();
                if (lure != null && (amt += lure.getStabilityModifiers()) > this.instability) {
                    amt = this.instability - 1;
                }
                preventSummon = true;
                BlockCoord blockCoord = bc = this.field_145850_b.field_73012_v.nextInt(3) == 0 ? this.makeFluxGoo() : this.makeFluxGas();
                if (bc == null) {
                    x = this.field_145851_c;
                    y = (int)this.lureMidPoint();
                    z = this.field_145849_e;
                } else {
                    x = bc.x;
                    y = bc.y;
                    z = bc.z;
                }
                MessageParticles.sendToClients(this.field_145850_b, x, y, z, 0, 0, 0, (short)8);
                if (rune != null && (entity = rune.entityCreated(this.currentRuneType, this.field_145850_b)) instanceof EntityLiving) {
                    float pitch = 0.4f + this.field_145850_b.field_73012_v.nextFloat() / 3.0f;
                    TjUtil.playDeathSound((EntityLiving)entity, this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, pitch);
                }
            } else {
                amt = 1;
            }
        } else {
            amt = this.field_145850_b.field_73012_v.nextInt(Math.min(this.instability, 10)) + 1;
        }
        this.instability -= amt;
        this.markDirty(false);
        if (preventSummon) {
            return true;
        }
        this.instabilityEffect(false);
        return false;
    }

    public void instabilityEffect(boolean lowCap) {
        int r = this.field_145850_b.field_73012_v.nextInt(21);
        if (r < 10) {
            this.zapNothing();
        } else if (r < 15) {
            if (!this.zapPlayer(false)) {
                this.zapNothing();
            }
        } else if (r < 17) {
            if (!this.zapPlayer(true)) {
                this.unstableExplosion();
            }
        } else if (lowCap || r < 19) {
            this.unstableExplosion();
        } else if (r == 19) {
            if (this.instability < 100 || this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                this.instabilityEffect(true);
            } else {
                TileEntityDimensionLure lure = this.getDimensionLure();
                if (lure != null && lure.getStabilityModifiers() < 20 && !this.spawnNetherWisp()) {
                    this.instabilityEffect(true);
                }
            }
        } else {
            this.instabilityEffect(true);
            this.instabilityEffect(true);
        }
    }

    protected BlockCoord makeFluxGas() {
        BlockCoord bc = this.findValidPosition(true);
        if (bc != null) {
            this.field_145850_b.func_147465_d(bc.x, bc.y, bc.z, ConfigBlocks.blockFluxGas, 7, 3);
            this.field_145850_b.func_72908_a((double)bc.x, (double)bc.y, (double)bc.z, "random.fizz", 0.3f, 1.0f);
        }
        return bc;
    }

    protected BlockCoord makeFluxGoo() {
        BlockCoord bc = this.findValidPosition(true);
        if (bc != null) {
            this.field_145850_b.func_147465_d(bc.x, bc.y, bc.z, ConfigBlocks.blockFluxGoo, 7, 3);
            this.field_145850_b.func_72908_a((double)bc.x, (double)bc.y, (double)bc.z, "game.neutral.swim", 0.3f, 1.0f);
        }
        return bc;
    }

    protected void unstableExplosion() {
        double y = (int)this.lureMidPoint() + this.field_145850_b.field_73012_v.nextInt(3) - this.field_145850_b.field_73012_v.nextInt(3);
        int x = this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(4) - this.field_145850_b.field_73012_v.nextInt(4);
        int z = this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(4) - this.field_145850_b.field_73012_v.nextInt(4);
        this.field_145850_b.func_72876_a(null, (double)((float)x + 0.5f), y, (double)((float)z + 0.5f), 1.0f, false);
    }

    protected void zapNothing() {
        float sourceY = (float)(this.field_145850_b.field_73012_v.nextBoolean() ? this.field_145848_d : this.dimensionLureY) + 0.5f;
        float x = (float)this.field_145851_c + 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 8.0f - this.field_145850_b.field_73012_v.nextFloat() * 8.0f;
        float y = sourceY + this.field_145850_b.field_73012_v.nextFloat() * 5.0f - this.field_145850_b.field_73012_v.nextFloat() * 5.0f;
        float z = (float)this.field_145849_e + 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 8.0f - this.field_145850_b.field_73012_v.nextFloat() * 8.0f;
        ThaumcraftExtension.zapLocation(this.field_145850_b, this.field_145851_c, sourceY, this.field_145849_e, x, y, z);
    }

    protected boolean zapPlayer(boolean all) {
        List targets = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.dimensionLureY, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(10.0, 10.0, 10.0));
        if (targets != null && targets.size() > 0) {
            if (all) {
                for (EntityPlayer target : targets) {
                    this.zapEntity((Entity)target);
                }
            } else {
                EntityPlayer target = (EntityPlayer)targets.get(this.field_145850_b.field_73012_v.nextInt(targets.size()));
                this.zapEntity((Entity)target);
            }
            return true;
        }
        return false;
    }

    private void zapEntity(Entity target) {
        double d2;
        double d1 = TjUtil.getDistanceBetweenPoints_squared((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, target.field_70165_t, target.field_70163_u, target.field_70161_v);
        ThaumcraftExtension.zapEntity(target, this.field_145850_b, this.field_145851_c, d1 < (d2 = TjUtil.getDistanceBetweenPoints_squared((double)this.field_145851_c + 0.5, (double)this.dimensionLureY + 0.5, (double)this.field_145849_e + 0.5, target.field_70165_t, target.field_70163_u, target.field_70161_v)) ? this.field_145848_d : this.dimensionLureY, this.field_145849_e);
    }

    public Entity spawnMob(Entity entity) {
        if (entity instanceof EntityLivingBase && entity.field_70170_p != null) {
            ((EntityLiving)entity).func_110161_a((IEntityLivingData)null);
            this.field_145850_b.func_72838_d(entity);
        }
        return entity;
    }

    public void requireValidityCheck() {
        this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.readFromNBT(nbttagcompound);
        this.currentRuneX = nbttagcompound.func_74762_e("currentRuneX");
        this.currentRuneY = nbttagcompound.func_74762_e("currentRuneY");
        this.currentRuneZ = nbttagcompound.func_74762_e("currentRuneZ");
        this.currentRuneType = nbttagcompound.func_74762_e("currentRuneType");
        this.ticksToConjure = nbttagcompound.func_74762_e("ticksToConjure");
        this.poweredTime = nbttagcompound.func_74762_e("poweredTime");
        this.instability = nbttagcompound.func_74762_e("instability");
        this.didInstabilityCheckThisSummon = nbttagcompound.func_74767_n("instabilityChecked");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.dimensionLureY = -1;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("currentRuneX", this.currentRuneX);
        nbttagcompound.func_74768_a("currentRuneY", this.currentRuneY);
        nbttagcompound.func_74768_a("currentRuneZ", this.currentRuneZ);
        nbttagcompound.func_74768_a("currentRuneType", this.currentRuneType);
        nbttagcompound.func_74768_a("ticksToConjure", this.ticksToConjure);
        nbttagcompound.func_74768_a("poweredTime", this.poweredTime);
        nbttagcompound.func_74768_a("instability", this.instability);
        nbttagcompound.func_74757_a("instabilityChecked", this.didInstabilityCheckThisSummon);
    }
}

