/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks.fluid;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSlimyBubble;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.WarpEvents;
import thaumcraft.common.lib.potions.PotionBlurredVision;
import thaumcraft.common.lib.potions.PotionWarpWard;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.blocks.fluid.ModBlockFluid;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.network.MessageSound;

public class BlockFluidVishroom
extends ModBlockFluid {
    public static int INTERVAL = 60;
    public static int MYCELIUM_FROM_STACK_RATE = 20;
    public static int MOOSHROOM_TRANSFORM_TIME = 1200;
    public static int WARPING_REMOVES_CHANCE = 8;
    public static int POOF_CHANCE_MYCELIUM_ITEM = 5;
    public static int POOF_CHANCE_MYCELIUM_BLOCK = 6;

    public BlockFluidVishroom(String name) {
        super(name, ModBlocks.fluidVishroom, Material.field_151586_h);
        this.func_149713_g(5);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K) {
            if (entity instanceof EntityLivingBase) {
                NBTTagCompound data = entity.getEntityData();
                Long t = world.func_82737_E();
                if (t - data.func_74763_f("fluidVishroomTimer") >= (long)INTERVAL) {
                    EntityPlayer player;
                    data.func_74772_a("fluidVishroomTimer", t.longValue());
                    EntityLivingBase e = (EntityLivingBase)entity;
                    EntityPlayer entityPlayer = player = e instanceof EntityPlayer ? (EntityPlayer)entity : null;
                    if (!e.func_70644_a(Potion.field_76437_t)) {
                        e.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 1));
                    } else if (player != null && !e.func_70644_a((Potion)PotionBlurredVision.instance)) {
                        e.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 1));
                        e.func_70690_d(new PotionEffect(PotionBlurredVision.instance.field_76415_H, 200, 1));
                    } else {
                        e.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 1));
                        if (world.field_73012_v.nextInt(10) == 0) {
                            if (e instanceof EntityMooshroom) {
                                e.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 320, 0));
                            } else {
                                e.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 80, 2));
                            }
                        }
                        if (player != null) {
                            player.func_70690_d(new PotionEffect(PotionBlurredVision.instance.field_76415_H, 200, 1));
                        }
                    }
                    if (player != null && this.isSourceBlock((IBlockAccess)world, x, y, z)) {
                        player.func_82170_o(PotionWarpWard.instance.field_76415_H);
                        if (!Config.wuss) {
                            int diff;
                            boolean doWarpCheck = false;
                            boolean usedUp = false;
                            int warp = ThaumcraftExtension.getTemporaryWarp(player) + ThaumcraftExtension.getStickyWarp(player);
                            if (t - data.func_74763_f("fluidVishroomWarpTimer") <= (long)INTERVAL && (diff = warp - data.func_74762_e("fluidVishroomWarpSeen")) > 0) {
                                warp += diff;
                                doWarpCheck = true;
                                boolean playedSound = false;
                                for (int i = 1; i <= diff; ++i) {
                                    if (world.field_73012_v.nextInt(WARPING_REMOVES_CHANCE) != 0) continue;
                                    usedUp = true;
                                    break;
                                }
                                if (world.field_73012_v.nextInt(4) == 0) {
                                    Thaumcraft.addStickyWarpToPlayer((EntityPlayer)player, (int)1);
                                    playedSound = true;
                                    --diff;
                                }
                                if (diff > 0) {
                                    Thaumcraft.addWarpToPlayer((EntityPlayer)player, (int)diff, (boolean)true);
                                    if (!playedSound) {
                                        MessageSound.sendToClient(player, (short)0);
                                    }
                                }
                                player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 600, 1));
                            }
                            data.func_74772_a("fluidVishroomWarpTimer", t.longValue());
                            data.func_74768_a("fluidVishroomWarpSeen", warp);
                            if (doWarpCheck || world.field_73012_v.nextInt(60) == 0) {
                                if (!doWarpCheck) {
                                    ThaumcraftExtension.resetWarpCounter(player);
                                }
                                WarpEvents.checkWarpEvent((EntityPlayer)player);
                            }
                            if (usedUp) {
                                MessageParticles.sendToClients(world, x, y, z, 300, 0, 0, (short)2);
                                MessageParticles.sendToClients(world, x, y, z, 50, 0, 0, (short)3);
                                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                                this.poof(world, x, y, z);
                                return;
                            }
                        }
                    }
                }
                if (entity instanceof EntityCow && !(entity instanceof EntityMooshroom) && !entity.field_70128_L && this.isSourceBlock((IBlockAccess)world, x, y, z)) {
                    int c = data.func_74762_e("fluidVishroomCowTime");
                    if (c >= MOOSHROOM_TRANSFORM_TIME) {
                        EntityMooshroom mooshroom = BlockFluidVishroom.turnCowIntoMooshroom((EntityCow)entity);
                        mooshroom.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 320, 0));
                        this.poof(world, x, y, z);
                        if (world.func_147437_c(x, y + 1, z)) {
                            this.poof(world, x, y + 1, z);
                        }
                        return;
                    }
                    data.func_74768_a("fluidVishroomCowTime", c + 1);
                    if (c % 25 == 0) {
                        MessageParticles.sendToClients(world, x, y, z, 100, 0, 0, (short)2);
                    }
                }
            } else if (entity instanceof EntityItem && this.isSourceBlock((IBlockAccess)world, x, y, z)) {
                NBTTagCompound data = entity.getEntityData();
                Long t = world.func_82737_E();
                if (t - data.func_74763_f("fluidVishroomTimer") >= (long)MYCELIUM_FROM_STACK_RATE) {
                    data.func_74772_a("fluidVishroomTimer", t.longValue());
                    EntityItem item = (EntityItem)entity;
                    ItemStack stack = item.func_92059_d();
                    if (TjUtil.areItemsEqualIgnoringSize(stack, new ItemStack((Block)Blocks.field_150349_c))) {
                        if (stack.field_77994_a > 1) {
                            --stack.field_77994_a;
                            item.func_92058_a(stack);
                        } else {
                            item.func_70106_y();
                        }
                        EntityItem newItem = TjUtil.dropItemIntoWorldSimple(new ItemStack((Block)Blocks.field_150391_bh), world, x, y, z);
                        newItem.field_70181_x += 0.25;
                        newItem.field_70159_w *= (double)0.1f;
                        newItem.field_70179_y *= (double)0.1f;
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                        MessageParticles.sendToClients(world, x, y, z, 0, 0, 0, (short)2);
                        if (world.field_73012_v.nextInt(POOF_CHANCE_MYCELIUM_ITEM) == 0) {
                            this.poof(world, x, y, z);
                            return;
                        }
                    }
                }
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.isSourceBlock((IBlockAccess)world, x, y, z)) {
            if (rand.nextInt(5) == 0) {
                boolean didSpread = false;
                int r = rand.nextInt(10);
                if (r < 6) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(r < 6 ? r : r - 4));
                    didSpread = this.doSpread(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, world.field_73012_v, 0);
                } else {
                    switch (r) {
                        case 6: {
                            didSpread = this.doSpread(world, x + 1, y, z + 1, world.field_73012_v, 0);
                            break;
                        }
                        case 7: {
                            didSpread = this.doSpread(world, x + 1, y, z - 1, world.field_73012_v, 0);
                            break;
                        }
                        case 8: {
                            didSpread = this.doSpread(world, x - 1, y, z - 1, world.field_73012_v, 0);
                            break;
                        }
                        case 9: {
                            didSpread = this.doSpread(world, x - 1, y, z + 1, world.field_73012_v, 0);
                        }
                    }
                }
                if (didSpread && rand.nextInt(POOF_CHANCE_MYCELIUM_BLOCK) == 0) {
                    this.poof(world, x, y, z);
                    return;
                }
            }
            world.func_147464_a(x, y, z, (Block)this, this.tickRate);
        }
        super.func_149674_a(world, x, y, z, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (!this.isSourceBlock((IBlockAccess)world, x, y, z)) {
            return;
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        List list = world.func_72872_a(EntityLivingBase.class, box);
        if (list.size() == 0) {
            return;
        }
        float h = rand.nextFloat() * 0.075f;
        FXSlimyBubble ef = new FXSlimyBubble(world, (double)((float)x + rand.nextFloat()), (double)((float)y + 0.1f), (double)((float)z + rand.nextFloat()), 0.075f + h);
        ef.func_82338_g(0.8f);
        ef.func_70538_b(1.0f, 0.28f, 0.53f);
        ParticleEngine.instance.addEffect(world, (EntityFX)ef);
        if (rand.nextInt(8) == 0) {
            double var21 = (float)x + rand.nextFloat();
            double var22 = (double)y + this.field_149756_F;
            double var23 = (float)z + rand.nextFloat();
            world.func_72980_b(var21, var22, var23, "liquid.lavapop", 0.1f + rand.nextFloat() * 0.1f, 0.9f + rand.nextFloat() * 0.15f, false);
        }
    }

    private boolean doSpread(World world, int x, int y, int z, Random rand, int count) {
        Block block = world.func_147439_a(x, y, z);
        if (block == this) {
            if (count > 2) {
                return false;
            }
            if (this.isSourceBlock((IBlockAccess)world, x, y, z)) {
                return false;
            }
            int r = rand.nextInt(10);
            ForgeDirection dir = ForgeDirection.getOrientation((int)(r < 6 ? r : r - 4));
            if (r < 6) {
                return this.doSpread(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, world.field_73012_v, count + 1);
            }
            return this.doSpread(world, x + dir.offsetX + (rand.nextInt(3) - 1), y + dir.offsetY, z + dir.offsetZ + (rand.nextInt(3) - 1), world.field_73012_v, count + 1);
        }
        if (block == Blocks.field_150349_c) {
            Block block2 = world.func_147439_a(x, y + 1, z);
            if (block2 == Blocks.field_150329_H || block2 == Blocks.field_150398_cm || block2 == Blocks.field_150328_O || block2 == Blocks.field_150327_N || world.func_147437_c(x, y + 1, z) && rand.nextInt(8) == 0) {
                world.func_147449_b(x, y + 1, z, (Block)(rand.nextBoolean() ? Blocks.field_150337_Q : Blocks.field_150338_P));
                MessageParticles.sendToClients(world, x, y + 1, z, 0, 0, 0, (short)2);
            }
            world.func_147449_b(x, y, z, (Block)Blocks.field_150391_bh);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            MessageParticles.sendToClients(world, x, y, z, 0, 0, 0, (short)2);
            return true;
        }
        if (block == Blocks.field_150329_H || block == Blocks.field_150398_cm || block == Blocks.field_150328_O || block == Blocks.field_150327_N) {
            BlockBush mushroom;
            BlockBush blockBush = mushroom = rand.nextBoolean() ? Blocks.field_150337_Q : Blocks.field_150338_P;
            if (mushroom.func_149718_j(world, x, y, z)) {
                world.func_147449_b(x, y, z, (Block)mushroom);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                MessageParticles.sendToClients(world, x, y, z, 0, 0, 0, (short)2);
            } else {
                return this.doSpread(world, x, y - 1, z, rand, count + 1);
            }
        }
        return false;
    }

    private void poof(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, ConfigBlocks.blockFluxGas);
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x - 0.5), (double)((double)y - 0.1), (double)((double)z - 0.5), (double)((double)x + 1.5), (double)((double)y + 1.1), (double)((double)z + 1.5));
        List list = world.func_72872_a(EntityPlayer.class, box);
        for (EntityPlayer player : list) {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 180, 1));
        }
    }

    public static EntityMooshroom turnCowIntoMooshroom(EntityCow cow) {
        cow.func_70106_y();
        EntityMooshroom mooshroom = new EntityMooshroom(cow.field_70170_p);
        mooshroom.func_70012_b(cow.field_70165_t, cow.field_70163_u, cow.field_70161_v, cow.field_70177_z, cow.field_70125_A);
        mooshroom.func_70606_j(cow.func_110143_aJ());
        mooshroom.field_70761_aq = cow.field_70761_aq;
        cow.field_70170_p.func_72838_d((Entity)mooshroom);
        cow.field_70170_p.func_72869_a("largeexplode", cow.field_70165_t, cow.field_70163_u + (double)(cow.field_70131_O / 2.0f), cow.field_70161_v, 0.0, 0.0, 0.0);
        cow.func_85030_a("random.fizz", 0.5f, 2.6f + (cow.field_70170_p.field_73012_v.nextFloat() - cow.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        MessageParticles.sendToClients(cow.field_70170_p, (int)cow.field_70165_t, (int)cow.field_70163_u, (int)cow.field_70161_v, 0, 0, 0, (short)3);
        return mooshroom;
    }
}

