/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.entities.monster.EntityFireBat;
import tuhljin.automagy.api.nethermind.INetherRuneCreature;
import tuhljin.automagy.api.nethermind.RuneCategory;
import tuhljin.automagy.blocks.ItemBlockNetherRune;
import tuhljin.automagy.blocks.ModBlock;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.entities.EntityWispNether;
import tuhljin.automagy.lib.AutomagyConfig;

public class BlockNetherRuneCreature
extends ModBlock
implements INetherRuneCreature {
    public static final int BLAZE_NORMAL_ID = 1;
    public static final int BLAZE_EXTRA_ID = 21;
    public static int BLAZE_EXTRA_CHANCE = 10;
    public static int INSTABILITY_BLAZE_EXTRA = 200;
    public static int INSTABILITY_GHAST = 200;
    public static int INSTABILITY_SKELETON = 50;
    public static int INSTABILITY_WISP = 375;
    public static int ZOMBIE_ANGRY_CHANCE = 20;
    private IIcon[] secondaryIconsDim;
    private IIcon[] secondaryIconsActive;
    private static Method becomeAngryAt = null;

    public BlockNetherRuneCreature(String name) {
        super(name, ModBlocks.materialNiceStone, ItemBlockNetherRune.class);
        this.func_149752_b(2000.0f);
        this.func_149658_d("Automagy:blockNetherRune");
    }

    public MapColor func_149728_f(int p_149728_1_) {
        return MapColor.field_151654_J;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 6));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.secondaryIconsActive = new IIcon[8];
        this.secondaryIconsActive[0] = ir.func_94245_a(this.field_149768_d + "Zombie");
        this.secondaryIconsActive[1] = ir.func_94245_a(this.field_149768_d + "Blaze");
        this.secondaryIconsActive[2] = ir.func_94245_a(this.field_149768_d + "Ghast");
        this.secondaryIconsActive[3] = ir.func_94245_a(this.field_149768_d + "Skull");
        this.secondaryIconsActive[4] = ir.func_94245_a(this.field_149768_d + "Slime");
        this.secondaryIconsActive[5] = ir.func_94245_a(this.field_149768_d + "Bat");
        this.secondaryIconsActive[6] = ir.func_94245_a(this.field_149768_d + "Wisp");
        this.secondaryIconsDim = new IIcon[8];
        this.secondaryIconsDim[0] = ir.func_94245_a(this.field_149768_d + "ZombieDim");
        this.secondaryIconsDim[1] = ir.func_94245_a(this.field_149768_d + "BlazeDim");
        this.secondaryIconsDim[2] = ir.func_94245_a(this.field_149768_d + "GhastDim");
        this.secondaryIconsDim[3] = ir.func_94245_a(this.field_149768_d + "SkullDim");
        this.secondaryIconsDim[4] = ir.func_94245_a(this.field_149768_d + "SlimeDim");
        this.secondaryIconsDim[5] = ir.func_94245_a(this.field_149768_d + "BatDim");
        this.secondaryIconsDim[6] = ir.func_94245_a(this.field_149768_d + "WispDim");
        this.field_149761_L = this.secondaryIconsActive[0];
    }

    public int func_149692_a(int metadata) {
        return metadata > 7 ? metadata - 8 : metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int meta = blockaccess.func_72805_g(x, y, z);
        if (meta > 7) {
            return this.secondaryIconsActive[meta - 8];
        }
        return this.secondaryIconsDim[meta];
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            return this.field_149761_L;
        }
        if (meta > 7) {
            return this.secondaryIconsActive[meta - 8];
        }
        return this.secondaryIconsActive[meta];
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public RuneCategory getRuneCategory(int runeType) {
        return RuneCategory.creature;
    }

    @Override
    public int getRuneType(World world, int x, int y, int z) {
        int type = this.getBaseRuneType(world, x, y, z);
        if (type == 1 && world.field_73012_v.nextInt(BLAZE_EXTRA_CHANCE) == 0) {
            return 21;
        }
        return type;
    }

    private int getBaseRuneType(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta > 7 ? meta - 8 : meta;
    }

    @Override
    public Entity entityCreated(int runeType, World world) {
        switch (runeType) {
            case 0: {
                return new EntityPigZombie(world);
            }
            case 1: 
            case 21: {
                return new EntityBlaze(world);
            }
            case 2: {
                return new EntityGhast(world);
            }
            case 3: {
                return new EntitySkeleton(world);
            }
            case 4: {
                return new EntityMagmaCube(world);
            }
            case 5: {
                return new EntityFireBat(world);
            }
            case 6: {
                return new EntityWispNether(world);
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRuneCreature entityCreated: Invalid runeType.", (Object[])new Object[0]);
        return null;
    }

    @Override
    public int ticksUntilCreated(int runeType) {
        return AutomagyConfig.nethermindSpawnerSpeed;
    }

    @Override
    public AspectList essentiaCostPerCreation(int runeType) {
        switch (runeType) {
            case 0: {
                return AutomagyConfig.nethermindZombiePigmanCost;
            }
            case 1: 
            case 21: {
                return AutomagyConfig.nethermindBlazeCost;
            }
            case 2: {
                return AutomagyConfig.nethermindGhastCost;
            }
            case 3: {
                return AutomagyConfig.nethermindSkeletonCost;
            }
            case 4: {
                return AutomagyConfig.nethermindSlimeCost;
            }
            case 5: {
                return AutomagyConfig.nethermindBatCost;
            }
            case 6: {
                return AutomagyConfig.nethermindWispCost;
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRuneCreature essentiaCostPerBlockCreated: Invalid runeType.", (Object[])new Object[0]);
        return null;
    }

    @Override
    public void activateRune(World world, int x, int y, int z, int runeType) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 8) {
            world.func_72921_c(x, y, z, meta + 8, 3);
        }
    }

    @Override
    public void deactivateRune(World world, int x, int y, int z, int runeType) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 7) {
            world.func_72921_c(x, y, z, meta - 8, 3);
        }
    }

    @Override
    public int getInstability(int runeType) {
        switch (runeType) {
            case 21: {
                return INSTABILITY_BLAZE_EXTRA;
            }
            case 2: {
                return INSTABILITY_GHAST;
            }
            case 3: {
                return INSTABILITY_SKELETON;
            }
            case 6: {
                return INSTABILITY_WISP;
            }
        }
        return 0;
    }

    @Override
    public AspectList secondaryEssentiaCost(int runeType) {
        switch (runeType) {
            case 0: {
                return AutomagyConfig.dimLureZombiePigmanCost;
            }
            case 1: 
            case 21: {
                return AutomagyConfig.dimLureBlazeCost;
            }
            case 2: {
                return AutomagyConfig.dimLureGhastCost;
            }
            case 3: {
                return AutomagyConfig.dimLureSkeletonCost;
            }
            case 4: {
                return AutomagyConfig.dimLureSlimeCost;
            }
            case 5: {
                return AutomagyConfig.dimLureBatCost;
            }
            case 6: {
                return AutomagyConfig.dimLureWispCost;
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRuneCreature secondaryEssentiaCost: Invalid runeType.", (Object[])new Object[0]);
        return null;
    }

    @Override
    public int secondaryEssentiaCostUses(int runeType) {
        switch (runeType) {
            case 0: {
                return AutomagyConfig.dimLureZombiePigmanUses;
            }
            case 1: 
            case 21: {
                return AutomagyConfig.dimLureBlazeUses;
            }
            case 2: {
                return AutomagyConfig.dimLureGhastUses;
            }
            case 3: {
                return AutomagyConfig.dimLureSkeletonUses;
            }
            case 4: {
                return AutomagyConfig.dimLureSlimeUses;
            }
            case 5: {
                return AutomagyConfig.dimLureBatUses;
            }
            case 6: {
                return AutomagyConfig.dimLureWispUses;
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRuneCreature secondaryEssentiaCostUses: Invalid runeType.", (Object[])new Object[0]);
        return 2;
    }

    @Override
    public int getSpawnCount(int runeType) {
        return runeType == 21 ? 2 : 1;
    }

    @Override
    public String getEntityIdentifier(int runeType) {
        switch (runeType) {
            case 0: {
                return "PigZombie";
            }
            case 1: 
            case 21: {
                return "Blaze";
            }
            case 2: {
                return "Ghast";
            }
            case 3: {
                return "Skeleton";
            }
            case 4: {
                return "LavaSlime";
            }
            case 5: {
                return "Firebat";
            }
            case 6: {
                return "WispNether";
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRuneCreature getMobIdentifier: Invalid runeType.", (Object[])new Object[0]);
        return "unknown";
    }

    @Override
    public void onEntitySpawned(int runeType, Entity entity) {
        EntitySkeleton skeleton;
        if (runeType == 0) {
            if (entity instanceof EntityPigZombie && entity.field_70170_p.field_73012_v.nextInt(ZOMBIE_ANGRY_CHANCE) == 0) {
                this.makePigZombieAngry((EntityPigZombie)entity);
            }
        } else if (runeType == 3 && entity.field_70170_p.field_73011_w.field_76574_g != -1 && entity instanceof EntitySkeleton && (skeleton = (EntitySkeleton)entity).func_82202_m() != 1 && skeleton.func_70681_au().nextInt(5) > 0) {
            BlockNetherRuneCreature.removeArmor((EntityLiving)skeleton);
            skeleton.func_82201_a(1);
            skeleton.func_70062_b(0, new ItemStack(Items.field_151052_q));
            skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            skeleton.func_85036_m();
        }
    }

    @Override
    public int requiredLureDistance(World world, int x, int y, int z) {
        if (this.getBaseRuneType(world, x, y, z) == 2) {
            return 8;
        }
        return 0;
    }

    public static void removeArmor(EntityLiving entity) {
        for (int j = 3; j >= 0; --j) {
            entity.func_70062_b(j + 1, null);
        }
    }

    public void makePigZombieAngry(EntityPigZombie zombie) {
        if (becomeAngryAt == null) {
            try {
                becomeAngryAt = ReflectionHelper.findMethod(EntityPigZombie.class, (Object)zombie, (String[])new String[]{"becomeAngryAt", "func_70835_c"}, (Class[])new Class[]{Entity.class});
            }
            catch (Exception ex) {
                FMLLog.warning((String)"[Automagy] Failed to find zombie pigman anger controls.", (Object[])new Object[0]);
                ex.printStackTrace();
                return;
            }
        }
        try {
            becomeAngryAt.invoke((Object)zombie, new Object[]{null});
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Automagy] Failed to make zombie pigman angry.", (Object[])new Object[0]);
            ex.printStackTrace();
        }
    }
}

