/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.common.utills;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Utills {
    public static IEntitySelector selectLivingBase = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity instanceof EntityLivingBase;
        }
    };
    public static IEntitySelector selectPlayer = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity instanceof EntityPlayer;
        }
    };

    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return String.valueOf((long)Math.round(value) / 1000L) + "K";
        }
        if (value < 1000000000L) {
            return String.valueOf((long)Math.round(value / 1000L) / 1000L) + "M";
        }
        if (value < 1000000000000L) {
            return String.valueOf((long)Math.round(value / 1000000L) / 1000L) + "B";
        }
        return String.valueOf((long)Math.round(value / 1000000000L) / 1000L) + "T";
    }

    public static String addCommas(int value) {
        String rawNumber = String.valueOf(value);
        String formattedNumber = "";
        do {
            int end = rawNumber.length();
            int start = Math.max(0, end - 3);
            String part = rawNumber.substring(start, end);
            rawNumber = rawNumber.substring(0, start);
            formattedNumber = part + (formattedNumber.length() > 0 ? "," : "") + formattedNumber;
        } while (rawNumber.length() > 0);
        return formattedNumber;
    }

    public static String addCommas(long value) {
        String rawNumber = String.valueOf(value);
        String formattedNumber = "";
        do {
            int end = rawNumber.length();
            int start = Math.max(0, end - 3);
            String part = rawNumber.substring(start, end);
            rawNumber = rawNumber.substring(0, start);
            formattedNumber = part + (formattedNumber.length() > 0 ? "," : "") + formattedNumber;
        } while (rawNumber.length() > 0);
        return formattedNumber;
    }

    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static boolean isConnectedToDedicatedServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null;
    }

    public static ItemStack getStackFromName(String name, int meta) {
        if (name.contains("tile.")) {
            name = name.replace("draconicevolution", "DraconicEvolution").replace("tile.", "");
            if (GameData.getBlockRegistry().func_82594_a(name) != null) {
                return new ItemStack((Block)GameData.getBlockRegistry().func_82594_a(name), 1, meta);
            }
        }
        if (name.contains("item.")) {
            name = name.replace("draconicevolution", "DraconicEvolution").replace("item.", "");
            if (GameData.getItemRegistry().func_82594_a(name) != null) {
                return new ItemStack((Item)GameData.getItemRegistry().func_82594_a(name), 1, meta);
            }
        }
        return null;
    }

    public static void updateNeabourBlocks(World world, int x, int y, int z) {
        world.func_147459_d(x, y, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x - 1, y, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x + 1, y, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y - 1, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y + 1, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y, z - 1, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y, z + 1, world.func_147439_a(x, y, z));
    }

    public static int determineOrientation(int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - (double)entity.field_70129_M;
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public static int getNearestMultiple(int number, int multiple) {
        int result = number;
        if (number < 0) {
            result *= -1;
        }
        if (result % multiple == 0) {
            return number;
        }
        result = result % multiple < multiple / 2 ? (result -= result % multiple) : (result += multiple - result % multiple);
        if (number < 0) {
            result *= -1;
        }
        return result;
    }

    public static int toInt(double d) {
        return (int)d;
    }
}

