/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.ServerUtils;
import codechicken.core.commands.CoreCommand;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherServer;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class ParamJam
extends FreqParam {
    @Override
    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.chatT("wrcbe_core.param.jam.usage", new Object[0]);
        listener.chatT("wrcbe_core.param.jam.usage1", new Object[0]);
        listener.chatT("wrcbe_core.param.jam.usage" + (rand.nextInt(5) + 2), new Object[]{"jam"});
    }

    @Override
    public String getName() {
        return "jam";
    }

    @Override
    public void handleCommand(String playername, String[] args, CoreCommand.WCommandSender listener) {
        ParamJam.jamOpenCommand(playername, Arrays.copyOfRange(args, 1, args.length), listener, true);
    }

    public static void jamOpenCommand(String playername, String[] args, CoreCommand.WCommandSender listener, boolean jam) {
        int endfreq;
        int startfreq;
        String jamPlayer;
        RedstoneEtherServer ether = RedstoneEther.server();
        if (args.length == 0) {
            listener.chatT("wrcbe_core.param.invalidno", new Object[0]);
            return;
        }
        if (args.length == 1 && ServerUtils.getPlayer((String)playername) == null) {
            listener.chatT("wrcbe_core.param.jam.noplayer", new Object[0]);
            return;
        }
        String range = args[args.length - 1];
        String string = jamPlayer = args.length == 1 ? playername : args[0];
        if (range.equals("all")) {
            startfreq = 1;
            endfreq = 5000;
        } else if (range.equals("default")) {
            startfreq = ether.getLastSharedFrequency() + 1;
            endfreq = 5000;
        } else {
            int[] freqrange = RedstoneEther.parseFrequencyRange(range);
            startfreq = freqrange[0];
            endfreq = freqrange[1];
        }
        if (startfreq < 1 || endfreq > 5000 || endfreq < startfreq) {
            listener.chatT("wrcbe_core.param.invalidfreqrange", new Object[0]);
            return;
        }
        ether.setFrequencyRangeCommand(jamPlayer, startfreq, endfreq, jam);
        int publicend = ether.getLastPublicFrequency();
        EntityPlayerMP player = ServerUtils.getPlayer((String)jamPlayer);
        String paramName = jam ? "jam" : "open";
        ChatStyle playerStyle = new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW);
        if (startfreq == endfreq) {
            if (startfreq <= publicend) {
                listener.chatT("wrcbe_core.param.jam.errpublic", new Object[0]);
                return;
            }
            listener.chatOpsT("wrcbe_core.param." + paramName + ".opjammed", new Object[]{playername, jamPlayer, startfreq});
            if (player != null) {
                player.func_146105_b(new ChatComponentTranslation("wrcbe_core.param." + paramName + ".jammed", new Object[]{startfreq}).func_150255_a(playerStyle));
            }
        } else {
            if (startfreq <= publicend && endfreq <= publicend) {
                listener.chatT("wrcbe_core.param.jam.errpublic", new Object[0]);
                return;
            }
            if (startfreq <= publicend) {
                startfreq = publicend + 1;
            }
            listener.chatOpsT("wrcbe_core.param." + paramName + ".opjammed2", new Object[]{playername, jamPlayer, startfreq + "-" + endfreq});
            if (player != null) {
                player.func_146105_b(new ChatComponentTranslation("wrcbe_core.param." + paramName + ".jammed2", new Object[]{startfreq + "-" + endfreq}).func_150255_a(playerStyle));
            }
        }
    }
}

