/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.gui.GuiWidget;
import codechicken.wirelessredstone.core.WRCoreCPH;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiInvItemSlot
extends GuiWidget {
    private static RenderItem itemRenderer = new RenderItem();
    protected ItemStack[] invitems;
    protected int[] invslotnumbers;
    protected ItemStack[] defaultitems;
    protected InventoryPlayer inv;
    protected int selecteditem;
    public boolean focused;
    public String actionCommand;

    public GuiInvItemSlot(int x, int y, InventoryPlayer playerinv, ItemStack[] defaults, int selection) {
        super(x, y, 16, 16);
        this.defaultitems = defaults;
        this.invitems = new ItemStack[this.defaultitems.length];
        this.invslotnumbers = new int[this.defaultitems.length];
        this.inv = playerinv;
        this.searchInventoryItems();
        this.selectItem(selection);
    }

    public GuiInvItemSlot setActionCommand(String s) {
        this.actionCommand = s;
        return this;
    }

    public void draw(int mousex, int mousey, float frame) {
        this.drawSlotBox(this.x, this.y);
        if (this.invitems[this.selecteditem] != null) {
            itemRenderer.func_77015_a(this.fontRenderer, this.renderEngine, this.invitems[this.selecteditem], this.x, this.y);
        }
    }

    public void drawSlotBox(int x, int y) {
        GuiInvItemSlot.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 17), (int)(y + 17), (int)-7631989);
        GuiInvItemSlot.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 16), (int)(y + 16), (int)-13158601);
        GuiInvItemSlot.func_73734_a((int)(x + 0), (int)(y + 0), (int)(x + 17), (int)(y + 17), (int)-1);
        GuiInvItemSlot.func_73734_a((int)(x + 0), (int)(y + 0), (int)(x + 16), (int)(y + 16), (int)-7631989);
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
    }

    public void mouseClicked(int mousex, int mousey, int button) {
        this.setFocused(this.pointInside(mousex, mousey));
    }

    public void keyTyped(char c, int keyindex) {
        if (!this.focused) {
            return;
        }
        if (keyindex == 203) {
            this.cyclePrevItem();
        }
        if (keyindex == 205) {
            this.cycleNextItem();
        }
        if (keyindex == 28 && this.actionCommand != null) {
            this.sendAction(this.actionCommand, new Object[0]);
        }
    }

    public void decrementCurrentStack() {
        if (this.invitems[this.selecteditem] == null) {
            return;
        }
        int slot = this.invslotnumbers[this.selecteditem];
        if (this.inv.field_70458_d.field_70170_p.field_72995_K) {
            WRCoreCPH.sendDecrementSlot(slot);
        }
        ItemStack item = this.invitems[this.selecteditem];
        --item.field_77994_a;
        if (item.field_77994_a == 0) {
            this.inv.field_70462_a[slot] = null;
            this.searchInventoryItems();
            this.selectItem(this.selecteditem);
        }
    }

    public boolean currentStackExists() {
        return this.invitems[this.selecteditem] != null;
    }

    public void selectItem(int index) {
        this.selecteditem = index;
        if (this.invitems[this.selecteditem] == null) {
            this.cycleNextItem();
        }
    }

    public void cycleNextItem() {
        int cycleindex = this.selecteditem;
        do {
            if (++cycleindex >= this.invitems.length) {
                cycleindex = 0;
            }
            if (cycleindex != this.selecteditem) continue;
            return;
        } while (this.invitems[cycleindex] == null);
        this.selecteditem = cycleindex;
    }

    public void cyclePrevItem() {
        int cycleindex = this.selecteditem;
        do {
            if (--cycleindex < 0) {
                cycleindex = this.invitems.length - 1;
            }
            if (cycleindex != this.selecteditem) continue;
            return;
        } while (this.invitems[cycleindex] == null);
        this.selecteditem = cycleindex;
    }

    private void searchInventoryItems() {
        block0: for (int i = 0; i < this.defaultitems.length; ++i) {
            this.invitems[i] = null;
            this.invslotnumbers[i] = -1;
            for (int j = 0; j < this.inv.field_70462_a.length; ++j) {
                ItemStack invstack = this.inv.func_70301_a(j);
                if (invstack == null || !this.defaultitems[i].func_77969_a(invstack)) continue;
                this.invitems[i] = invstack;
                this.invslotnumbers[i] = j;
                continue block0;
            }
        }
    }

    public int getSelectedIndex() {
        return this.invitems[this.selecteditem] == null ? -1 : this.selecteditem;
    }
}

