/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainEBClayHills
extends TerrainBase {
    private boolean booRiver;
    private float[] height;
    private int heightLength;
    private float strength;
    private float cWidth;
    private float cHeigth;
    private float cStrength;
    private float base;

    public TerrainEBClayHills(boolean riverGen, float heightStrength, float canyonWidth, float canyonHeight, float canyonStrength, float baseHeight) {
        this.booRiver = riverGen;
        this.height = new float[]{5.0f, 0.5f, 12.5f, 0.5f, 18.0f, 0.5f};
        this.strength = heightStrength;
        this.heightLength = this.height.length;
        this.cWidth = canyonWidth;
        this.cHeigth = canyonHeight;
        this.cStrength = canyonStrength;
        this.base = baseHeight;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        river = (river *= 1.3f) > 1.0f ? 1.0f : river;
        float r = simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 50.0f;
        r = r < -7.4f ? -7.4f : (r > 7.4f ? 7.4f : r);
        float b = (17.0f + r) * river;
        float hn = simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 0.5f;
        float sb = 0.0f;
        if (b > 0.0f) {
            sb = b;
            sb = sb < 0.0f ? 0.0f : (sb > 7.0f ? 7.0f : sb);
            sb = hn * sb;
        }
        b += sb;
        float cTotal = 0.0f;
        float cTemp = 0.0f;
        for (int i = 0; i < this.heightLength; i += 2) {
            cTemp = 0.0f;
            if (b > this.height[i] && border > 0.6f + this.height[i] * 0.015f + hn * 0.2f) {
                cTemp = b > this.height[i] + this.height[i + 1] ? this.height[i + 1] : b - this.height[i];
                cTemp *= this.strength;
            }
            cTotal += cTemp;
        }
        float bn = 0.0f;
        if (this.booRiver) {
            if (b < 5.0f) {
                bn = 5.0f - b;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn / 4.5f;
                }
            }
        } else if (b < 5.0f) {
            bn = (simplex.noise2((float)x / 7.0f, (float)y / 7.0f) * 1.3f + simplex.noise2((float)x / 15.0f, (float)y / 15.0f) * 2.0f) * (5.0f - b) * 0.2f;
        }
        return this.base + (b += cTotal - bn);
    }
}

