/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainEBBorealPlateau
extends TerrainBase {
    private float hHeight;
    private float hWidth;
    private float vHeight;
    private float vWidth;
    private float lHeight;
    private float lWidth;
    private float bHeight;

    public TerrainEBBorealPlateau(float hillHeight, float hillWidth, float varHeight, float varWidth, float lakeHeight, float lakeWidth, float baseHeight) {
        this.hHeight = hillHeight;
        this.hWidth = hillWidth;
        this.vHeight = varHeight;
        this.vWidth = varWidth;
        this.lHeight = lakeHeight;
        this.lWidth = lakeWidth;
        this.bHeight = baseHeight;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / this.vWidth, (float)y / this.vWidth) * this.vHeight * river;
        h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float m = simplex.noise2((float)x / this.hWidth, (float)y / this.hWidth) * this.hHeight * river;
        m *= m / 40.0f;
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f;
        float cm = cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * 12.0f;
        m += (cm *= m / 20.0f > 3.75f ? 3.75f : (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)) / 20.0f);
        float l = simplex.noise2((float)x / this.lWidth, (float)y / this.lWidth) * this.lHeight;
        l *= l / 25.0f;
        l = l < 8.0f ? 8.0f : l;
        h += simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 3.0f;
        return this.bHeight + (h += simplex.noise2((float)x / 5.0f, (float)y / 5.0f) * 1.5f) + m - l;
    }
}

