/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.biomesoplenty;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainBOPSeasonalForest
extends TerrainBase {
    private float start;
    private float height;
    private float base;
    private float width;

    public TerrainBOPSeasonalForest(float hillStart, float landHeight, float baseHeight, float hillWidth) {
        this.start = hillStart;
        this.height = landHeight;
        this.base = baseHeight;
        this.width = hillWidth;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / this.width, (float)y / this.width) * this.height * river;
        float f = h = h < this.start ? this.start + (h - this.start) / 4.5f : h;
        if (h > 0.0f) {
            float st = h * 1.5f > 15.0f ? 15.0f : h * 1.5f;
            h += cell.noise((double)x / 70.0, (double)y / 70.0, 1.0) * st;
        }
        h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 5.0f;
        h += simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 3.0f;
        return this.base + (h += simplex.noise2((float)x / 5.0f, (float)y / 5.0f) * 1.5f);
    }
}

