/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.biomesoplenty;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainBOPMoor
extends TerrainBase {
    private float minHeight = 63.0f;
    private float maxHeight = 80.0f;
    private float hillStrength = 30.0f;

    public TerrainBOPMoor() {
    }

    public TerrainBOPMoor(float minHeight, float maxHeight, float hillStrength) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight > 80.0f ? 80.0f : (maxHeight < this.minHeight ? 80.0f : maxHeight);
        this.hillStrength = hillStrength;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / 200.0f, (float)y / 200.0f) * 4.0f;
        h += simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 2.0f;
        float m = simplex.noise2((float)x / 200.0f, (float)y / 200.0f) * this.hillStrength * river;
        m *= m / (this.hillStrength * 0.1f + this.hillStrength);
        float sm = simplex.noise2((float)x / this.hillStrength, (float)y / this.hillStrength) * 8.0f;
        float l = simplex.noise2((float)x / 260.0f, (float)y / 260.0f) * 38.0f;
        l *= l / 25.0f;
        l = l < -8.0f ? -8.0f : l;
        float floNoise = this.maxHeight + h + (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)) - l;
        floNoise = floNoise < this.minHeight ? this.minHeight : floNoise;
        return floNoise;
    }
}

