/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.highlands;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SnowHeightCalculator;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceHLValley
extends SurfaceBase {
    public SurfaceHLValley(Block top, Block fill) {
        super(top, fill);
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        boolean water = false;
        boolean riverPaint = false;
        boolean grass = false;
        if (river > 0.05f && river + simplex.noise2((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
            riverPaint = true;
            if (simplex.noise2((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                grass = true;
            }
        }
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b == Blocks.field_150348_b) {
                ++depth;
                if (riverPaint) {
                    if (grass && depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        continue;
                    }
                    if (depth != 0) continue;
                    if (rand.nextInt(2) == 0) {
                        blocks[(y * 16 + x) * 256 + k] = this.hcStone(world, i, j, x, y, k);
                        metadata[(y * 16 + x) * 256 + k] = this.hcStoneMeta(world, i, j, x, y, k);
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.hcCobble(world, i, j, x, y, k);
                    metadata[(y * 16 + x) * 256 + k] = this.hcCobbleMeta(world, i, j, x, y, k);
                    continue;
                }
                if (depth <= -1 || depth >= 9) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                if (depth != 0 || k <= 61 || k >= 254) continue;
                SnowHeightCalculator.calc(x, y, k, blocks, metadata, noise);
                continue;
            }
            if (water || b != Blocks.field_150355_j) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150432_aD;
            water = true;
        }
    }
}

