/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.enhancedbiomes;

import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SnowHeightCalculator;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBBase;

public class SurfaceEBPolarDesert
extends SurfaceEBBase {
    private Block blockTop;
    private byte byteTop;
    private Block blockFiller;
    private byte byteFiller;
    private Block blockMixTop;
    private byte byteMixTop;
    private Block blockMixFiller;
    private byte byteMixFiller;
    private Block blockCliff1;
    private byte byteCliff1;
    private Block blockCliff2;
    private byte byteCliff2;
    private float floMixWidth;
    private float floMixHeight;
    private float floSmallWidth;
    private float floSmallStrength;

    public SurfaceEBPolarDesert(Block top, byte topByte, Block filler, byte fillerByte, Block mixTop, byte mixTopByte, Block mixFiller, byte mixFillerByte, Block cliff1, byte cliff1Byte, Block cliff2, byte cliff2Byte, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
        super(top, filler);
        this.blockTop = top;
        this.byteTop = topByte;
        this.blockFiller = filler;
        this.byteFiller = fillerByte;
        this.blockMixTop = mixTop;
        this.byteMixTop = mixTopByte;
        this.blockMixFiller = mixFiller;
        this.byteMixFiller = mixFillerByte;
        this.blockCliff1 = cliff1;
        this.byteCliff1 = cliff1Byte;
        this.blockCliff2 = cliff2;
        this.byteCliff2 = cliff2Byte;
        this.floMixWidth = mixWidth;
        this.floMixHeight = mixHeight;
        this.floSmallWidth = smallWidth;
        this.floSmallStrength = smallStrength;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        boolean water = false;
        boolean riverPaint = false;
        boolean grass = false;
        if (river > 0.05f && river + simplex.noise2((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
            riverPaint = true;
            if (simplex.noise2((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                grass = true;
            }
        }
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b == Blocks.field_150348_b) {
                ++depth;
                if (this.shouldReplaceStone()) {
                    blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, this.hcStone(world, i, j, x, y, k));
                    metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)5, this.hcStoneMeta(world, i, j, x, y, k));
                }
                if (riverPaint) {
                    if (grass && depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = this.blockFiller;
                        metadata[(y * 16 + x) * 256 + k] = this.byteFiller;
                        continue;
                    }
                    if (depth != 0) continue;
                    if (rand.nextInt(2) == 0) {
                        blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, this.hcStone(world, i, j, x, y, k));
                        metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)5, this.hcStoneMeta(world, i, j, x, y, k));
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, this.hcCobble(world, i, j, x, y, k));
                    metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)5, this.hcCobbleMeta(world, i, j, x, y, k));
                    continue;
                }
                if (depth <= -1 || depth >= 9) continue;
                blocks[(y * 16 + x) * 256 + k] = this.blockTop;
                metadata[(y * 16 + x) * 256 + k] = this.byteTop;
                if (depth != 0 || k <= 61 || k >= 254) continue;
                SnowHeightCalculator.calc(x, y, k, blocks, metadata, noise);
                continue;
            }
            if (water || b != Blocks.field_150355_j) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150432_aD;
            water = true;
        }
    }
}

