/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.enhancedbiomes;

import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.util.CellNoise;
import rtg.util.CliffCalculator;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBBase;

public class SurfaceEBAspenHills
extends SurfaceEBBase {
    private boolean beach;
    private Block beachBlock;
    private float min;
    private float sCliff = 1.5f;
    private float sHeight = 60.0f;
    private float sStrength = 65.0f;
    private float iCliff = 0.3f;
    private float iHeight = 100.0f;
    private float iStrength = 50.0f;
    private float cCliff = 1.5f;
    private byte topByte;
    private byte fillerByte;

    public SurfaceEBAspenHills(Block top, byte topMeta, Block fill, byte fillMeta, boolean genBeach, Block genBeachBlock, float minCliff) {
        super(top, fill);
        this.beach = genBeach;
        this.beachBlock = genBeachBlock;
        this.min = minCliff;
    }

    public SurfaceEBAspenHills(Block top, byte topMeta, Block fill, byte fillMeta, boolean genBeach, Block genBeachBlock, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float snowCliff, float snowHeight, float snowStrength, float clayCliff) {
        this(top, topMeta, fill, fillMeta, genBeach, genBeachBlock, minCliff);
        this.sCliff = stoneCliff;
        this.sHeight = stoneHeight;
        this.sStrength = stoneStrength;
        this.iCliff = snowCliff;
        this.iHeight = snowHeight;
        this.iStrength = snowStrength;
        this.cCliff = clayCliff;
        this.topByte = topMeta;
        this.fillerByte = fillMeta;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (this.shouldReplaceStone()) {
                blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, this.hcStone(world, i, j, x, y, k));
                metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)4, this.hcStoneMeta(world, i, j, x, y, k));
            }
            if (depth == 0) {
                if (k < 63 && this.beach) {
                    gravel = true;
                }
                float p = simplex.noise3((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                    cliff = 1;
                }
                if (c > this.cCliff) {
                    cliff = 2;
                }
                if ((float)k > 110.0f + p * 4.0f && c < this.iCliff + ((float)k - this.iHeight) / this.iStrength + p) {
                    cliff = 3;
                }
                if (cliff == 1) {
                    if (rand.nextInt(3) == 0) {
                        blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, this.hcCobble(world, i, j, x, y, k));
                        metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)4, this.hcCobbleMeta(world, i, j, x, y, k));
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, this.hcStone(world, i, j, x, y, k));
                    metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)4, this.hcStoneMeta(world, i, j, x, y, k));
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = this.getShadowStoneBlock(world, i, j, x, y, k);
                    metadata[(y * 16 + x) * 256 + k] = this.getShadowStoneMeta(world, i, j, x, y, k);
                    continue;
                }
                if (cliff == 3) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (k < 63) {
                    if (this.beach) {
                        blocks[(y * 16 + x) * 256 + k] = this.beachBlock;
                        gravel = true;
                        continue;
                    }
                    if (k < 62) {
                        blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.fillerByte;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.topByte;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                metadata[(y * 16 + x) * 256 + k] = this.topByte;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, this.hcStone(world, i, j, x, y, k));
                metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)4, this.hcStoneMeta(world, i, j, x, y, k));
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = this.getShadowStoneBlock(world, i, j, x, y, k);
                metadata[(y * 16 + x) * 256 + k] = this.getShadowStoneMeta(world, i, j, x, y, k);
                continue;
            }
            if (cliff == 3) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                continue;
            }
            if (gravel) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
            metadata[(y * 16 + x) * 256 + k] = this.fillerByte;
        }
    }
}

