/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.structure;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import rtg.config.rtg.ConfigRTG;
import rtg.world.WorldTypeRTG;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class MapGenVillageRTG
extends MapGenVillage {
    public static List villageSpawnBiomes = BiomeBase.arrVillageBiomes;
    private int terrainType = ConfigRTG.villageSize;
    private int field_82665_g;
    private int field_82666_h;

    public MapGenVillageRTG() {
        int minDistanceVillages = ConfigRTG.minDistanceVillages;
        int maxDistanceVillages = ConfigRTG.maxDistanceVillages;
        minDistanceVillages = minDistanceVillages > maxDistanceVillages ? maxDistanceVillages : minDistanceVillages;
        this.field_82665_g = maxDistanceVillages;
        this.field_82666_h = minDistanceVillages;
    }

    public MapGenVillageRTG(Map par1Map) {
        this();
        for (Map.Entry entry : par1Map.entrySet()) {
            if (((String)entry.getKey()).equals("size")) {
                this.terrainType = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.terrainType, (int)0);
                continue;
            }
            if (!((String)entry.getKey()).equals("distance")) continue;
            this.field_82665_g = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.field_82665_g, (int)(this.field_82666_h + 1));
        }
    }

    public String func_143025_a() {
        return "Village";
    }

    protected boolean func_75047_a(int par1, int par2) {
        if (villageSpawnBiomes.size() < 1) {
            return false;
        }
        boolean booRTGWorld = this.field_75039_c.func_72912_H().func_76067_t() instanceof WorldTypeRTG;
        boolean booRTGChunkManager = this.field_75039_c.func_72959_q() instanceof WorldChunkManagerRTG;
        boolean canSpawnVillage = false;
        int k = par1;
        int l = par2;
        if (par1 < 0) {
            par1 -= this.field_82665_g - 1;
        }
        if (par2 < 0) {
            par2 -= this.field_82665_g - 1;
        }
        int i1 = par1 / this.field_82665_g;
        int j1 = par2 / this.field_82665_g;
        Random random = this.field_75039_c.func_72843_D(i1, j1, 10387312);
        i1 *= this.field_82665_g;
        j1 *= this.field_82665_g;
        if (k == (i1 += random.nextInt(this.field_82665_g - this.field_82666_h)) && l == (j1 += random.nextInt(this.field_82665_g - this.field_82666_h))) {
            if (booRTGWorld && booRTGChunkManager) {
                WorldChunkManagerRTG cmr = (WorldChunkManagerRTG)this.field_75039_c.func_72959_q();
                int worldX = par1 * 16;
                int worldZ = par2 * 16;
                RealisticBiomeBase realisticBiome = cmr.getBiomeDataAt(worldX + 16, worldZ + 16);
                BiomeGenBase biome = realisticBiome.baseBiome;
                for (int intBiomeIndex = 0; intBiomeIndex < villageSpawnBiomes.size(); ++intBiomeIndex) {
                    if (villageSpawnBiomes.get(intBiomeIndex) != biome) continue;
                    canSpawnVillage = true;
                    break;
                }
            } else {
                canSpawnVillage = this.field_75039_c.func_72959_q().func_76940_a(k * 16 + 8, l * 16 + 8, 0, villageSpawnBiomes);
            }
        }
        return canSpawnVillage;
    }

    protected StructureStart func_75049_b(int par1, int par2) {
        return new Start(this.field_75039_c, this.field_75038_b, par1, par2, this.terrainType);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World p_i2092_1_, Random p_i2092_2_, int p_i2092_3_, int p_i2092_4_, int p_i2092_5_) {
            super(p_i2092_3_, p_i2092_4_);
            int l;
            List list = StructureVillagePieces.func_75084_a((Random)p_i2092_2_, (int)p_i2092_5_);
            StructureVillagePieces.Start start = new StructureVillagePieces.Start(p_i2092_1_.func_72959_q(), 0, p_i2092_2_, (p_i2092_3_ << 4) + 2, (p_i2092_4_ << 4) + 2, list, p_i2092_5_);
            this.field_75075_a.add(start);
            start.func_74861_a((StructureComponent)start, (List)this.field_75075_a, p_i2092_2_);
            List list1 = start.field_74930_j;
            List list2 = start.field_74932_i;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                StructureComponent structurecomponent;
                if (list1.isEmpty()) {
                    l = p_i2092_2_.nextInt(list2.size());
                    structurecomponent = (StructureComponent)list2.remove(l);
                    structurecomponent.func_74861_a((StructureComponent)start, (List)this.field_75075_a, p_i2092_2_);
                    continue;
                }
                l = p_i2092_2_.nextInt(list1.size());
                structurecomponent = (StructureComponent)list1.remove(l);
                structurecomponent.func_74861_a((StructureComponent)start, (List)this.field_75075_a, p_i2092_2_);
            }
            this.func_75072_c();
            l = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureVillagePieces.Road) continue;
                ++l;
            }
            this.hasMoreThanTwoComponents = l > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound p_143022_1_) {
            super.func_143022_a(p_143022_1_);
            p_143022_1_.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound p_143017_1_) {
            super.func_143017_b(p_143017_1_);
            this.hasMoreThanTwoComponents = p_143017_1_.func_74767_n("Valid");
        }
    }
}

