/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.structure;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.Level;
import rtg.config.rtg.ConfigRTG;

public class MapGenScatteredFeatureRTG
extends MapGenScatteredFeature {
    private static List biomelist = Arrays.asList(BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x, BiomeGenBase.field_76780_h);
    private List scatteredFeatureSpawnList;
    private int maxDistanceBetweenScatteredFeatures;
    private int minDistanceBetweenScatteredFeatures;

    public MapGenScatteredFeatureRTG() {
        int minDistance = ConfigRTG.minDistanceScatteredFeatures;
        int maxDistance = ConfigRTG.maxDistanceScatteredFeatures;
        if (minDistance > maxDistance) {
            minDistance = 8;
            maxDistance = 32;
        }
        this.scatteredFeatureSpawnList = new ArrayList();
        this.maxDistanceBetweenScatteredFeatures = maxDistance;
        this.minDistanceBetweenScatteredFeatures = minDistance;
        this.scatteredFeatureSpawnList.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    public MapGenScatteredFeatureRTG(Map p_i2061_1_) {
        this();
        for (Map.Entry entry : p_i2061_1_.entrySet()) {
            if (!((String)entry.getKey()).equals("distance")) continue;
            this.maxDistanceBetweenScatteredFeatures = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)this.maxDistanceBetweenScatteredFeatures, (int)(this.minDistanceBetweenScatteredFeatures + 1));
        }
    }

    public String func_143025_a() {
        return "Temple";
    }

    protected boolean func_75047_a(int p_75047_1_, int p_75047_2_) {
        BiomeGenBase biomegenbase;
        int k = p_75047_1_;
        int l = p_75047_2_;
        if (p_75047_1_ < 0) {
            p_75047_1_ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (p_75047_2_ < 0) {
            p_75047_2_ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int i1 = p_75047_1_ / this.maxDistanceBetweenScatteredFeatures;
        int j1 = p_75047_2_ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(i1, j1, 14357617);
        i1 *= this.maxDistanceBetweenScatteredFeatures;
        j1 *= this.maxDistanceBetweenScatteredFeatures;
        if (k == (i1 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && l == (j1 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && (biomegenbase = this.field_75039_c.func_72959_q().func_76935_a(k * 16 + 8, l * 16 + 8)) != null) {
            if (MapGenScatteredFeatureRTG.canSpawnDesertTemple(biomegenbase)) {
                return true;
            }
            if (MapGenScatteredFeatureRTG.canSpawnJungleTemple(biomegenbase)) {
                return true;
            }
            if (MapGenScatteredFeatureRTG.canSpawnWitchHut(biomegenbase)) {
                return true;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int p_75049_1_, int p_75049_2_) {
        return new Start(this.field_75039_c, this.field_75038_b, p_75049_1_, p_75049_2_);
    }

    public boolean func_143030_a(int p_143030_1_, int p_143030_2_, int p_143030_3_) {
        StructureStart structurestart = this.func_143028_c(p_143030_1_, p_143030_2_, p_143030_3_);
        if (structurestart != null && structurestart instanceof Start && !structurestart.func_75073_b().isEmpty()) {
            StructureComponent structurecomponent = (StructureComponent)structurestart.func_75073_b().getFirst();
            return structurecomponent instanceof ComponentScatteredFeaturePieces.SwampHut;
        }
        return false;
    }

    public List func_82667_a() {
        return this.scatteredFeatureSpawnList;
    }

    private static boolean canSpawnDesertTemple(BiomeGenBase b) {
        boolean canSpawn = false;
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            canSpawn = true;
        }
        return canSpawn;
    }

    private static boolean canSpawnJungleTemple(BiomeGenBase b) {
        boolean canSpawn = false;
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.WET) && BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            canSpawn = true;
        }
        return canSpawn;
    }

    private static boolean canSpawnWitchHut(BiomeGenBase b) {
        boolean canSpawn = false;
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.WET) && BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            canSpawn = true;
        }
        return canSpawn;
    }

    public static class Start
    extends MapGenScatteredFeature.Start {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(worldIn, random, chunkX, chunkZ);
            LinkedList<Object> arrComponents = new LinkedList<Object>();
            BiomeGenBase biomegenbase = worldIn.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8);
            if (MapGenScatteredFeatureRTG.canSpawnDesertTemple(biomegenbase)) {
                ComponentScatteredFeaturePieces.DesertPyramid desertpyramid = new ComponentScatteredFeaturePieces.DesertPyramid(random, chunkX * 16, chunkZ * 16);
                arrComponents.add(desertpyramid);
            }
            if (MapGenScatteredFeatureRTG.canSpawnJungleTemple(biomegenbase)) {
                ComponentScatteredFeaturePieces.JunglePyramid junglepyramid = new ComponentScatteredFeaturePieces.JunglePyramid(random, chunkX * 16, chunkZ * 16);
                arrComponents.add(junglepyramid);
            }
            if (MapGenScatteredFeatureRTG.canSpawnWitchHut(biomegenbase)) {
                ComponentScatteredFeaturePieces.SwampHut swamphut = new ComponentScatteredFeaturePieces.SwampHut(random, chunkX * 16, chunkZ * 16);
                arrComponents.add(swamphut);
            }
            this.field_75075_a.clear();
            if (arrComponents.size() > 0) {
                this.field_75075_a.add(arrComponents.get(random.nextInt(arrComponents.size())));
            }
            if (ConfigRTG.enableDebugging) {
                FMLLog.log((Level)Level.INFO, (String)"Scattered feature candidate at %d, %d", (Object[])new Object[]{chunkX * 16, chunkZ * 16});
            }
            this.func_75072_c();
        }
    }
}

