/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenTreePalmCustom
extends WorldGenerator {
    private static int leavesLength = 133;
    private static int[] leaves = new int[]{1, 0, 0, 2, 0, 0, 3, -1, 0, 3, -2, 0, -1, 0, 0, -2, 0, 0, -3, -1, 0, -3, -2, 0, 0, 0, 1, 0, 0, 2, 0, -1, 3, 0, -2, 3, 0, 0, -1, 0, 0, -2, 0, -1, -3, 0, -2, -3, 0, 1, 0, 1, 1, 1, -1, 1, -1, -1, 1, 1, 1, 1, -1, 1, 2, 0, -1, 2, 0, 0, 2, 1, 0, 2, -1, 2, 3, 0, 3, 3, 0, 4, 2, 0, -2, 3, 0, -3, 3, 0, -4, 2, 0, 0, 3, 2, 0, 3, 3, 0, 2, 4, 0, 3, -2, 0, 3, -3, 0, 2, -4, 2, 2, -2, -2, 2, 2, -2, 2, -2, 2, 2, 2, 3, 2, -3, -3, 2, 3, -3, 2, -3, 3, 2, 3};
    private static int cocoasLength = 16;
    private static int[] cocoas = new int[]{2, 0, -2, 1, 1, 1, -2, 0, 0, 0, -2, -1, 3, -1, -2, 0};
    private float treeLength = 15.0f;

    public WorldGenTreePalmCustom(float pTreeLength, int pLeavesLength, int[] pLeaves, int pCocoasLength, int[] pCocoas) {
        this.treeLength = pTreeLength;
        leavesLength = pLeavesLength;
        leaves = pLeaves;
        cocoasLength = pCocoasLength;
        cocoas = pCocoas;
    }

    public WorldGenTreePalmCustom() {
    }

    public WorldGenTreePalmCustom(float pTreeLength) {
        this.treeLength = pTreeLength;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b != Blocks.field_150349_c && b != Blocks.field_150346_d && b != Blocks.field_150354_m) {
            return false;
        }
        double horDir = this.getRandomDir(rand);
        float verDir = 0.3f + rand.nextFloat() * 0.4f;
        float length = this.treeLength;
        float posX = x;
        float posY = y;
        float posZ = z;
        float c = 0.0f;
        float loss = 0.0f;
        if (verDir < 0.0f) {
            verDir = -verDir;
        }
        float velY = 1.0f - verDir;
        if (verDir > 1.0f) {
            verDir = 1.0f - (verDir - 1.0f);
        }
        float velX = (float)Math.cos(horDir * Math.PI / 180.0) * verDir;
        float velZ = (float)Math.sin(horDir * Math.PI / 180.0) * verDir;
        while (c < length) {
            world.func_147465_d((int)posX, (int)posY, (int)posZ, Blocks.field_150364_r, 15, 2);
            if (c < length - 3.0f) {
                loss = Math.abs(velX) + Math.abs(velZ);
                posX += (velX *= 0.9f);
                posZ += (velZ *= 0.9f);
                posY += (velY += (loss -= Math.abs(velX) + Math.abs(velZ)));
            } else {
                posY += velY;
            }
            c += 1.0f;
        }
        x = (int)posX;
        y = (int)posY - 1;
        z = (int)posZ;
        for (int j = 0; j < leavesLength; j += 3) {
            world.func_147465_d(x + leaves[j], y + leaves[j + 1], z + leaves[j + 2], (Block)Blocks.field_150362_t, 3, 2);
        }
        for (int k = 0; k < cocoasLength; k += 4) {
            if (rand.nextInt(20) != 0) continue;
            world.func_147465_d(x + cocoas[k + 1], y + cocoas[k + 2], z + cocoas[k + 3], Blocks.field_150375_by, cocoas[k + 0] + 8, 2);
        }
        return true;
    }

    public double getRandomDir(Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return -180.0;
            }
            case 1: {
                return -90.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return 90.0;
            }
        }
        return 0.0;
    }
}

