/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenTreeJungleSmall
extends WorldGenerator {
    private Block blockLog;
    private int metadataLog;
    private Block blockLeaves;
    private int metadataLeaves;
    private int base;
    private int root;
    private float length;
    private int branch;
    private float verStart;
    private float verRand;

    public WorldGenTreeJungleSmall(Block log, int metaLog, Block leaves, int metaLeaves, int baseHeight, int rootHeight, float branchLength, int numBranches, float verticalStart, float verticalRand) {
        this.blockLog = log;
        this.metadataLog = metaLog;
        this.blockLeaves = leaves;
        this.metadataLeaves = metaLeaves;
        this.base = baseHeight;
        this.root = rootHeight;
        this.length = branchLength;
        this.branch = numBranches;
        this.verStart = verticalStart;
        this.verRand = verticalRand;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b != Blocks.field_150349_c && b != Blocks.field_150346_d) {
            return false;
        }
        if ((float)this.root > 0.0f) {
            for (int k = 0; k < 3; ++k) {
                this.generateBranch(world, rand, x, y + this.root, z, 120 * k - 40 + rand.nextInt(80), 1.6f + rand.nextFloat() * 0.1f, (float)this.root * 1.7f, 1.0f);
            }
        }
        for (int i = y + this.root; i < y + this.base; ++i) {
            world.func_147465_d(x, i, z, this.blockLog, this.metadataLog, 2);
        }
        for (int j = 0; j < this.branch; ++j) {
            float horDir = 120 * j - 60 + rand.nextInt(120);
            float verDir = this.verStart + rand.nextFloat() * this.verRand;
            this.generateBranch(world, rand, x, y + this.base, z, horDir, verDir, this.length, 1.0f);
            int eX = x + (int)(Math.cos((double)horDir * Math.PI / 180.0) * (double)verDir * (double)this.length);
            int eZ = z + (int)(Math.sin((double)horDir * Math.PI / 180.0) * (double)verDir * (double)this.length);
            int eY = y + this.base + (int)((1.0f - verDir) * this.length);
            for (int m = 0; m < 1; ++m) {
                this.generateLeaves(world, rand, eX, eY, eZ, 4.0f, 1.5f);
            }
        }
        return true;
    }

    public void generateBranch(World world, Random rand, float x, float y, float z, double horDir, float verDir, float length, float speed) {
        if (verDir < 0.0f) {
            verDir = -verDir;
        }
        float c = 0.0f;
        float velY = 1.0f - verDir;
        if (verDir > 1.0f) {
            verDir = 1.0f - (verDir - 1.0f);
        }
        float velX = (float)Math.cos(horDir * Math.PI / 180.0) * verDir;
        float velZ = (float)Math.sin(horDir * Math.PI / 180.0) * verDir;
        while (c < length) {
            world.func_147465_d((int)x, (int)y, (int)z, this.blockLog, this.metadataLog, 2);
            x += velX;
            y += velY;
            z += velZ;
            c += speed;
        }
    }

    public void generateLeaves(World world, Random rand, int x, int y, int z, float size, float width) {
        int s = (int)(size - 1.0f);
        int w = (int)((size - 1.0f) * width);
        for (int i = -w; i <= w; ++i) {
            for (int j = -s; j <= s; ++j) {
                for (int k = -w; k <= w; ++k) {
                    float dist = Math.abs((float)i / width) + (float)Math.abs(j) + Math.abs((float)k / width);
                    if (!(dist <= size - 0.5f) && (!(dist <= size) || !rand.nextBoolean())) continue;
                    if (dist < 0.6f) {
                        world.func_147465_d(x + i, y + j, z + k, this.blockLog, this.metadataLog, 2);
                    }
                    if (!world.func_147437_c(x + i, y + j, z + k)) continue;
                    world.func_147465_d(x + i, y + j, z + k, this.blockLeaves, this.metadataLeaves, 2);
                }
            }
        }
    }
}

