/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature;

import cpw.mods.fml.common.registry.GameData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.TerrainMath;

public class WorldGenVolcano {
    protected static Block volcanoBlock = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.volcanoBlockId);
    protected static byte volcanoByte = (byte)ConfigRTG.volcanoBlockByte;
    protected static Block lavaBlock = ConfigRTG.enableVolcanoEruptions ? Blocks.field_150356_k : Blocks.field_150353_l;

    public static void build(Block[] blocks, byte[] metadata, World world, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                int y;
                float height;
                int i = chunkX * 16 + x;
                int j = chunkY * 16 + z;
                float distance = (float)TerrainMath.dis2(i, j, baseX * 16, baseY * 16);
                float obsidian = 24.0f + distance + simplex.noise2((float)i / 16.0f, (float)j / 16.0f) * 15.0f;
                if (distance < 10.0f + simplex.noise2((float)i / 3.0f, (float)j / 3.0f) * 1.5f) {
                    height = simplex.noise2((float)i / 5.0f, (float)j / 5.0f) * 2.0f;
                    for (y = 255; y > -1; --y) {
                        if (y > 165) {
                            if (blocks[WorldGenVolcano.cta(x, y, z)] == Blocks.field_150350_a) continue;
                            blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                            continue;
                        }
                        if ((float)y > obsidian && (float)y < 156.0f + height) {
                            blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoBlock;
                            metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoByte;
                            continue;
                        }
                        if (y < 166) {
                            blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = lavaBlock;
                            continue;
                        }
                        if (!((float)y < obsidian + 1.0f)) continue;
                        if (blocks[WorldGenVolcano.cta(x, y, z)] != Blocks.field_150350_a) continue block1;
                        blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150348_b;
                        metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = 0;
                    }
                    continue;
                }
                height = 190.0f - (distance + simplex.noise2((float)i / 12.0f, (float)j / 12.0f) * 5.0f) * 1.7f;
                if (height > noise[x * 16 + z]) {
                    noise[x * 16 + z] = height;
                }
                for (y = 255; y > -1; --y) {
                    if (!((float)y <= height)) continue;
                    Block b = blocks[WorldGenVolcano.cta(x, y, z)];
                    byte meta = metadata[WorldGenVolcano.cta(x, y, z)];
                    if (b != Blocks.field_150350_a) continue block1;
                    if ((float)y > obsidian) {
                        b = volcanoBlock;
                        meta = volcanoByte;
                    } else {
                        b = Blocks.field_150348_b;
                        meta = 0;
                    }
                    blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = b;
                    metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = meta;
                }
            }
        }
    }

    public static int cta(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }
}

