/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CanyonColor;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.MapGenCavesRTG;
import rtg.world.gen.MapGenRavineRTG;

public class ChunkProviderRTG
implements IChunkProvider {
    private final MapGenBase caveGenerator;
    private final MapGenBase ravineGenerator;
    private final MapGenStronghold strongholdGenerator;
    private final MapGenMineshaft mineshaftGenerator;
    private final MapGenVillage villageGenerator;
    private final MapGenScatteredFeature scatteredFeatureGenerator;
    private final boolean mapFeaturesEnabled;
    private final int worldHeight;
    private final int sampleSize = 8;
    private final int sampleArraySize;
    private final int parabolicSize;
    private final int parabolicArraySize;
    private final float[] parabolicField;
    private Block bedrockBlock = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.bedrockBlockId);
    private byte bedrockByte = (byte)ConfigRTG.bedrockBlockByte;
    private Random rand;
    private Random mapRand;
    private World worldObj;
    private WorldChunkManagerRTG cmr;
    private OpenSimplexNoise simplex;
    private CellNoise cell;
    private RealisticBiomeBase[] biomesForGeneration;
    private BiomeGenBase[] baseBiomesList;
    private int[] biomeData;
    private float parabolicFieldTotal;
    private float[][] hugeRender;
    private float[][] smallRender;
    private float[] testHeight;
    private float[] mapGenBiomes;
    private float[] borderNoise;
    private long worldSeed;

    public ChunkProviderRTG(World world, long l) {
        this.worldObj = world;
        this.cmr = (WorldChunkManagerRTG)this.worldObj.func_72959_q();
        this.worldHeight = this.worldObj.field_73011_w.getActualHeight();
        this.rand = new Random(l);
        this.simplex = new OpenSimplexNoise(l);
        this.cell = new CellNoise(l, 0);
        this.cell.setUseDistance(true);
        this.mapRand = new Random(l);
        this.worldSeed = l;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("size", "0");
        m.put("distance", "24");
        this.mapFeaturesEnabled = world.func_72912_H().func_76089_r();
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCavesRTG(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavineRTG(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(m), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        CanyonColor.init(l);
        this.sampleArraySize = 21;
        this.parabolicSize = 8;
        this.parabolicArraySize = this.parabolicSize * 2 + 1;
        this.parabolicField = new float[this.parabolicArraySize * this.parabolicArraySize];
        for (int j = -this.parabolicSize; j <= this.parabolicSize; ++j) {
            for (int k = -this.parabolicSize; k <= this.parabolicSize; ++k) {
                float f;
                this.parabolicField[j + this.parabolicSize + (k + this.parabolicSize) * this.parabolicArraySize] = f = 0.445f / MathHelper.func_76129_c((float)((float)(j * 1 * (j * 1) + k * 1 * (k * 1)) + 0.3f));
                this.parabolicFieldTotal += f;
            }
        }
        this.baseBiomesList = new BiomeGenBase[256];
        this.biomeData = new int[this.sampleArraySize * this.sampleArraySize];
        this.hugeRender = new float[81][256];
        this.smallRender = new float[625][256];
        this.testHeight = new float[256];
        this.mapGenBiomes = new float[257];
        this.borderNoise = new float[256];
    }

    public Chunk func_73154_d(int cx, int cy) {
        int k;
        this.rand.setSeed((long)cx * 341873128712L + (long)cy * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[65536];
        float[] noise = new float[256];
        this.biomesForGeneration = new RealisticBiomeBase[256];
        this.generateTerrain(this.cmr, cx, cy, blocks, metadata, this.biomesForGeneration, noise);
        for (k = 0; k < 256; ++k) {
            if (this.mapGenBiomes[k] > 0.0f) {
                RealisticBiomeBase.getBiome(k).generateMapGen(blocks, metadata, this.worldSeed, this.worldObj, this.cmr, this.mapRand, cx, cy, this.simplex, this.cell, noise);
                this.mapGenBiomes[k] = 0.0f;
            }
            this.baseBiomesList[k] = this.biomesForGeneration[k].baseBiome;
        }
        this.replaceBlocksForBiome(cx, cy, blocks, metadata, this.biomesForGeneration, this.baseBiomesList, noise);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        if (this.mapFeaturesEnabled) {
            if (ConfigRTG.generateMineshafts) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
            if (ConfigRTG.generateStrongholds) {
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
            if (ConfigRTG.generateVillages) {
                this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
            if (ConfigRTG.generateScatteredFeatures) {
                this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
        }
        Chunk chunk = new Chunk(this.worldObj, blocks, metadata, cx, cy);
        byte[] abyte1 = chunk.func_76605_m();
        for (k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.baseBiomesList[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(WorldChunkManagerRTG cmr, int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, float[] n) {
        float[] noise = this.getNewNoise(cmr, cx * 16, cy * 16, biomes);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int h = (int)noise[j * 16 + i];
                for (int k = 0; k < 256; ++k) {
                    int p = (j * 16 + i) * 256 + k;
                    if (k > h) {
                        if (k < 63) {
                            blocks[p] = Blocks.field_150355_j;
                            continue;
                        }
                        blocks[p] = Blocks.field_150350_a;
                        continue;
                    }
                    blocks[p] = Blocks.field_150348_b;
                }
                n[j * 16 + i] = noise[j * 16 + i];
            }
        }
    }

    public float[] getNewNoise(WorldChunkManagerRTG cmr, int x, int y, RealisticBiomeBase[] biomes) {
        int l;
        int k;
        int j;
        int i;
        for (i = -8; i < 13; ++i) {
            for (j = -8; j < 13; ++j) {
                this.biomeData[(i + 8) * this.sampleArraySize + (j + 8)] = cmr.getBiomeDataAt((int)(x + (i * 8 - 8)), (int)(y + (j * 8 - 8))).field_76756_M;
            }
        }
        for (i = -1; i < 4; ++i) {
            for (j = -1; j < 4; ++j) {
                this.hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)] = new float[256];
                for (k = -this.parabolicSize; k <= this.parabolicSize; ++k) {
                    for (l = -this.parabolicSize; l <= this.parabolicSize; ++l) {
                        float[] fArray = this.hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)];
                        int n = this.biomeData[(i + k + 8 + 1) * this.sampleArraySize + (j + l + 8 + 1)];
                        fArray[n] = fArray[n] + this.parabolicField[k + this.parabolicSize + (l + this.parabolicSize) * this.parabolicArraySize] / this.parabolicFieldTotal;
                    }
                }
            }
        }
        RealisticBiomeBase b = null;
        for (i = 0; i < 256; ++i) {
            if (!(this.hugeRender[40][i] > 0.95f)) continue;
            b = RealisticBiomeBase.getBiome(i);
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                this.hugeRender[(i * 2 + 1) * 9 + (j * 2 + 1)] = this.mix4(new float[][]{this.hugeRender[i * 2 * 9 + j * 2], this.hugeRender[(i * 2 + 2) * 9 + j * 2], this.hugeRender[i * 2 * 9 + (j * 2 + 2)], this.hugeRender[(i * 2 + 2) * 9 + (j * 2 + 2)]});
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.smallRender[i * 4 * 25 + j * 4] = !(i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) ? this.mix4(new float[][]{this.hugeRender[i * 9 + (j + 1)], this.hugeRender[(i + 1) * 9 + j], this.hugeRender[(i + 1) * 9 + (j + 2)], this.hugeRender[(i + 2) * 9 + (j + 1)]}) : this.hugeRender[(i + 1) * 9 + (j + 1)];
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                this.smallRender[(i * 4 + 2) * 25 + (j * 4 + 2)] = this.mix4(new float[][]{this.smallRender[i * 4 * 25 + j * 4], this.smallRender[(i * 4 + 4) * 25 + j * 4], this.smallRender[i * 4 * 25 + (j * 4 + 4)], this.smallRender[(i * 4 + 4) * 25 + (j * 4 + 4)]});
            }
        }
        for (i = 0; i < 11; ++i) {
            for (j = 0; j < 11; ++j) {
                if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) continue;
                this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 2)] = this.mix4(new float[][]{this.smallRender[i * 2 * 25 + (j * 2 + 2)], this.smallRender[(i * 2 + 2) * 25 + j * 2], this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 4)], this.smallRender[(i * 2 + 4) * 25 + (j * 2 + 2)]});
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                this.smallRender[(i * 2 + 3) * 25 + (j * 2 + 3)] = this.mix4(new float[][]{this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 2)], this.smallRender[(i * 2 + 4) * 25 + (j * 2 + 2)], this.smallRender[(i * 2 + 2) * 25 + (j * 2 + 4)], this.smallRender[(i * 2 + 4) * 25 + (j * 2 + 4)]});
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) continue;
                this.smallRender[(i + 4) * 25 + (j + 4)] = this.mix4(new float[][]{this.smallRender[(i + 3) * 25 + (j + 4)], this.smallRender[(i + 4) * 25 + (j + 3)], this.smallRender[(i + 4) * 25 + (j + 5)], this.smallRender[(i + 5) * 25 + (j + 4)]});
            }
        }
        boolean randBiome = true;
        float bCount = 0.0f;
        float bRand = 0.0f;
        if (b != null) {
            randBiome = false;
            for (i = 0; i < 256; ++i) {
                biomes[i] = b;
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                if (randBiome) {
                    bCount = 0.0f;
                    bRand = 0.5f + this.simplex.noise2((float)(x + i) / 15.0f, (float)(y + j) / 15.0f);
                    bRand = bRand < 0.0f ? 0.0f : (bRand > 0.99999f ? 0.99999f : bRand);
                }
                l = (i + 4) * 25 + (j + 4);
                this.testHeight[i * 16 + j] = 0.0f;
                float river = cmr.getRiverStrength(x + i, y + j);
                if (l == 312) {
                    this.mapGenBiomes[256] = river;
                }
                for (k = 0; k < 256; ++k) {
                    if (!(this.smallRender[l][k] > 0.0f)) continue;
                    if (randBiome && bCount <= 1.0f && (bCount += this.smallRender[l][k]) > bRand) {
                        biomes[j * 16 + i] = RealisticBiomeBase.getBiome(k);
                        bCount = 2.0f;
                    }
                    if (l == 312) {
                        this.mapGenBiomes[k] = this.smallRender[312][k];
                    }
                    int n = i * 16 + j;
                    this.testHeight[n] = this.testHeight[n] + cmr.calculateRiver(x + i, y + j, river, RealisticBiomeBase.getBiome(k).rNoise(this.simplex, this.cell, x + i, y + j, this.smallRender[l][k], river + 1.0f)) * this.smallRender[l][k];
                }
            }
        }
        return this.testHeight;
    }

    public float[] mix4(float[][] ingredients) {
        float[] result = new float[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!(ingredients[j][i] > 0.0f)) continue;
                int n = i;
                result[n] = result[n] + ingredients[j][i] / 4.0f;
            }
        }
        return result;
    }

    public void replaceBlocksForBiome(int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, BiomeGenBase[] base, float[] n) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, cx, cy, blocks, metadata, base, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                RealisticBiomeBase biome = biomes[i * 16 + j];
                float river = -this.cmr.getRiverStrength(cx * 16 + j, cy * 16 + i);
                if (river > 0.05f && river + this.simplex.noise2((float)(cx * 16 + j) / 10.0f, (float)(cy * 16 + i) / 10.0f) * 0.15f > 0.8f) {
                    base[i * 16 + j] = biome.riverBiome;
                }
                int depth = -1;
                biome.rReplace(blocks, metadata, cx * 16 + j, cy * 16 + i, i, j, depth, this.worldObj, this.rand, this.simplex, this.cell, n, river, base);
                int flatBedrockLayers = ConfigRTG.flatBedrockLayers;
                int n2 = flatBedrockLayers < 0 ? 0 : (flatBedrockLayers = flatBedrockLayers > 5 ? 5 : flatBedrockLayers);
                if (flatBedrockLayers > 0) {
                    for (int bl = 0; bl < flatBedrockLayers; ++bl) {
                        blocks[(j * 16 + i) * 256 + bl] = this.bedrockBlock;
                        metadata[(j * 16 + i) * 256 + bl] = this.bedrockByte;
                    }
                    continue;
                }
                blocks[(j * 16 + i) * 256] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256] = this.bedrockByte;
                int rough = this.rand.nextInt(2);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
                rough = this.rand.nextInt(3);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
                rough = this.rand.nextInt(4);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
                rough = this.rand.nextInt(5);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    private double[] func_4061_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return null;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        RealisticBiomeBase biome = this.cmr.getBiomeDataAt(worldX + 16, worldZ + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        boolean gen = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, flag));
        if (this.mapFeaturesEnabled) {
            if (ConfigRTG.generateMineshafts) {
                this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
            if (ConfigRTG.generateStrongholds) {
                this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
            if (ConfigRTG.generateVillages) {
                flag = this.villageGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
            if (ConfigRTG.generateScatteredFeatures) {
                this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
        }
        biome.rPopulatePreDecorate(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, flag);
        for (int bx = -4; bx <= 4; ++bx) {
            for (int by = -4; by <= 4; ++by) {
                int n = this.cmr.getBiomeDataAt((int)(worldX + 24 + bx * 16), (int)(worldZ + 24 + by * 16)).field_76756_M;
                this.borderNoise[n] = this.borderNoise[n] + 0.01234569f;
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.rand, worldX, worldZ));
        float river = -this.cmr.getRiverStrength(worldX + 16, worldZ + 16);
        biome.rDecorateClay(this.worldObj, this.rand, chunkX, chunkZ, river, worldX, worldZ);
        biome.rGenerateOres(this.worldObj, this.rand, worldX, worldZ);
        float snow = 0.0f;
        for (int bn = 0; bn < 256; ++bn) {
            if (!(this.borderNoise[bn] > 0.0f)) continue;
            if (this.borderNoise[bn] >= 1.0f) {
                this.borderNoise[bn] = 1.0f;
            }
            RealisticBiomeBase b = RealisticBiomeBase.getBiome(bn);
            b.rDecorate(this.worldObj, this.rand, worldX, worldZ, this.simplex, this.cell, this.borderNoise[bn], river);
            snow = b.baseBiome.field_76750_F < 0.15f ? (snow -= 0.6f * this.borderNoise[bn]) : (snow += 0.6f * this.borderNoise[bn]);
            this.borderNoise[bn] = 0.0f;
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.rand, worldX, worldZ));
        if (this.rand.nextInt(100) == 0) {
            for (int l18 = 0; l18 < 50; ++l18) {
                int l21 = worldX + this.rand.nextInt(16) + 8;
                int k23 = this.rand.nextInt(this.rand.nextInt(this.worldHeight - 16) + 10);
                int l24 = worldZ + this.rand.nextInt(16) + 8;
                new WorldGenLiquids((Block)Blocks.field_150358_i).func_76484_a(this.worldObj, this.rand, l21, k23, l24);
            }
        }
        if (this.rand.nextInt(100) == 0) {
            for (int i19 = 0; i19 < 20; ++i19) {
                int i22 = worldX + this.rand.nextInt(16) + 8;
                int l23 = this.rand.nextInt(this.worldHeight / 2);
                int i25 = worldZ + this.rand.nextInt(16) + 8;
                new WorldGenLiquids((Block)Blocks.field_150356_k).func_76484_a(this.worldObj, this.rand, i22, l23, i25);
            }
        }
        if (TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)this.worldObj.func_72807_a(worldX + 16, worldZ + 16), (int)(worldX + 8), (int)(worldZ + 8), (int)16, (int)16, (Random)this.rand);
        }
        if (TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k1 = 0; k1 < 16; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    int i2 = this.worldObj.func_72874_g(worldX + k1, worldZ + l1);
                    if (this.worldObj.func_72884_u(k1 + worldX, i2 - 1, l1 + worldZ)) {
                        this.worldObj.func_147465_d(k1 + worldX, i2 - 1, l1 + worldZ, Blocks.field_150432_aD, 0, 2);
                    }
                    if (!ConfigRTG.enableSnowLayers || !this.worldObj.func_147478_e(k1 + worldX, i2, l1 + worldZ, true)) continue;
                    this.worldObj.func_147465_d(k1 + worldX, i2, l1 + worldZ, Blocks.field_150431_aC, 0, 2);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "ChunkProviderRTG";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        if (!ConfigRTG.generateStrongholds) {
            return null;
        }
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        if (this.mapFeaturesEnabled) {
            if (ConfigRTG.generateMineshafts) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
            if (ConfigRTG.generateStrongholds) {
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
            if (ConfigRTG.generateVillages) {
                this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
            if (ConfigRTG.generateScatteredFeatures) {
                this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
        }
    }

    public void func_104112_b() {
    }
}

