/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreePineSmall;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.feature.tree.WorldGenTreeSpruceSmall;
import rtg.world.gen.surface.vanilla.SurfaceVanillaTaigaM;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaTaigaM;

public class RealisticBiomeVanillaTaigaM
extends RealisticBiomeVanillaBase {
    public static BiomeGenBase standardBiome = BiomeGenBase.field_76768_g;
    public static BiomeGenBase mutationBiome = BiomeGenBase.func_150568_d((int)(RealisticBiomeVanillaTaigaM.standardBiome.field_76756_M + 128));
    public static Block topBlock = RealisticBiomeVanillaTaigaM.mutationBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeVanillaTaigaM.mutationBiome.field_76753_B;

    public RealisticBiomeVanillaTaigaM() {
        super(mutationBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.COLD), (TerrainBase)new TerrainVanillaTaigaM(70.0f, 180.0f, 7.0f, 100.0f, 38.0f, 160.0f, 68.0f), new SurfaceVanillaTaigaM(topBlock, fillerBlock));
        this.setRealisticBiomeName("Vanilla Taiga M");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaTaigaM;
        this.generateVillages = ConfigVanilla.villageVanillaTaigaM;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int l = 0;
        while ((float)l < 3.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && rand.nextInt(16) == 0) {
                new WorldGenBlob(Blocks.field_150341_Y, 0, rand).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        float l2 = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
        int b1 = 0;
        while ((float)b1 < l2 * 4.0f * strength) {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            WorldGenerator worldgenerator = rand.nextInt(4) == 0 ? new WorldGenTreeSpruceSmall(1 + rand.nextInt(2)) : (rand.nextInt(6) == 0 ? new WorldGenTreePineSmall(1 + rand.nextInt(3), 4 + rand.nextInt(4)) : new WorldGenTreePineSmall(4 + rand.nextInt(6), 5 + rand.nextInt(10)));
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            ++b1;
        }
        if (l2 > 0.0f && rand.nextInt(6) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        int b = 0;
        while ((float)b < 2.0f * strength) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(10) == 0) {
                new WorldGenTreeShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
            } else {
                new WorldGenTreeShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
            }
            ++b;
        }
        if (rand.nextInt((int)(3.0f / strength)) == 0) {
            int k15 = chunkX + rand.nextInt(16) + 8;
            int k17 = rand.nextInt(64) + 64;
            int k20 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextBoolean()) {
                new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(world, rand, k15, k17, k20);
            } else {
                new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(world, rand, k15, k17, k20);
            }
        }
        if (rand.nextInt((int)(20.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(128);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int l14 = 0;
        while ((float)l14 < 10.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }
}

