/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenCacti;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.tree.WorldGenTreeSavanna;
import rtg.world.gen.surface.vanilla.SurfaceVanillaSavannaPlateau;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaSavannaPlateau;

public class RealisticBiomeVanillaSavannaPlateau
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_150587_Y.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_150587_Y.field_76753_B;

    public RealisticBiomeVanillaSavannaPlateau() {
        super(BiomeGenBase.field_150587_Y, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainVanillaSavannaPlateau(true, 35.0f, 160.0f, 60.0f, 40.0f, 69.0f), new SurfaceVanillaSavannaPlateau(topBlock, fillerBlock, 0, 0));
        this.setRealisticBiomeName("Vanilla Savanna Plateau");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaSavannaPlateau;
        this.generateVillages = ConfigVanilla.villageVanillaSavannaPlateau;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        for (int i23 = 0; i23 < 1; ++i23) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(4) != 0 || k1 >= 80 && k1 <= 110) continue;
            if (rand.nextBoolean()) {
                new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
                continue;
            }
            new WorldGenBlockBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (river > 0.7f) {
            if (river > 0.86f) {
                int b33 = 0;
                while ((float)b33 < 10.0f * strength) {
                    int k10;
                    int j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if ((float)z52 < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0) {
                        Object worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : new WorldGenTreeSavanna(1);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b33;
                }
            }
            int k18 = 0;
            while ((float)k18 < 12.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        } else {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            if (rand.nextInt(3) == 0) {
                Object worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : new WorldGenTreeSavanna(1);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            for (int k18 = 0; k18 < 70; ++k18) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = 64 + rand.nextInt(64);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(8) != 0) continue;
                new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = 63 + rand.nextInt(160);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        }
    }
}

